/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.esa.cci.lc.io.CoordinateEncoder;
import org.esa.cci.lc.io.LcWriterUtils;
import org.esa.cci.lc.io.PlateCarreeCoordinateEncoder;
import org.esa.cci.lc.io.RegionalPlanetaryGrid;
import org.esa.cci.lc.io.RegularGaussianCoordinateEncoder;
import org.esa.cci.lc.util.LcHelper;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.operator.BinWriter;
import org.esa.snap.binning.support.PlateCarreeGrid;
import org.esa.snap.binning.support.RegularGaussianGrid;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.logging.BeamLogManager;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.nc.NWritableFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;

public class LcBinWriter
implements BinWriter {
    private static final float FILL_VALUE = Float.NaN;
    private final Map<String, String> lcProperties;
    private Logger logger;
    private String targetFilePath;
    private BinningContext binningContext;
    private PlanetaryGrid planetaryGrid;
    private ReferencedEnvelope region;

    public LcBinWriter(Map<String, String> lcProperties, ReferencedEnvelope region) {
        this.lcProperties = lcProperties;
        this.logger = BeamLogManager.getSystemLogger();
        this.region = region;
    }

    public void setBinningContext(BinningContext binningContext) {
        this.binningContext = binningContext;
        this.planetaryGrid = this.region != null ? new RegionalPlanetaryGrid(binningContext.getPlanetaryGrid(), this.region) : binningContext.getPlanetaryGrid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Map<String, String> metadataProperties, List<TemporalBin> temporalBins) throws IOException {
        try (NFileWriteable writeable = NWritableFactory.create((String)this.targetFilePath, (String)"netcdf4");){
            int sceneWidth = this.planetaryGrid.getNumCols(0);
            int sceneHeight = this.planetaryGrid.getNumRows();
            Dimension tileSize = LcHelper.convertToDimension(this.lcProperties.get("TileSize"));
            writeable.addDimension("lat", sceneHeight);
            writeable.addDimension("lon", sceneWidth);
            this.logger.info("output with extent " + sceneHeight + ":" + sceneWidth + " and chunksize " + tileSize);
            this.addGlobalAttributes(writeable);
            CoordinateEncoder coordinateEncoder = this.createCoordinateEncoder();
            coordinateEncoder.addCoordVars(writeable);
            ArrayList<NVariable> variables = this.addFeatureVariables(writeable, tileSize);
            writeable.create();
            this.fillVariables(temporalBins, variables, sceneWidth, sceneHeight);
            coordinateEncoder.fillCoordinateVars(writeable);
        }
    }

    private CoordinateEncoder createCoordinateEncoder() {
        if (this.isGridImplementationUsed(RegularGaussianGrid.class)) {
            return new RegularGaussianCoordinateEncoder(this.planetaryGrid);
        }
        if (this.isGridImplementationUsed(PlateCarreeGrid.class)) {
            return new PlateCarreeCoordinateEncoder(this.planetaryGrid);
        }
        throw new IllegalStateException("Unknown planetary grid");
    }

    private boolean isGridImplementationUsed(Class<? extends PlanetaryGrid> gridClass) {
        boolean isGaussianGrid = this.planetaryGrid.getClass().isAssignableFrom(gridClass);
        if (!isGaussianGrid && this.planetaryGrid.getClass().isAssignableFrom(RegionalPlanetaryGrid.class)) {
            RegionalPlanetaryGrid grid = (RegionalPlanetaryGrid)this.planetaryGrid;
            isGaussianGrid = grid.getGlobalGrid().getClass().isAssignableFrom(gridClass);
        }
        return isGaussianGrid;
    }

    public void setTargetFileTemplatePath(String targetFileTemplatePath) {
        this.targetFilePath = FileUtils.ensureExtension((String)targetFileTemplatePath, (String)".nc");
    }

    public String getTargetFilePath() {
        return this.targetFilePath;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private void addGlobalAttributes(NFileWriteable writeable) throws IOException {
        String aggregationType = String.valueOf(this.lcProperties.remove("aggregationType"));
        writeable.addGlobalAttribute("title", String.format("ESA CCI Land Cover %s Aggregated", aggregationType));
        writeable.addGlobalAttribute("summary", "This dataset contains the global ESA CCI land cover products which are spatially aggregated by the lc-user-tool.");
        writeable.addGlobalAttribute("type", this.lcProperties.remove("type"));
        writeable.addGlobalAttribute("id", this.lcProperties.remove("id"));
        LcWriterUtils.addGenericGlobalAttributes(writeable, this.lcProperties.remove("TileSize"));
        LcWriterUtils.addSpecificGlobalAttributes(this.lcProperties.remove("source"), this.lcProperties.remove("history"), this.lcProperties.remove("spatialResolutionDegrees"), this.lcProperties.remove("spatialResolution"), this.lcProperties.remove("temporalCoverageYears"), this.lcProperties.remove("temporalResolution"), "Map".equals(aggregationType) ? "Y" : "D", this.lcProperties.remove("startTime"), this.lcProperties.remove("endTime"), this.lcProperties.remove("version"), this.lcProperties.remove("latMax"), this.lcProperties.remove("latMin"), this.lcProperties.remove("lonMin"), this.lcProperties.remove("lonMax"), writeable, "University catholique de Louvain");
        for (Map.Entry<String, String> lcPropEntry : this.lcProperties.entrySet()) {
            writeable.addGlobalAttribute(lcPropEntry.getKey(), lcPropEntry.getValue());
        }
    }

    private ArrayList<NVariable> addFeatureVariables(NFileWriteable writeable, Dimension tileSize) throws IOException {
        int aggregatorCount = this.binningContext.getBinManager().getAggregatorCount();
        ArrayList<NVariable> featureVars = new ArrayList<NVariable>(60);
        for (int i = 0; i < aggregatorCount; ++i) {
            String[] featureNames;
            Aggregator aggregator = this.binningContext.getBinManager().getAggregator(i);
            for (String featureName : featureNames = aggregator.getOutputFeatureNames()) {
                NVariable featureVar = writeable.addVariable(featureName, DataType.FLOAT, tileSize, writeable.getDimensions());
                Attribute attribute = featureVar.addAttribute("_FillValue", (Number)Float.valueOf(Float.NaN));
                featureVars.add(featureVar);
            }
        }
        return featureVars;
    }

    private void fillVariables(List<TemporalBin> temporalBins, ArrayList<NVariable> variables, int sceneWidth, int sceneHeight) throws IOException {
        Iterator<TemporalBin> iterator = temporalBins.iterator();
        ProductData.Float[] dataLines = new ProductData.Float[variables.size()];
        this.initDataLines(variables, sceneWidth, dataLines);
        int lineY = 0;
        int hundredthHeight = Math.max(sceneHeight / 100, 100);
        while (iterator.hasNext()) {
            int binY;
            int binX;
            TemporalBin temporalBin = iterator.next();
            long binIndex = temporalBin.getIndex();
            if (this.planetaryGrid instanceof RegionalPlanetaryGrid) {
                RegionalPlanetaryGrid regionalGrid = (RegionalPlanetaryGrid)this.planetaryGrid;
                if (!regionalGrid.isBinIndexInRegionalGrid(binIndex)) continue;
                int baseGridWidth = regionalGrid.getGlobalGrid().getNumCols(0);
                binX = (int)(binIndex % (long)baseGridWidth);
                binY = (int)(binIndex / (long)baseGridWidth);
                binX -= regionalGrid.getColumnOffset();
                binY -= regionalGrid.getRowOffset();
            } else {
                binX = (int)(binIndex % (long)sceneWidth);
                binY = (int)(binIndex / (long)sceneWidth);
            }
            WritableVector resultVector = temporalBin.toVector();
            if (binY != lineY) {
                lineY = this.writeDataLine(variables, sceneWidth, dataLines, lineY);
                if ((lineY = this.writeEmptyLines(variables, sceneWidth, dataLines, lineY, binY)) % hundredthHeight == 0) {
                    this.logger.info(String.format("Line %d of %d done", lineY, sceneHeight));
                }
            }
            for (int i = 0; i < variables.size(); ++i) {
                dataLines[i].setElemFloatAt(binX, resultVector.get(i));
            }
        }
        lineY = this.writeDataLine(variables, sceneWidth, dataLines, lineY);
        this.writeEmptyLines(variables, sceneWidth, dataLines, lineY, sceneHeight);
    }

    private int writeEmptyLines(ArrayList<NVariable> variables, int sceneWidth, ProductData.Float[] dataLines, int lastY, int y) throws IOException {
        this.initDataLines(variables, sceneWidth, dataLines);
        while (lastY < y) {
            this.writeDataLine(variables, sceneWidth, dataLines, lastY);
            ++lastY;
        }
        return lastY;
    }

    private int writeDataLine(ArrayList<NVariable> variables, int sceneWidth, ProductData.Float[] dataLines, int y) throws IOException {
        for (int i = 0; i < variables.size(); ++i) {
            NVariable variable = variables.get(i);
            variable.write(0, y, sceneWidth, 1, false, (ProductData)dataLines[i]);
        }
        return y + 1;
    }

    private void initDataLines(ArrayList<NVariable> variables, int sceneWidth, ProductData.Float[] dataLines) {
        for (int i = 0; i < variables.size(); ++i) {
            if (dataLines[i] != null) {
                Arrays.fill(dataLines[i].getArray(), Float.NaN);
                continue;
            }
            float[] line = new float[sceneWidth];
            Arrays.fill(line, Float.NaN);
            dataLines[i] = new ProductData.Float(line);
        }
    }
}

