/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.esa.cci.lc.io.LcCdsNetCDF4WriterPlugin;
import org.esa.cci.lc.io.LcWriterUtils;
import org.esa.cci.lc.io.RegionalPlanetaryGrid;
import org.esa.cci.lc.util.CdsVariableWriter;
import org.esa.cci.lc.util.LcHelper;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.operator.BinWriter;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.logging.BeamLogManager;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.nc.NWritableFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;

public class LcCdsBinWriter
implements BinWriter {
    private String targetFilePath;
    private PlanetaryGrid planetaryGrid;
    private MetadataElement element;
    private static final float FILL_VALUE = Float.NaN;
    private BinningContext binningContext;
    private Logger logger;
    private ReferencedEnvelope region;
    private Map<String, String> lcProperties;

    public LcCdsBinWriter(Map<String, String> lcProperties, ReferencedEnvelope region, MetadataElement element) {
        this.lcProperties = lcProperties;
        this.element = element;
        this.logger = BeamLogManager.getSystemLogger();
        this.region = region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Map<String, String> metadataProperties, List<TemporalBin> temporalBins) throws IOException {
        try (NFileWriteable writeable = NWritableFactory.create((String)this.targetFilePath, (String)"netcdf4");){
            int sceneWidth = this.planetaryGrid.getNumCols(0);
            int sceneHeight = this.planetaryGrid.getNumRows();
            Dimension tileSize = new Dimension(2025, 2025);
            writeable.addDimension("lat", sceneHeight);
            writeable.addDimension("lon", sceneWidth);
            writeable.addDimension("time", 1);
            writeable.addDimension("bounds", 2);
            this.writeLCGlobalAttribute(writeable, this.element);
            LcCdsNetCDF4WriterPlugin.addCustomVariable(writeable, "lon", "lon", DataType.DOUBLE, null, this.element);
            LcCdsNetCDF4WriterPlugin.addCustomVariable(writeable, "lat", "lat", DataType.DOUBLE, null, this.element);
            LcCdsNetCDF4WriterPlugin.addCustomVariable(writeable, "lat_bounds", "lat bounds", DataType.DOUBLE, null, this.element);
            LcCdsNetCDF4WriterPlugin.addCustomVariable(writeable, "lon_bounds", "lon bounds", DataType.DOUBLE, null, this.element);
            LcCdsNetCDF4WriterPlugin.addCustomVariable(writeable, "time_bounds", "time bounds", DataType.DOUBLE, null, this.element);
            LcCdsNetCDF4WriterPlugin.addCustomVariable(writeable, "time", "time", DataType.DOUBLE, null, this.element);
            ArrayList<NVariable> variables = this.addFeatureVariables(writeable, tileSize);
            writeable.create();
            CdsVariableWriter.timeWriter(writeable, this.element);
            Double latMin = this.element.getAttributeDouble("geospatial_lat_min");
            Double latMax = this.element.getAttributeDouble("geospatial_lat_max");
            Double lonMin = this.element.getAttributeDouble("geospatial_lon_min");
            Double lonMax = this.element.getAttributeDouble("geospatial_lon_max");
            CdsVariableWriter.lcLatLonCustomBoundsWriter(writeable, sceneHeight, sceneWidth, lonMin, lonMax, latMin, latMax);
            this.fillVariables(temporalBins, variables, sceneWidth, sceneHeight, writeable);
        }
    }

    private void fillVariables(List<TemporalBin> temporalBins, ArrayList<NVariable> variables, int sceneWidth, int sceneHeight, NFileWriteable writeable) throws IOException {
        Iterator<TemporalBin> iterator = temporalBins.iterator();
        ProductData.Float[] dataLines = new ProductData.Float[variables.size()];
        this.initDataLines(variables, sceneWidth, dataLines);
        int lineY = 0;
        int hundredthHeight = Math.max(sceneHeight / 100, sceneHeight);
        while (iterator.hasNext()) {
            int binY;
            int binX;
            TemporalBin temporalBin = iterator.next();
            long binIndex = temporalBin.getIndex();
            if (this.planetaryGrid instanceof RegionalPlanetaryGrid) {
                RegionalPlanetaryGrid regionalGrid = (RegionalPlanetaryGrid)this.planetaryGrid;
                if (!regionalGrid.isBinIndexInRegionalGrid(binIndex)) continue;
                int baseGridWidth = regionalGrid.getGlobalGrid().getNumCols(0);
                binX = (int)(binIndex % (long)baseGridWidth);
                binY = (int)(binIndex / (long)baseGridWidth);
                binX -= regionalGrid.getColumnOffset();
                binY -= regionalGrid.getRowOffset();
            } else {
                binX = (int)(binIndex % (long)sceneWidth);
                binY = (int)(binIndex / (long)sceneWidth);
            }
            WritableVector resultVector = temporalBin.toVector();
            if (binY != lineY) {
                lineY = this.writeDataLine(variables, sceneWidth, dataLines, lineY, writeable);
                if ((lineY = this.writeEmptyLines(variables, sceneWidth, dataLines, lineY, binY, writeable)) % hundredthHeight == 0) {
                    this.logger.info(String.format("Line %d of %d done", lineY, sceneHeight));
                }
            }
            for (int i = 0; i < variables.size(); ++i) {
                dataLines[i].setElemFloatAt(binX, resultVector.get(i));
            }
        }
        lineY = this.writeDataLine(variables, sceneWidth, dataLines, lineY, writeable);
        this.writeEmptyLines(variables, sceneWidth, dataLines, lineY, sceneHeight, writeable);
    }

    private int writeEmptyLines(ArrayList<NVariable> variables, int sceneWidth, ProductData.Float[] dataLines, int lastY, int y, NFileWriteable writeable) throws IOException {
        this.initDataLines(variables, sceneWidth, dataLines);
        while (lastY < y) {
            this.writeDataLine(variables, sceneWidth, dataLines, lastY, writeable);
            ++lastY;
        }
        return lastY;
    }

    private int writeDataLine(ArrayList<NVariable> variables, int sceneWidth, ProductData.Float[] dataLines, int y, NFileWriteable writeable) throws IOException {
        for (int i = 0; i < variables.size(); ++i) {
            NVariable variable = variables.get(i);
            Variable netVariable = writeable.getWriter().findVariable(variable.getName());
            int[] origin = new int[]{0, y, 0};
            Array data = Array.factory((DataType)netVariable.getDataType(), (int[])new int[]{1, 1, sceneWidth}, (Object)dataLines[i].getArray());
            try {
                writeable.getWriter().write(netVariable, origin, data);
                continue;
            }
            catch (InvalidRangeException invalidRangeException) {
                // empty catch block
            }
        }
        return y + 1;
    }

    private void initDataLines(ArrayList<NVariable> variables, int sceneWidth, ProductData.Float[] dataLines) {
        for (int i = 0; i < variables.size(); ++i) {
            if (dataLines[i] != null) {
                Arrays.fill(dataLines[i].getArray(), Float.NaN);
                continue;
            }
            float[] line = new float[sceneWidth];
            Arrays.fill(line, Float.NaN);
            dataLines[i] = new ProductData.Float(line);
        }
    }

    private ArrayList<NVariable> addFeatureVariables(NFileWriteable writeable, Dimension tileSize) throws IOException {
        int aggregatorCount = this.binningContext.getBinManager().getAggregatorCount();
        ArrayList<NVariable> featureVars = new ArrayList<NVariable>(60);
        for (int i = 0; i < aggregatorCount; ++i) {
            String[] featureNames;
            Aggregator aggregator = this.binningContext.getBinManager().getAggregator(i);
            for (String featureName : featureNames = aggregator.getOutputFeatureNames()) {
                NVariable featureVar = writeable.addVariable(featureName, DataType.FLOAT, tileSize, "time lat lon");
                Attribute attribute = featureVar.addAttribute("_FillValue", (Number)Float.valueOf(Float.NaN));
                featureVars.add(featureVar);
            }
        }
        return featureVars;
    }

    public void setBinningContext(BinningContext binningContext) {
        this.binningContext = binningContext;
        this.planetaryGrid = this.region != null ? new RegionalPlanetaryGrid(binningContext.getPlanetaryGrid(), this.region) : binningContext.getPlanetaryGrid();
    }

    public void setTargetFileTemplatePath(String targetFileTemplatePath) {
        this.targetFilePath = FileUtils.ensureExtension((String)targetFileTemplatePath, (String)".nc");
    }

    public String getTargetFilePath() {
        return this.targetFilePath;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private void writeLCGlobalAttribute(NFileWriteable writeable, MetadataElement element) throws IOException {
        Dimension tileSize = new Dimension(2025, 2025);
        String history = element.getAttributeString("history");
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "id", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "title", "Land Cover Map of ESA CCI brokered by CDS");
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "summary", "This dataset characterizes the land cover of a particular year (see time_coverage). The land cover was derived from the analysis of satellite data time series of the full period.");
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "type", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "project", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "references", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "institution", "UCLouvain");
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "contact", "https://www.ecmwf.int/en/about/contact-us/get-support");
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "comment", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "Conventions", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "standard_name_vocabulary", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "keywords", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "keywords_vocabulary", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "license", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "naming_authority", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "cdm_data_type", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "TileSize", LcHelper.format(tileSize));
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "tracking_id", UUID.randomUUID().toString());
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "product_version", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "creation_date", LcWriterUtils.COMPACT_ISO_FORMAT.format(new Date()));
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "creator_name", "UCLouvain");
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "creator_url", "http://www.uclouvain.be/");
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "creator_email", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "source", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "history", history + ",lc-user-tools-" + LcWriterUtils.getModuleVersion());
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "time_coverage_start", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "time_coverage_end", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "time_coverage_duration", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "time_coverage_resolution", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "geospatial_lat_min", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "geospatial_lat_max", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "geospatial_lon_min", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "geospatial_lon_max", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "spatial_resolution", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "geospatial_lat_units", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "geospatial_lat_resolution", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "geospatial_lon_units", null);
        LcCdsNetCDF4WriterPlugin.addGlobalAttribute(writeable, element, "geospatial_lon_resolution", null);
    }
}

