/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.esa.cci.lc.io.LcCdsTiffReaderPlugin;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;

public class LcCdsTiffReader
extends AbstractProductReader {
    public static final String LC_CONDITION_FILENAME_PATTERN = "(........)-ESACCI-L3S_FIRE-BA-MODIS-AREA_(.)-fv5.(.)-LC.tif";
    public static final String LC_ALTERNATIVE_CONDITION_FILENAME_PATTERN = "(........)-ESACCI-L3S_FIRE-BA-OLCI-AREA_(.)-fv1.(.)-LC.tif";
    private List<Product> bandProducts;

    public LcCdsTiffReader(LcCdsTiffReaderPlugin readerPlugin) {
        super((ProductReaderPlugIn)readerPlugin);
    }

    protected Product readProductNodesImpl() throws IOException {
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        File lcConditionFile = LcCdsTiffReader.getFileInput(this.getInput());
        this.bandProducts = new ArrayList<Product>();
        String lcConditionFilename = lcConditionFile.getName();
        String jdConditionFilename = lcConditionFilename.replace("LC.tif", "JD.tif");
        String clConditionFilename = lcConditionFilename.replace("LC.tif", "CL.tif");
        File productDir = lcConditionFile.getParentFile();
        Product lcConditionProduct = LcCdsTiffReader.readProduct(productDir, lcConditionFilename, (ProductReaderPlugIn)plugIn);
        Product jdConditionProduct = LcCdsTiffReader.readProduct(productDir, jdConditionFilename, (ProductReaderPlugIn)plugIn);
        Product clConditionProduct = LcCdsTiffReader.readProduct(productDir, clConditionFilename, (ProductReaderPlugIn)plugIn);
        lcConditionProduct.setPreferredTileSize(2025, 2025);
        clConditionProduct.setPreferredTileSize(2025, 2025);
        jdConditionProduct.setPreferredTileSize(2025, 2025);
        if (lcConditionProduct == null) {
            throw new IllegalStateException("Could not read product file: " + lcConditionFile.getAbsolutePath());
        }
        Product result = new Product("Pixel_product", "CF-1.6", lcConditionProduct.getSceneRasterWidth(), lcConditionProduct.getSceneRasterHeight());
        result.setFileLocation(lcConditionFile);
        GeoCoding geoCoding = lcConditionProduct.getSceneGeoCoding();
        GeoPos upperLeft = geoCoding.getGeoPos(new PixelPos(0.0, 0.0), null);
        GeoPos lowerRight = geoCoding.getGeoPos(new PixelPos((double)lcConditionProduct.getSceneRasterWidth(), (double)lcConditionProduct.getSceneRasterHeight()), null);
        String latMax = String.valueOf(upperLeft.getLat());
        String latMin = String.valueOf(lowerRight.getLat());
        String lonMin = String.valueOf(upperLeft.getLon());
        String lonMax = String.valueOf(lowerRight.getLon());
        result.getMetadataRoot().addElement(new MetadataElement("global_attributes"));
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("product_version", "v5.0");
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("type", "pixel_product");
        result.getMetadataRoot().getElement("global_attributes").setAttributeDouble("geospatial_lat_min", Double.parseDouble(latMin));
        result.getMetadataRoot().getElement("global_attributes").setAttributeDouble("geospatial_lat_max", Double.parseDouble(latMax));
        result.getMetadataRoot().getElement("global_attributes").setAttributeDouble("geospatial_lon_min", Double.parseDouble(lonMin));
        result.getMetadataRoot().getElement("global_attributes").setAttributeDouble("geospatial_lon_max", Double.parseDouble(lonMax));
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("time_coverage_duration", "P31D");
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("time_coverage_resolution", "P31D");
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("sensor", "MODIS");
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("spatial_resolution", "250m");
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("geospatial_lon_resolution", "0.0022457331");
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("geospatial_lat_resolution", "0.0022457331");
        String timeYear = lcConditionProduct.getFileLocation().getName().substring(0, 4);
        String timeMonth = lcConditionProduct.getFileLocation().getName().substring(4, 6);
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(timeYear), Integer.parseInt(timeMonth) - 1, 1);
        String lastDay = Integer.toString(calendar.getActualMaximum(5));
        String startObservation = timeYear + timeMonth + "01T000000Z";
        String endObservation = timeYear + timeMonth + lastDay + "T235959Z";
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("time_coverage_start", startObservation);
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("time_coverage_end", endObservation);
        this.bandProducts.add(lcConditionProduct);
        Band bandJD = LcCdsTiffReader.addBand("JD", jdConditionProduct, result);
        Band bandCL = LcCdsTiffReader.addBand("CL", clConditionProduct, result);
        Band bandLC = LcCdsTiffReader.addBand("LC", lcConditionProduct, result);
        bandLC.setDescription("LC");
        bandJD.setDescription("JD");
        bandCL.setDescription("CL");
        return result;
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException();
    }

    private static Product readProduct(File productDir, String lcFlagFilename, ProductReaderPlugIn plugIn) throws IOException {
        File bandFile = new File(productDir, lcFlagFilename);
        if (!bandFile.canRead()) {
            return null;
        }
        ProductReader productReader1 = plugIn.createReaderInstance();
        return productReader1.readProductNodes((Object)bandFile, null);
    }

    private static File getFileInput(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        throw new IllegalArgumentException("unexpected class " + input.getClass() + " of the input");
    }

    private static Band addBand(String bandName, Product lcFlagProduct, Product result) {
        Band srcBand = lcFlagProduct.getBandAt(0);
        Band band = result.addBand(bandName, srcBand.getDataType());
        band.setNoDataValueUsed(false);
        band.setSourceImage(srcBand.getSourceImage());
        return band;
    }

    public void close() throws IOException {
        for (Product bandProduct : this.bandProducts) {
            bandProduct.closeIO();
        }
        this.bandProducts.clear();
        super.close();
    }
}

