/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.cci.lc.io.LcConditionTiffReader;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;

public class LcCondMetadata {
    private static final String LC_CONDITION_ID_PATTERN = "ESACCI-LC-L4-(.*)-Cond-(.*m)-P(.*)Y(.*)D-[aggregated]?-?.*?-?(....)(....)-v(.*)";
    private static final String LC_ALTERNATIVE_CONDITION_ID_PATTERN = "C3S-LC-L4-(.*)-Map-(.*m)-P(.*)Y-(.*)-v(.*)";
    private String type;
    private String id;
    private String condition;
    private String spatialResolution;
    private String temporalResolution;
    private String startYear;
    private String endYear;
    private String startDate;
    private String version;

    public LcCondMetadata(Product product) {
        if (product.getProductReader() instanceof LcConditionTiffReader) {
            MetadataElement metadataRoot = product.getMetadataRoot();
            if (metadataRoot.containsAttribute("type")) {
                this.type = metadataRoot.getAttributeString("type");
            }
            if (metadataRoot.containsAttribute("id")) {
                this.id = metadataRoot.getAttributeString("id");
            }
            this.condition = metadataRoot.getAttributeString("condition");
            this.spatialResolution = metadataRoot.getAttributeString("spatialResolution");
            this.temporalResolution = metadataRoot.getAttributeString("temporalResolution");
            this.startYear = metadataRoot.getAttributeString("startYear");
            this.endYear = metadataRoot.getAttributeString("endYear");
            this.startDate = metadataRoot.getAttributeString("startDate");
            this.version = metadataRoot.getAttributeString("version");
        } else if (product.getName().contains("C3S-LC-L4")) {
            MetadataElement globalAttributes = product.getMetadataRoot().getElement("Global_Attributes");
            this.type = globalAttributes.getAttributeString("type");
            this.id = globalAttributes.getAttributeString("id");
            Matcher idMatcher = LcCondMetadata.lcConditionTypeMatcher(this.id);
            this.condition = " ";
            this.spatialResolution = globalAttributes.getAttributeString("spatial_resolution");
            this.temporalResolution = globalAttributes.getAttributeString("time_coverage_resolution");
            this.startYear = idMatcher.group(3);
            this.endYear = idMatcher.group(3);
            this.startDate = this.startYear + "0101";
            this.version = idMatcher.group(4);
        } else {
            MetadataElement globalAttributes = product.getMetadataRoot().getElement("Global_Attributes");
            this.type = globalAttributes.getAttributeString("type");
            this.id = globalAttributes.getAttributeString("id");
            Matcher idMatcher = LcCondMetadata.lcConditionTypeMatcher(this.id);
            this.condition = idMatcher.group(1);
            this.spatialResolution = idMatcher.group(2);
            int temporalCoverage = Integer.parseInt(idMatcher.group(3));
            this.temporalResolution = idMatcher.group(4);
            this.startYear = idMatcher.group(5);
            this.endYear = String.valueOf(Integer.parseInt(this.startYear) + temporalCoverage - 1);
            this.startDate = this.startYear + idMatcher.group(6);
            this.version = idMatcher.group(7);
        }
    }

    static Matcher lcConditionTypeMatcher(String id) {
        String regexp = id.contains("ESACCI") ? LC_CONDITION_ID_PATTERN : LC_ALTERNATIVE_CONDITION_ID_PATTERN;
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(id);
        if (m.matches()) {
            return m;
        }
        throw new IllegalArgumentException("Global attribute (id=" + id + ") does not match pattern " + LC_CONDITION_ID_PATTERN);
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getSpatialResolution() {
        return this.spatialResolution;
    }

    public String getTemporalResolution() {
        return this.temporalResolution;
    }

    public String getStartYear() {
        return this.startYear;
    }

    public String getEndYear() {
        return this.endYear;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getVersion() {
        return this.version;
    }
}

