/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import java.awt.Dimension;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.esa.cci.lc.io.LcCondMetadata;
import org.esa.cci.lc.io.LcWriterUtils;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.dataio.netcdf.AbstractNetCdfWriterPlugIn;
import org.esa.snap.dataio.netcdf.DefaultNetCdfWriter;
import org.esa.snap.dataio.netcdf.NullProfilePartWriter;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfileInitPartWriter;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartWriter;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamBandPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamInitialisationPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamNetCdf4WriterPlugIn;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import ucar.ma2.Array;
import ucar.ma2.DataType;

public class LcConditionNetCdf4WriterPlugIn
extends BeamNetCdf4WriterPlugIn {
    public static final String FORMAT_NAME = "NetCDF4-LC-Condition";

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public ProductWriter createWriterInstance() {
        return new DefaultNetCdfWriter((AbstractNetCdfWriterPlugIn)this);
    }

    public ProfilePartWriter createMetadataPartWriter() {
        return new NullProfilePartWriter();
    }

    public ProfilePartWriter createDescriptionPartWriter() {
        return new NullProfilePartWriter();
    }

    public ProfileInitPartWriter createInitialisationPartWriter() {
        return new LcCondInitialisationPart();
    }

    public ProfilePartWriter createBandPartWriter() {
        return new BeamBandPart(){
            private static final String NDVI_MEAN_BAND_NAME = "ndvi_mean";
            private static final String NDVI_STD_BAND_NAME = "ndvi_std";
            private static final String NDVI_STATUS_BAND_NAME = "ndvi_status";
            private static final String NDVI_N_YEAR_OBS_BAND_NAME = "ndvi_nYearObs";
            private static final String BA_OCC_BAND_NAME = "ba_occ";
            private static final String BA_N_YEAR_OBS_BAND_NAME = "ba_nYearObs";
            private static final String SNOW_OCC_BAND_NAME = "snow_occ";
            private static final String SNOW_N_YEAR_OBS_BAND_NAME = "snow_nYearObs";

            public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
                NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
                StringBuilder ancillaryVariables = new StringBuilder();
                for (Band band : p.getBands()) {
                    if (!this.isAncillaryBand(band)) continue;
                    if (ancillaryVariables.length() > 0) {
                        ancillaryVariables.append(' ');
                    }
                    ancillaryVariables.append(band.getName());
                }
                Dimension tileSize = p.getPreferredTileSize();
                for (Band band : p.getBands()) {
                    if (NDVI_MEAN_BAND_NAME.equals(band.getName())) {
                        this.addNdviMeanVariable(ncFile, band, tileSize, ancillaryVariables.toString());
                        continue;
                    }
                    if (NDVI_STD_BAND_NAME.equals(band.getName())) {
                        this.addNdviStdVariable(ncFile, band, tileSize);
                        continue;
                    }
                    if (NDVI_STATUS_BAND_NAME.equals(band.getName())) {
                        this.addNdviStatusVariable(ncFile, band, tileSize);
                        continue;
                    }
                    if (NDVI_N_YEAR_OBS_BAND_NAME.equals(band.getName())) {
                        this.addNdviNYearObsVariable(ncFile, band, tileSize);
                        continue;
                    }
                    if (BA_OCC_BAND_NAME.equals(band.getName())) {
                        this.addBaOccVariable(ncFile, band, tileSize, ancillaryVariables.toString());
                        continue;
                    }
                    if (BA_N_YEAR_OBS_BAND_NAME.equals(band.getName())) {
                        this.addBaNYearObsVariable(ncFile, band, tileSize);
                        continue;
                    }
                    if (SNOW_OCC_BAND_NAME.equals(band.getName())) {
                        this.addSnowOccVariable(ncFile, band, tileSize, ancillaryVariables.toString());
                        continue;
                    }
                    if (SNOW_N_YEAR_OBS_BAND_NAME.equals(band.getName())) {
                        this.addSnowNYearObsVariable(ncFile, band, tileSize);
                        continue;
                    }
                    this.addGeneralAggregatedVariable(ncFile, band, tileSize);
                }
            }

            private boolean isAncillaryBand(Band band) {
                String name = band.getName();
                return NDVI_STD_BAND_NAME.equals(name) || NDVI_STATUS_BAND_NAME.equals(name) || NDVI_N_YEAR_OBS_BAND_NAME.equals(name) || BA_N_YEAR_OBS_BAND_NAME.equals(name) || SNOW_N_YEAR_OBS_BAND_NAME.equals(name);
            }

            private void addNdviMeanVariable(NFileWriteable ncFile, Band band, Dimension tileSize, String ancillaryVariables) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, false, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "normalized_difference_vegetation_index");
                variable.addAttribute("valid_min", (Number)-10000);
                variable.addAttribute("valid_max", (Number)10000);
                variable.addAttribute("scale_factor", (Number)Float.valueOf(1.0E-4f));
                if (ncDataType == DataType.SHORT) {
                    variable.addAttribute("_FillValue", (Number)Short.MAX_VALUE);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
                if (ancillaryVariables.length() > 0) {
                    variable.addAttribute("ancillary_variables", ancillaryVariables);
                }
            }

            private void addNdviStdVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, false, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "normalized_difference_vegetation_index standard_error");
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)10000);
                variable.addAttribute("scale_factor", (Number)Float.valueOf(1.0E-4f));
                if (ncDataType == DataType.BYTE) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addNdviNYearObsVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, false, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "normalized_difference_vegetation_index number_of_observations");
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)30);
                if (ncDataType == DataType.BYTE) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addNdviStatusVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, false, tileSize, ncFile.getDimensions());
                byte[] conditionFlagValues = new byte[]{0, 1, 2, 3, 4, 5};
                String conditionFlagMeanings = "invalid land water snow cloud filled_ice";
                Array valids = Array.factory((DataType)DataType.BYTE, (int[])new int[]{6}, (Object)conditionFlagValues);
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "normalized_difference_vegetation_index status_flag");
                variable.addAttribute("flag_values", valids);
                variable.addAttribute("flag_meanings", "invalid land water snow cloud filled_ice");
                variable.addAttribute("valid_min", (Number)1);
                variable.addAttribute("valid_max", (Number)5);
                if (ncDataType == DataType.BYTE) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addBaOccVariable(NFileWriteable ncFile, Band band, Dimension tileSize, String ancillaryVariables) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, false, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)100);
                if (ncDataType == DataType.SHORT) {
                    variable.addAttribute("_FillValue", (Number)-2);
                } else {
                    variable.addAttribute("_FillValue", (Number)-2);
                }
                if (ancillaryVariables.length() > 0) {
                    variable.addAttribute("ancillary_variables", ancillaryVariables);
                }
            }

            private void addBaNYearObsVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, false, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)30);
                if (ncDataType == DataType.BYTE) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addSnowOccVariable(NFileWriteable ncFile, Band band, Dimension tileSize, String ancillaryVariables) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, false, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)100);
                if (ncDataType == DataType.SHORT) {
                    variable.addAttribute("_FillValue", (Number)-1);
                    variable.addAttribute("_WaterValue", (Number)-2);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                    variable.addAttribute("_WaterValue", (Number)-2);
                }
                if (ancillaryVariables.length() > 0) {
                    variable.addAttribute("ancillary_variables", ancillaryVariables);
                }
            }

            private void addSnowNYearObsVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, false, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)30);
                if (ncDataType == DataType.BYTE) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addGeneralAggregatedVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", band.getName());
                if (!band.getName().endsWith("nYearObs_sum")) {
                    variable.addAttribute("_FillValue", (Number)Float.valueOf(Float.NaN));
                }
            }
        };
    }

    class LcCondInitialisationPart
    extends BeamInitialisationPart {
        private final SimpleDateFormat COMPACT_ISO_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");

        LcCondInitialisationPart() {
            this.COMPACT_ISO_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public void writeProductBody(ProfileWriteContext ctx, Product product) throws IOException {
            NFileWriteable writeable = ctx.getNetcdfFileWriteable();
            LcCondMetadata metadata = new LcCondMetadata(product);
            String condition = metadata.getCondition();
            String startYear = metadata.getStartYear();
            String endYear = metadata.getEndYear();
            String startDate = metadata.getStartDate();
            String spatialResolution = metadata.getSpatialResolution();
            String temporalResolution = metadata.getTemporalResolution();
            String version = metadata.getVersion();
            String spatialResolutionDegrees = "500m".equals(spatialResolution) ? "0.005556" : "0.011112";
            String temporalCoverageYears = this.getTemporalCoverageYears(startYear, endYear);
            String startTime = startDate;
            String endTime = endYear + startDate.substring(4);
            GeoCoding geoCoding = product.getSceneGeoCoding();
            GeoPos upperLeft = geoCoding.getGeoPos(new PixelPos(0.0, 0.0), null);
            GeoPos lowerRight = geoCoding.getGeoPos(new PixelPos((double)product.getSceneRasterWidth(), (double)product.getSceneRasterHeight()), null);
            String latMax = String.valueOf(upperLeft.getLat());
            String latMin = String.valueOf(lowerRight.getLat());
            String lonMin = String.valueOf(upperLeft.getLon());
            String lonMax = String.valueOf(lowerRight.getLon());
            writeable.addGlobalAttribute("title", "ESA CCI Land Cover Condition " + condition);
            writeable.addGlobalAttribute("summary", "This dataset contains the global ESA CCI land cover condition derived from satellite data of a range of years.");
            writeable.addGlobalAttribute("type", metadata.getType());
            writeable.addGlobalAttribute("id", metadata.getId());
            Dimension tileSize = product.getPreferredTileSize();
            LcWriterUtils.addGenericGlobalAttributes(writeable, String.format("%d:%d", tileSize.width, tileSize.height));
            LcWriterUtils.addSpecificGlobalAttributes("SPOT VGT, MODIS, ...", "lc-condition-1.0", spatialResolutionDegrees, spatialResolution, temporalCoverageYears, temporalResolution, "D", startTime, endTime, version, latMax, latMin, lonMin, lonMax, writeable, "University catholique de Louvain");
            writeable.addDimension("lat", product.getSceneRasterHeight());
            writeable.addDimension("lon", product.getSceneRasterWidth());
        }

        private String getTemporalCoverageYears(String startYear, String endYear) {
            String temporalCoverageYears;
            try {
                temporalCoverageYears = String.valueOf(Integer.parseInt(endYear) - Integer.parseInt(startYear) + 1);
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("cannot parse " + startYear + " and " + endYear + " as year numbers", ex);
            }
            return temporalCoverageYears;
        }
    }
}

