/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.cci.lc.io.LcConditionTiffReaderPlugin;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;

public class LcConditionTiffReader
extends AbstractProductReader {
    public static final String LC_CONDITION_FILENAME_PATTERN = "ESACCI-LC-L4-(.*)-Cond-Agg(Mean|Occ)-(.*m)-P(.*)Y(.*)D-(........)-v(.*)\\.(tiff?)";
    private List<Product> bandProducts;

    public LcConditionTiffReader(LcConditionTiffReaderPlugin readerPlugin) {
        super((ProductReaderPlugIn)readerPlugin);
    }

    protected Product readProductNodesImpl() throws IOException {
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        this.bandProducts = new ArrayList<Product>();
        File lcConditionFile = LcConditionTiffReader.getFileInput(this.getInput());
        File productDir = lcConditionFile.getParentFile();
        String lcConditionFilename = lcConditionFile.getName();
        Matcher m = LcConditionTiffReader.lcConditionFileMatcher(lcConditionFilename);
        String condition = m.group(1);
        String mainVariable = m.group(2).toLowerCase();
        String spatialResolution = m.group(3);
        String temporalCoverageYears = m.group(4);
        String temporalResolution = m.group(5);
        String startDate = m.group(6);
        String startYear = startDate.substring(0, 4);
        String endYear = String.valueOf(Integer.parseInt(startYear) + Integer.parseInt(temporalCoverageYears) - 1);
        String version = m.group(7);
        String extension = m.group(8);
        Product lcConditionProduct = LcConditionTiffReader.readProduct(productDir, lcConditionFilename, (ProductReaderPlugIn)plugIn);
        if (lcConditionProduct == null) {
            throw new IllegalStateException("Could not read product file: " + lcConditionFile.getAbsolutePath());
        }
        Product result = new Product("LC_Cond_" + condition + "_" + startYear + "_" + endYear + "_" + startDate + "_v" + version, "LC_Cond", lcConditionProduct.getSceneRasterWidth(), lcConditionProduct.getSceneRasterHeight());
        result.setPreferredTileSize(new Dimension(1024, 1024));
        result.setFileLocation(lcConditionFile);
        ProductUtils.copyGeoCoding((Product)lcConditionProduct, (Product)result);
        result.getMetadataRoot().setAttributeString("condition", condition);
        result.getMetadataRoot().setAttributeString("spatialResolution", spatialResolution);
        result.getMetadataRoot().setAttributeString("temporalResolution", temporalResolution);
        result.getMetadataRoot().setAttributeString("startYear", startYear);
        result.getMetadataRoot().setAttributeString("endYear", endYear);
        result.getMetadataRoot().setAttributeString("startDate", startDate);
        result.getMetadataRoot().setAttributeString("version", version);
        MetadataElement globalAttributes = new MetadataElement("global_attributes");
        MetadataElement metadataRoot = result.getMetadataRoot();
        metadataRoot.addElement(globalAttributes);
        globalAttributes = metadataRoot.getElement("global_attributes");
        globalAttributes.setAttributeString("condition", condition);
        globalAttributes.setAttributeString("spatialResolution", spatialResolution);
        globalAttributes.setAttributeString("temporalResolution", temporalResolution);
        globalAttributes.setAttributeString("startYear", startYear);
        globalAttributes.setAttributeString("endYear", endYear);
        globalAttributes.setAttributeString("startDate", startDate);
        globalAttributes.setAttributeString("version", version);
        this.bandProducts.add(lcConditionProduct);
        Band band = LcConditionTiffReader.addBand(condition.toLowerCase() + "_" + mainVariable, lcConditionProduct, result);
        band.setDescription(condition + " " + mainVariable);
        String stdFilename = this.createFileName("Std", condition, spatialResolution, temporalCoverageYears, temporalResolution, startDate, version, extension);
        Product stdProduct = LcConditionTiffReader.readProduct(productDir, stdFilename, (ProductReaderPlugIn)plugIn);
        this.addVariableToConditionResult(condition, "std", stdProduct, result);
        String statusFilename = this.createFileName("Status", condition, spatialResolution, temporalCoverageYears, temporalResolution, startDate, version, extension);
        Product statusProduct = LcConditionTiffReader.readProduct(productDir, statusFilename, (ProductReaderPlugIn)plugIn);
        this.addVariableToConditionResult(condition, "status", statusProduct, result);
        String nYearObsFilename = this.createFileName("NYearObs", condition, spatialResolution, temporalCoverageYears, temporalResolution, startDate, version, extension);
        Product nYearObsProduct = LcConditionTiffReader.readProduct(productDir, nYearObsFilename, (ProductReaderPlugIn)plugIn);
        this.addVariableToConditionResult(condition, "nYearObs", nYearObsProduct, result);
        return result;
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException();
    }

    private String createFileName(String variable, String condition, String spatialResolution, String temporalCoverageYears, String temporalResolution, String startDate, String version, String extension) {
        return "ESACCI-LC-L4-" + condition + "-Cond-" + variable + "-" + spatialResolution + "-P" + temporalCoverageYears + "Y" + temporalResolution + "D-" + startDate + "-v" + version + "." + extension;
    }

    private void addVariableToConditionResult(String conditionName, String variableName, Product variableProduct, Product result) {
        if (variableProduct != null) {
            if (result.getSceneRasterWidth() != variableProduct.getSceneRasterWidth() || result.getSceneRasterHeight() != variableProduct.getSceneRasterHeight()) {
                throw new IllegalArgumentException("dimensions of " + variableName + " band does not match dimensions of 'mainVariable' band");
            }
            this.bandProducts.add(variableProduct);
            Band band = LcConditionTiffReader.addBand(conditionName.toLowerCase() + "_" + variableName, variableProduct, result);
            band.setDescription(conditionName + "_" + variableName);
        }
    }

    private static File getFileInput(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        throw new IllegalArgumentException("unexpected class " + input.getClass() + " of the input");
    }

    private static Matcher lcConditionFileMatcher(String lcConditionFilename) {
        Pattern p = Pattern.compile(LC_CONDITION_FILENAME_PATTERN);
        Matcher m = p.matcher(lcConditionFilename);
        if (!m.matches()) {
            throw new IllegalArgumentException("input file name " + lcConditionFilename + " does not match pattern " + LC_CONDITION_FILENAME_PATTERN);
        }
        return m;
    }

    private static Product readProduct(File productDir, String lcFlagFilename, ProductReaderPlugIn plugIn) throws IOException {
        File bandFile = new File(productDir, lcFlagFilename);
        if (!bandFile.canRead()) {
            return null;
        }
        ProductReader productReader1 = plugIn.createReaderInstance();
        return productReader1.readProductNodes((Object)bandFile, null);
    }

    private static Band addBand(String bandName, Product lcFlagProduct, Product result) {
        Band srcBand = lcFlagProduct.getBandAt(0);
        Band band = result.addBand(bandName, srcBand.getDataType());
        band.setNoDataValueUsed(false);
        band.setSourceImage(srcBand.getSourceImage());
        return band;
    }

    public void close() throws IOException {
        for (Product bandProduct : this.bandProducts) {
            bandProduct.closeIO();
        }
        this.bandProducts.clear();
        super.close();
    }
}

