/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;

public class LcMapMetadata {
    private static final String LC_MAP_ID_PATTERN = "ESACCI-LC-L4-LCCS-Map-(.*m)-P(.*)Y-[aggregated]?-?.*?-?(....)-v(.*)";
    private static final String LC_ALTERNATIVE_MAP_ID_PATTERN = "ESACCI-LC-L4-LCCS-Map-(.*m)-P(.*)Y-(....)-v(.*)_AlternativeMap.*";
    private static final String LC_ALTERNATIVE_MAP_ID_PATTERN2 = "ESACCI-LC-L4-LCCS-AlternativeMap.*-(.*m)-P(.*)Y-.*(....)-v(.*)";
    private static final String LC_ALTERNATIVE_MAP_ID_PATTERN3 = "C3S-LC-L4-LCCS-Map-(.*m)-P(.*)Y-(....)-v(.*)";
    public static final String GLOBAL_ATTRIBUTES_ELEMENT_NAME = "Global_Attributes";
    private String type;
    private String id;
    private String epoch;
    private String version;
    private String spatialResolution;
    private String temporalResolution;
    private String mapType;
    private String pftTable;
    private String pftTableComment;

    public LcMapMetadata(Product sourceProduct) {
        this.mapType = sourceProduct.getFileLocation() != null ? LcMapMetadata.mapTypeOf(sourceProduct.getFileLocation().getName()) : "unknown";
        MetadataElement metadataRoot = sourceProduct.getMetadataRoot();
        if (metadataRoot.containsElement(GLOBAL_ATTRIBUTES_ELEMENT_NAME)) {
            MetadataElement globalAttributes = metadataRoot.getElement(GLOBAL_ATTRIBUTES_ELEMENT_NAME);
            this.type = globalAttributes.getAttributeString("type");
            this.id = globalAttributes.getAttributeString("id");
            if (globalAttributes.containsAttribute("pft_table")) {
                this.pftTable = globalAttributes.getAttributeString("pft_table");
            }
            if (globalAttributes.containsAttribute("pft_table_comment")) {
                this.pftTableComment = globalAttributes.getAttributeString("pft_table_comment");
            }
            Matcher idMatcher = LcMapMetadata.lcMapIdMatcher(this.id);
            this.spatialResolution = idMatcher.group(1);
            this.temporalResolution = idMatcher.group(2);
            this.epoch = idMatcher.group(3);
            this.version = idMatcher.group(4);
        } else {
            if (metadataRoot.containsAttribute("type")) {
                this.type = metadataRoot.getAttributeString("type");
            }
            if (metadataRoot.containsAttribute("id")) {
                this.id = metadataRoot.getAttributeString("id");
            }
            if (metadataRoot.containsAttribute("pft_table")) {
                this.pftTable = metadataRoot.getAttributeString("pft_table");
            }
            if (metadataRoot.containsAttribute("pft_table_comment")) {
                this.pftTableComment = metadataRoot.getAttributeString("pft_table_comment");
            }
            this.epoch = metadataRoot.getAttributeString("epoch");
            this.version = metadataRoot.getAttributeString("version");
            this.spatialResolution = metadataRoot.getAttributeString("spatialResolution");
            this.temporalResolution = metadataRoot.getAttributeString("temporalResolution");
        }
    }

    static Matcher lcMapIdMatcher(String id) {
        String regexp = id.contains("_AlternativeMap") ? LC_ALTERNATIVE_MAP_ID_PATTERN : (id.contains("AlternativeMap") ? LC_ALTERNATIVE_MAP_ID_PATTERN2 : (id.contains("C3S") ? LC_ALTERNATIVE_MAP_ID_PATTERN3 : LC_MAP_ID_PATTERN));
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(id);
        if (!m.matches()) {
            throw new IllegalArgumentException("Global attribute (id=" + id + ") does not match pattern " + regexp);
        }
        return m;
    }

    public static String mapTypeOf(String filename) {
        String mapType = filename.contains("MaxBiomass") ? "AlternativeMapMaxBiomass" : (filename.contains("MinBiomass") ? "AlternativeMapMinBiomass" : (filename.contains("AlternativeMap") ? "AlternativeMap" : "Map"));
        return mapType;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getEpoch() {
        return this.epoch;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSpatialResolution() {
        return this.spatialResolution;
    }

    public String getTemporalResolution() {
        return this.temporalResolution;
    }

    public String getMapType() {
        return this.mapType;
    }

    public String getPftTable() {
        return this.pftTable;
    }

    public String getPftTableComment() {
        return this.pftTableComment;
    }
}

