/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import java.awt.Dimension;
import java.io.IOException;
import org.esa.cci.lc.aggregation.LCCS;
import org.esa.cci.lc.io.LcMapMetadata;
import org.esa.cci.lc.io.LcWriterUtils;
import org.esa.cci.lc.util.LcHelper;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.dataio.netcdf.AbstractNetCdfWriterPlugIn;
import org.esa.snap.dataio.netcdf.DefaultNetCdfWriter;
import org.esa.snap.dataio.netcdf.NullProfilePartWriter;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfileInitPartWriter;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartWriter;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamBandPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamInitialisationPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamNetCdf4WriterPlugIn;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.DataType;

public class LcMapNetCdf4WriterPlugIn
extends BeamNetCdf4WriterPlugIn {
    public static final String FORMAT_NAME = "NetCDF4-LC-Map";

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public ProductWriter createWriterInstance() {
        return new DefaultNetCdfWriter((AbstractNetCdfWriterPlugIn)this);
    }

    public ProfilePartWriter createMetadataPartWriter() {
        return new NullProfilePartWriter();
    }

    public ProfileInitPartWriter createInitialisationPartWriter() {
        return new LcMapInitialisationPart();
    }

    public ProfilePartWriter createDescriptionPartWriter() {
        return new NullProfilePartWriter();
    }

    public ProfilePartWriter createBandPartWriter() {
        return new BeamBandPart(){
            private static final String LCCS_CLASS_BAND_NAME = "lccs_class";
            private static final String PROCESSED_FLAG_BAND_NAME = "processed_flag";
            private static final String CURRENT_PIXEL_STATE_BAND_NAME = "current_pixel_state";
            private static final String OBSERVATION_COUNT_BAND_NAME = "observation_count";
            private static final String ALGORITHMIC_CONFIDENCE_LEVEL_BAND_NAME = "algorithmic_confidence_level";
            private static final String CHANGE_COUNT_BAND_NAME = "change_count";
            private static final String OVERALL_CONFIDENCE_LEVEL_BAND_NAME = "overall_confidence_level";
            private static final String LABEL_CONFIDENCE_LEVEL_BAND_NAME = "label_confidence_level";
            private static final String LABEL_SOURCE_BAND_NAME = "label_source";

            public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
                NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
                String ancillaryVariableString = this.getAncillaryVariableString(p);
                Dimension tileSize = p.getPreferredTileSize();
                for (Band band : p.getBands()) {
                    if (LCCS_CLASS_BAND_NAME.equals(band.getName())) {
                        this.addLccsClassVariable(ncFile, band, tileSize, ancillaryVariableString);
                        continue;
                    }
                    if (PROCESSED_FLAG_BAND_NAME.equals(band.getName())) {
                        this.addProcessedFlagVariable(ncFile, band, tileSize);
                        continue;
                    }
                    if (CURRENT_PIXEL_STATE_BAND_NAME.equals(band.getName())) {
                        this.addCurrentPixelStateVariable(ncFile, band, tileSize);
                        continue;
                    }
                    if (OBSERVATION_COUNT_BAND_NAME.equals(band.getName())) {
                        this.addObservationCountVariable(ncFile, band, tileSize);
                        continue;
                    }
                    if (ALGORITHMIC_CONFIDENCE_LEVEL_BAND_NAME.equals(band.getName())) {
                        this.addAlgorithmicConfidenceLevelVariable(ncFile, band, tileSize);
                        continue;
                    }
                    if (CHANGE_COUNT_BAND_NAME.equals(band.getName())) {
                        this.addChangeCountVariable(ncFile, band, tileSize);
                        continue;
                    }
                    if (OVERALL_CONFIDENCE_LEVEL_BAND_NAME.equals(band.getName())) {
                        this.addOverallConfidenceLevelVariable(ncFile, band, tileSize);
                        continue;
                    }
                    if (LABEL_CONFIDENCE_LEVEL_BAND_NAME.equals(band.getName())) {
                        this.addLabelConfidenceLevelVariable(ncFile, band, tileSize);
                        continue;
                    }
                    if (LABEL_SOURCE_BAND_NAME.equals(band.getName())) {
                        this.addLabelSourceVariable(ncFile, band, tileSize);
                        continue;
                    }
                    this.addGeneralVariable(ncFile, band, tileSize);
                }
            }

            private String getAncillaryVariableString(Product p) {
                StringBuilder ancillaryVariables = new StringBuilder();
                for (Band band : p.getBands()) {
                    String bandName = band.getName();
                    if (!this.isAncillaryVariable(bandName)) continue;
                    if (ancillaryVariables.length() > 0) {
                        ancillaryVariables.append(' ');
                    }
                    ancillaryVariables.append(bandName);
                }
                return ancillaryVariables.toString();
            }

            private boolean isAncillaryVariable(String bandName) {
                return PROCESSED_FLAG_BAND_NAME.equals(bandName) || CURRENT_PIXEL_STATE_BAND_NAME.equals(bandName) || OBSERVATION_COUNT_BAND_NAME.equals(bandName) || ALGORITHMIC_CONFIDENCE_LEVEL_BAND_NAME.equals(bandName) || CHANGE_COUNT_BAND_NAME.equals(bandName) || OVERALL_CONFIDENCE_LEVEL_BAND_NAME.equals(bandName) || LABEL_CONFIDENCE_LEVEL_BAND_NAME.equals(bandName) || LABEL_SOURCE_BAND_NAME.equals(bandName);
            }

            private void addLccsClassVariable(NFileWriteable ncFile, Band band, Dimension tileSize, String ancillaryVariables) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                int[] lccsClassFlagValues = LCCS.getInstance().getClassValues();
                ArrayByte.D1 valids = new ArrayByte.D1(lccsClassFlagValues.length, variable.getDataType().isUnsigned());
                for (int i = 0; i < lccsClassFlagValues.length; ++i) {
                    valids.set(i, (byte)lccsClassFlagValues[i]);
                }
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "land_cover_lccs");
                variable.addAttribute("flag_values", (Array)valids);
                variable.addAttribute("flag_meanings", StringUtils.arrayToString((Object)LCCS.getInstance().getFlagMeanings(), (String)" "));
                variable.addAttribute("valid_min", (Number)1);
                variable.addAttribute("valid_max", (Number)220);
                variable.addAttribute("_Unsigned", "true");
                variable.addAttribute("_FillValue", (Number)0);
                if (ancillaryVariables.length() > 0) {
                    variable.addAttribute("ancillary_variables", ancillaryVariables);
                }
            }

            private void addProcessedFlagVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                byte[] flagValues = new byte[]{0, 1};
                String flagMeanings = "not_processed processed";
                Array valids = Array.factory((DataType)DataType.BYTE, (int[])new int[]{2}, (Object)flagValues);
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "land_cover_lccs status_flag");
                variable.addAttribute("flag_values", valids);
                variable.addAttribute("flag_meanings", "not_processed processed");
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)1);
                if (ncDataType == DataType.SHORT) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addCurrentPixelStateVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                byte[] flagValues = new byte[]{0, 1, 2, 3, 4, 5};
                String flagMeanings = "invalid clear_land clear_water clear_snow_ice cloud cloud_shadow";
                Array valids = Array.factory((DataType)DataType.BYTE, (int[])new int[]{6}, (Object)flagValues);
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "land_cover_lccs status_flag");
                variable.addAttribute("flag_values", valids);
                variable.addAttribute("flag_meanings", "invalid clear_land clear_water clear_snow_ice cloud cloud_shadow");
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)5);
                if (ncDataType == DataType.SHORT) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addObservationCountVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "land_cover_lccs number_of_observations");
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)Short.MAX_VALUE);
                if (ncDataType == DataType.SHORT) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addAlgorithmicConfidenceLevelVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "land_cover_lccs algorithmic_confidence");
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)100);
                variable.addAttribute("scale_factor", (Number)Float.valueOf(0.01f));
                if (ncDataType == DataType.SHORT) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addChangeCountVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)100);
                if (ncDataType == DataType.SHORT) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addOverallConfidenceLevelVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                byte[] flagValues = new byte[]{0, 1, 2};
                String flagMeanings = "doubtful reasonable certain";
                Array valids = Array.factory((DataType)DataType.BYTE, (int[])new int[]{3}, (Object)flagValues);
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "land_cover_lccs overall_confidence");
                variable.addAttribute("flag_values", valids);
                variable.addAttribute("flag_meanings", "doubtful reasonable certain");
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)1);
                if (ncDataType == DataType.SHORT) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addLabelConfidenceLevelVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "land_cover_lccs confidence");
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)100);
                variable.addAttribute("scale_factor", (Number)Float.valueOf(0.01f));
                if (ncDataType == DataType.SHORT) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addLabelSourceVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                byte[] flagValues = new byte[]{0, 1, 2, 3};
                String flagMeanings = "invalid original_label first_alternative_label second_alternative_label";
                Array valids = Array.factory((DataType)DataType.BYTE, (int[])new int[]{4}, (Object)flagValues);
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "land_cover_lccs status_flag");
                variable.addAttribute("flag_values", valids);
                variable.addAttribute("flag_meanings", "invalid original_label first_alternative_label second_alternative_label");
                variable.addAttribute("valid_min", (Number)1);
                variable.addAttribute("valid_max", (Number)3);
                if (ncDataType == DataType.SHORT) {
                    variable.addAttribute("_FillValue", (Number)0);
                } else {
                    variable.addAttribute("_FillValue", (Number)0);
                }
            }

            private void addGeneralVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", band.getName());
                if (band.getScalingOffset() != 0.0) {
                    variable.addAttribute("add_offset", (Number)band.getScalingOffset());
                }
                if (band.getScalingFactor() != 1.0) {
                    variable.addAttribute("scale_factor", (Number)band.getScalingFactor());
                }
                variable.addAttribute("_FillValue", (Number)Float.valueOf(Float.NaN));
            }
        };
    }

    class LcMapInitialisationPart
    extends BeamInitialisationPart {
        LcMapInitialisationPart() {
        }

        public void writeProductBody(ProfileWriteContext ctx, Product product) throws IOException {
            String pftTableComment;
            NFileWriteable writeable = ctx.getNetcdfFileWriteable();
            LcMapMetadata lcMapMetadata = new LcMapMetadata(product);
            String spatialResolution = lcMapMetadata.getSpatialResolution();
            String temporalResolution = lcMapMetadata.getTemporalResolution();
            String epoch = lcMapMetadata.getEpoch();
            String version = lcMapMetadata.getVersion();
            GeoCoding geoCoding = product.getSceneGeoCoding();
            GeoPos upperLeft = geoCoding.getGeoPos(new PixelPos(0.0, 0.0), null);
            GeoPos lowerRight = geoCoding.getGeoPos(new PixelPos((double)product.getSceneRasterWidth(), (double)product.getSceneRasterHeight()), null);
            String latMax = String.valueOf(upperLeft.getLat());
            String latMin = String.valueOf(lowerRight.getLat());
            String lonMin = String.valueOf(upperLeft.getLon());
            String lonMax = String.valueOf(lowerRight.getLon());
            String spatialResolutionDegrees = "300m".equals(spatialResolution) ? "0.002778" : "0.011112";
            int epochInt = Integer.parseInt(epoch);
            int temporalResolutionInt = Integer.parseInt(temporalResolution);
            String startYear = String.valueOf(epochInt - temporalResolutionInt / 2);
            String startTime = startYear + "0101";
            String endYear = String.valueOf(epochInt + temporalResolutionInt / 2);
            String endTime = endYear + "1231";
            String temporalCoverageYears = this.getTemporalCoverage(startYear, endYear);
            writeable.addGlobalAttribute("title", "ESA CCI Land Cover Map");
            writeable.addGlobalAttribute("summary", "This dataset contains the global ESA CCI land cover classification map derived from satellite data of one epoch.");
            writeable.addGlobalAttribute("type", lcMapMetadata.getType());
            writeable.addGlobalAttribute("id", lcMapMetadata.getId());
            Dimension tileSize = product.getPreferredTileSize();
            LcWriterUtils.addGenericGlobalAttributes(writeable, LcHelper.format(tileSize));
            LcWriterUtils.addSpecificGlobalAttributes("MERIS FR L1B version 5.05, MERIS RR L1B version 8.0, SPOT VGT P", "amorgos-4,0, lc-sdr-1.0, lc-sr-1.0, lc-classification-1.0", spatialResolutionDegrees, spatialResolution, temporalCoverageYears, temporalResolution, "Y", startTime, endTime, version, latMax, latMin, lonMin, lonMax, writeable, "University catholique de Louvain");
            String pftTable = lcMapMetadata.getPftTable();
            if (pftTable != null) {
                writeable.addGlobalAttribute("pft_table", pftTable);
            }
            if ((pftTableComment = lcMapMetadata.getPftTableComment()) != null) {
                writeable.addGlobalAttribute("pft_table_comment", pftTableComment);
            }
            writeable.addDimension("lat", product.getSceneRasterHeight());
            writeable.addDimension("lon", product.getSceneRasterWidth());
        }

        private String getTemporalCoverage(String startYear, String endYear) {
            String temporalCoverageYears;
            try {
                temporalCoverageYears = String.valueOf(Integer.parseInt(endYear) - Integer.parseInt(startYear) + 1);
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("cannot parse " + startYear + " and " + endYear + " as year numbers", ex);
            }
            return temporalCoverageYears;
        }
    }
}

