/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.cci.lc.io.LcMapTiffReaderPlugin;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;

public class LcMapTiffReader
extends AbstractProductReader {
    public static final String LC_MAP_FILENAME_PATTERN = "ESACCI-LC-L4-LCCS-Map-300m-P(\\d+)Y-(....)-v(.*)\\.(tiff?)";
    public static final String LC_ALTERNATIVE_FILENAME_PATTERN = "ESACCI-LC-L4-LCCS-Map-300m-P(\\d+)Y-(....)-v(.*)_AlternativeMap.*\\.(tiff?)";
    public static final String[] LC_VARIABLE_NAMES = new String[]{"lccs_class", "processed_flag", "current_pixel_state", "observation_count", "algorithmic_confidence_level", "label_confidence_level", "label_source", "overall_confidence_level"};
    public static final String[] LC_VARIABLE_NAMES_P1Y = new String[]{"lccs_class", "processed_flag", "current_pixel_state", "observation_count", "change_count", "label_confidence_level", "label_source", "overall_confidence_level"};
    private static final String[] LC_VARIABLE_DESCRIPTIONS = new String[]{"Land cover class defined in LCCS", "LC map processed area flag", "LC pixel type mask", "number of valid observations", "LC map confidence level based on algorithm performance", "Alternative label confidence level", "Source of the alternative class", "LC map confidence level based on product validation"};
    private static final String[] LC_VARIABLE_DESCRIPTIONS_P1Y = new String[]{"Land cover class defined in LCCS", "LC map processed area flag", "LC pixel type mask", "number of valid observations", "number of class changes", "Alternative label confidence level", "Source of the alternative class", "LC map confidence level based on product validation"};
    private List<Product> bandProducts;

    public LcMapTiffReader(LcMapTiffReaderPlugin readerPlugin) {
        super((ProductReaderPlugIn)readerPlugin);
    }

    protected Product readProductNodesImpl() throws IOException {
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        this.bandProducts = new ArrayList<Product>();
        File lcClassifLccsFile = LcMapTiffReader.getFileInput(this.getInput());
        if (!lcClassifLccsFile.exists()) {
            throw new IOException("Input file does not exist: " + lcClassifLccsFile.getAbsolutePath());
        }
        File productDir = lcClassifLccsFile.getParentFile();
        String lcClassifLccsFilename = lcClassifLccsFile.getName();
        String mapType = LcMapTiffReader.mapTypeOf(lcClassifLccsFilename);
        Matcher m = LcMapTiffReader.lcClassifLccsFileMatcher(lcClassifLccsFilename, mapType);
        String temporalResolution = m.group(1);
        String epoch = m.group(2);
        String version = m.group(3);
        String extension = m.group(4);
        Product lcClassifLccsProduct = LcMapTiffReader.readProduct(productDir, lcClassifLccsFilename, (ProductReaderPlugIn)plugIn);
        Product result = new Product("LC_Map_" + epoch + "_v" + version, "LC_Map", lcClassifLccsProduct.getSceneRasterWidth(), lcClassifLccsProduct.getSceneRasterHeight());
        result.setPreferredTileSize(new Dimension(1024, 1024));
        result.setFileLocation(lcClassifLccsFile);
        ProductUtils.copyGeoCoding((Product)lcClassifLccsProduct, (Product)result);
        MetadataElement metadataRoot = result.getMetadataRoot();
        metadataRoot.setAttributeString("epoch", epoch);
        metadataRoot.setAttributeString("version", version);
        metadataRoot.setAttributeString("spatialResolution", "300m");
        metadataRoot.setAttributeString("temporalResolution", temporalResolution);
        this.bandProducts.add(lcClassifLccsProduct);
        Band band = LcMapTiffReader.addBand(LC_VARIABLE_NAMES[0], lcClassifLccsProduct, result);
        band.setDescription(LC_VARIABLE_DESCRIPTIONS[0]);
        if ("Map".equals(mapType) && "1".equals(temporalResolution)) {
            for (int i = 1; i < 5; ++i) {
                String lcFlagFilename = "ESACCI-LC-L4-LCCS-Map-300m-P" + temporalResolution + "Y-" + epoch + "-v" + version + "_qualityflag" + i + "." + extension;
                this.addInputToResult(productDir, lcFlagFilename, result, plugIn, LC_VARIABLE_NAMES_P1Y[i], LC_VARIABLE_DESCRIPTIONS_P1Y[i]);
            }
        } else if ("Map".equals(mapType)) {
            for (int i = 1; i < 5; ++i) {
                String lcFlagFilename = "ESACCI-LC-L4-LCCS-Map-300m-P" + temporalResolution + "Y-" + epoch + "-v" + version + "_qualityflag" + i + "." + extension;
                this.addInputToResult(productDir, lcFlagFilename, result, plugIn, LC_VARIABLE_NAMES[i], LC_VARIABLE_DESCRIPTIONS[i]);
            }
        } else {
            for (int i = 5; i < 7; ++i) {
                String lcFlagFilename;
                if ("AlternativeMap".equals(mapType)) {
                    lcFlagFilename = "ESACCI-LC-L4-LCCS-Map-300m-P" + temporalResolution + "Y-" + epoch + "-v" + version + "_AlternativeMap_QF" + (i - 4) + "." + extension;
                } else if ("AlternativeMapMaxBiomass".equals(mapType)) {
                    lcFlagFilename = "ESACCI-LC-L4-LCCS-Map-300m-P" + temporalResolution + "Y-" + epoch + "-v" + version + "_AlternativeMap_MaxBiomass_QF" + (i - 4) + "." + extension;
                } else if ("AlternativeMapMinBiomass".equals(mapType)) {
                    lcFlagFilename = "ESACCI-LC-L4-LCCS-Map-300m-P" + temporalResolution + "Y-" + epoch + "-v" + version + "_AlternativeMap_MinBiomass_QF" + (i - 4) + "." + extension;
                } else {
                    throw new IllegalArgumentException("unknown map type " + mapType);
                }
                this.addInputToResult(productDir, lcFlagFilename, result, plugIn, LC_VARIABLE_NAMES[i], LC_VARIABLE_DESCRIPTIONS[i]);
            }
        }
        return result;
    }

    private void addInputToResult(File productDir, String lcFlagFilename, Product result, GeoTiffProductReaderPlugIn plugIn, String variableName, String variableDescription) throws IOException {
        Product lcFlagProduct = LcMapTiffReader.readProduct(productDir, lcFlagFilename, (ProductReaderPlugIn)plugIn);
        if (lcFlagProduct == null) {
            return;
        }
        if (result.getSceneRasterWidth() != lcFlagProduct.getSceneRasterWidth() || result.getSceneRasterHeight() != lcFlagProduct.getSceneRasterHeight()) {
            throw new IllegalArgumentException("dimensions of " + lcFlagFilename + " does not match map");
        }
        this.bandProducts.add(lcFlagProduct);
        Band band = LcMapTiffReader.addBand(variableName, lcFlagProduct, result);
        band.setDescription(variableDescription);
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException();
    }

    private static File getFileInput(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        throw new IllegalArgumentException("unexpected class " + input.getClass() + " of the input");
    }

    private static Matcher lcClassifLccsFileMatcher(String lcClassifLccsFilename, String mapType) {
        String regexp = mapType.startsWith("AlternativeMap") ? LC_ALTERNATIVE_FILENAME_PATTERN : LC_MAP_FILENAME_PATTERN;
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(lcClassifLccsFilename);
        if (!m.matches()) {
            throw new IllegalArgumentException("input file name " + lcClassifLccsFilename + " does not match pattern " + regexp);
        }
        return m;
    }

    private static String mapTypeOf(String filename) {
        String mapType = filename.contains("AlternativeMap_MaxBiomass") ? "AlternativeMapMaxBiomass" : (filename.contains("AlternativeMap_MinBiomass") ? "AlternativeMapMinBiomass" : (filename.contains("AlternativeMap") ? "AlternativeMap" : "Map"));
        return mapType;
    }

    private static Product readProduct(File productDir, String lcClassifLccsFilename, ProductReaderPlugIn plugIn) throws IOException {
        File lcClassifLccsFile = new File(productDir, lcClassifLccsFilename);
        if (!lcClassifLccsFile.canRead()) {
            return null;
        }
        ProductReader productReader = plugIn.createReaderInstance();
        Product product = productReader.readProductNodes((Object)lcClassifLccsFile, null);
        if (product == null) {
            throw new IllegalStateException("Could not read product: " + lcClassifLccsFile);
        }
        return product;
    }

    private static Band addBand(String variableName, Product lcProduct, Product result) {
        Band srcBand = lcProduct.getBandAt(0);
        Band band = result.addBand(variableName, srcBand.getDataType());
        band.setNoDataValueUsed(false);
        band.setSourceImage(srcBand.getSourceImage());
        return band;
    }

    public void close() throws IOException {
        for (Product bandProduct : this.bandProducts) {
            bandProduct.closeIO();
        }
        this.bandProducts.clear();
        super.close();
    }
}

