/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.esa.cci.lc.io.LcPftTiffReaderPlugin;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;

public class LcPftTiffReader
extends AbstractProductReader {
    private List<Product> bandProducts;
    public static final String LC_PFT_CONDITION_FILENAME_PATTERN = "ESACCI-LC-L4-WATER_INLAND-PFT-Map-300m-P1Y-....-v0.1.tif";
    public static final String LC_PFT_ALTERNATIVE_CONDITION_FILENAME_PATTERN = "PFT_WATER_300m_...._GLOBAL_v2.tif";
    private String[] listVariables = new String[]{"BARE", "BUILT", "GRASS-MAN", "GRASS-NAT", "SHRUBS-BD", "SHRUBS-BE", "SHRUBS-ND", "SHRUBS-NE", "WATER_INLAND", "SNOWICE", "TREES-BD", "TREES-BE", "TREES-ND", "TREES-NE"};

    public LcPftTiffReader(LcPftTiffReaderPlugin readerPlugin) {
        super((ProductReaderPlugIn)readerPlugin);
    }

    protected Product readProductNodesImpl() throws IOException {
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        File lcWaterFile = LcPftTiffReader.getFileInput(this.getInput());
        File productDir = lcWaterFile.getParentFile();
        String lcWaterFilename = lcWaterFile.getName();
        Product lcWaterProduct = LcPftTiffReader.readProduct(productDir, lcWaterFilename, (ProductReaderPlugIn)plugIn);
        Product result = new Product("Pixel_product", "CF-1.6", lcWaterProduct.getSceneRasterWidth(), lcWaterProduct.getSceneRasterHeight());
        result.setFileLocation(lcWaterFile);
        GeoCoding geoCoding = lcWaterProduct.getSceneGeoCoding();
        GeoPos upperLeft = geoCoding.getGeoPos(new PixelPos(0.0, 0.0), null);
        GeoPos lowerRight = geoCoding.getGeoPos(new PixelPos((double)lcWaterProduct.getSceneRasterWidth(), (double)lcWaterProduct.getSceneRasterHeight()), null);
        String latMax = String.valueOf(upperLeft.getLat());
        String latMin = String.valueOf(lowerRight.getLat());
        String lonMin = String.valueOf(upperLeft.getLon());
        String lonMax = String.valueOf(lowerRight.getLon());
        result.getMetadataRoot().addElement(new MetadataElement("global_attributes"));
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("product_version", "v5.0");
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("type", "PFT_product");
        result.getMetadataRoot().getElement("global_attributes").setAttributeDouble("geospatial_lat_min", Double.parseDouble(latMin));
        result.getMetadataRoot().getElement("global_attributes").setAttributeDouble("geospatial_lat_max", Double.parseDouble(latMax));
        result.getMetadataRoot().getElement("global_attributes").setAttributeDouble("geospatial_lon_min", Double.parseDouble(lonMin));
        result.getMetadataRoot().getElement("global_attributes").setAttributeDouble("geospatial_lon_max", Double.parseDouble(lonMax));
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("time_coverage_duration", "P1Y");
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("time_coverage_resolution", "P1Y");
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("sensor", "MODIS");
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("spatial_resolution", "300m");
        String timeYear = lcWaterProduct.getFileLocation().getName().substring(15, 19);
        String startObservation = timeYear + "0101T000000Z";
        String endObservation = timeYear + "1231T235959Z";
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("time_coverage_start", startObservation);
        result.getMetadataRoot().getElement("global_attributes").setAttributeString("time_coverage_end", endObservation);
        Band waterBand = LcPftTiffReader.addBand("WATER", lcWaterProduct, result);
        waterBand.setDescription("WATER");
        for (String bandName : this.listVariables) {
            String lcFilename = lcWaterFilename.replace("WATER", bandName);
            Product lcProduct = LcPftTiffReader.readProduct(productDir, lcFilename, (ProductReaderPlugIn)plugIn);
            Band bandBare = LcPftTiffReader.addBand(bandName, lcProduct, result);
            bandBare.setDescription(bandName);
        }
        VirtualBand landBand = new VirtualBand("LAND", 10, result.getSceneRasterWidth(), result.getSceneRasterHeight(), "100-WATER");
        VirtualBand oceanWaterBand = new VirtualBand("WATER_OCEAN", 10, result.getSceneRasterWidth(), result.getSceneRasterHeight(), "WATER - 'WATER_INLAND'");
        result.addBand((Band)landBand);
        result.addBand((Band)oceanWaterBand);
        return result;
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException();
    }

    private static File getFileInput(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        throw new IllegalArgumentException("unexpected class " + input.getClass() + " of the input");
    }

    private static Product readProduct(File productDir, String lcFlagFilename, ProductReaderPlugIn plugIn) throws IOException {
        File bandFile = new File(productDir, lcFlagFilename);
        if (!bandFile.canRead()) {
            return null;
        }
        ProductReader productReader1 = plugIn.createReaderInstance();
        return productReader1.readProductNodes((Object)bandFile, null);
    }

    private static Band addBand(String bandName, Product lcFlagProduct, Product result) {
        Band srcBand = lcFlagProduct.getBandAt(0);
        Band band = result.addBand(bandName, srcBand.getDataType());
        band.setNoDataValueUsed(false);
        band.setSourceImage(srcBand.getSourceImage());
        return band;
    }
}

