/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;

public class LcWbMetadata {
    private static final String LC_WB_ID_PATTERN = "ESACCI-LC-L4-WB-(?:Ocean-Land-)?Map-(.*m)-P(.*)Y-[aggregated]?-?.*?-?(....)-v(.*)";
    public static final String GLOBAL_ATTRIBUTES_ELEMENT_NAME = "Global_Attributes";
    private String type;
    private String id;
    private String epoch;
    private String version;
    private String spatialResolution;
    private String temporalResolution;

    public LcWbMetadata(Product sourceProduct) {
        MetadataElement metadataRoot = sourceProduct.getMetadataRoot();
        if (metadataRoot.containsElement(GLOBAL_ATTRIBUTES_ELEMENT_NAME)) {
            MetadataElement globalAttributes = metadataRoot.getElement(GLOBAL_ATTRIBUTES_ELEMENT_NAME);
            this.type = globalAttributes.getAttributeString("type");
            this.id = globalAttributes.getAttributeString("id");
            Matcher idMatcher = LcWbMetadata.lcMapTypeMatcher(this.id);
            this.spatialResolution = idMatcher.group(1);
            this.temporalResolution = idMatcher.group(2);
            this.epoch = idMatcher.group(3);
            this.version = idMatcher.group(4);
        } else {
            if (metadataRoot.containsAttribute("type")) {
                this.type = metadataRoot.getAttributeString("type");
            }
            if (metadataRoot.containsAttribute("id")) {
                this.id = metadataRoot.getAttributeString("id");
            }
            this.epoch = metadataRoot.getAttributeString("epoch");
            this.version = metadataRoot.getAttributeString("version");
            this.spatialResolution = metadataRoot.getAttributeString("spatialResolution");
            this.temporalResolution = metadataRoot.getAttributeString("temporalResolution");
        }
    }

    static Matcher lcMapTypeMatcher(String id) {
        Pattern p = Pattern.compile(LC_WB_ID_PATTERN);
        Matcher m = p.matcher(id);
        if (!m.matches()) {
            throw new IllegalArgumentException("Global attribute (id=" + id + ") does not match pattern " + LC_WB_ID_PATTERN);
        }
        return m;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getEpoch() {
        return this.epoch;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSpatialResolution() {
        return this.spatialResolution;
    }

    public String getTemporalResolution() {
        return this.temporalResolution;
    }
}

