/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import java.awt.Dimension;
import java.io.IOException;
import org.esa.cci.lc.io.LcWbMetadata;
import org.esa.cci.lc.io.LcWriterUtils;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.dataio.netcdf.AbstractNetCdfWriterPlugIn;
import org.esa.snap.dataio.netcdf.DefaultNetCdfWriter;
import org.esa.snap.dataio.netcdf.NullProfilePartWriter;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfileInitPartWriter;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartWriter;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamBandPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamInitialisationPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamNetCdf4WriterPlugIn;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.DataType;

public class LcWbNetCdf4WriterPlugIn
extends BeamNetCdf4WriterPlugIn {
    public static final String FORMAT_NAME = "NetCDF4-LC-WB";

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public ProductWriter createWriterInstance() {
        return new DefaultNetCdfWriter((AbstractNetCdfWriterPlugIn)this);
    }

    public ProfilePartWriter createMetadataPartWriter() {
        return new NullProfilePartWriter();
    }

    public ProfileInitPartWriter createInitialisationPartWriter() {
        return new LcWbInitialisationPart();
    }

    public ProfilePartWriter createDescriptionPartWriter() {
        return new NullProfilePartWriter();
    }

    public ProfilePartWriter createBandPartWriter() {
        return new BeamBandPart(){
            private static final String WB_CLASS_BAND_NAME = "wb_class";
            private static final String WS_OBSERVATION_COUNT_BAND_NAME = "ws_observation_count";
            private static final String GM_OBSERVATION_COUNT_BAND_NAME = "gm_observation_count";

            public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
                NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
                String ancillaryVariableString = this.getAncillaryVariableString(p);
                for (Band band : p.getBands()) {
                    Dimension tileSize = p.getPreferredTileSize();
                    if (WB_CLASS_BAND_NAME.equals(band.getName()) && !p.getMetadataRoot().getElements()[0].getAttributeString("type").contains("150")) {
                        this.addWbClassVariable(ncFile, band, tileSize, ancillaryVariableString);
                        continue;
                    }
                    if (WS_OBSERVATION_COUNT_BAND_NAME.equals(band.getName()) || GM_OBSERVATION_COUNT_BAND_NAME.equals(band.getName())) {
                        this.addObservationCountVariable(ncFile, band, tileSize);
                        continue;
                    }
                    if (WB_CLASS_BAND_NAME.equals(band.getName()) && p.getMetadataRoot().getElements()[0].getAttributeString("type").contains("150")) {
                        this.addWbInlandWBVariable(ncFile, band, tileSize, ancillaryVariableString);
                        continue;
                    }
                    this.addGeneralVariable(ncFile, band, tileSize);
                }
            }

            private String getAncillaryVariableString(Product p) {
                StringBuilder ancillaryVariables = new StringBuilder();
                for (Band band : p.getBands()) {
                    String bandName = band.getName();
                    if (!this.isAncillaryVariable(bandName)) continue;
                    if (ancillaryVariables.length() > 0) {
                        ancillaryVariables.append(' ');
                    }
                    ancillaryVariables.append(bandName);
                }
                return ancillaryVariables.toString();
            }

            private boolean isAncillaryVariable(String bandName) {
                return WS_OBSERVATION_COUNT_BAND_NAME.equals(bandName) || GM_OBSERVATION_COUNT_BAND_NAME.equals(bandName);
            }

            private void addWbClassVariable(NFileWriteable ncFile, Band band, Dimension tileSize, String ancillaryVariables) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, false, tileSize, ncFile.getDimensions());
                byte[] wbClassFlagValues = new byte[]{0, 1};
                ArrayByte.D1 valids = new ArrayByte.D1(wbClassFlagValues.length, variable.getDataType().isUnsigned());
                for (int i = 0; i < wbClassFlagValues.length; ++i) {
                    valids.set(i, wbClassFlagValues[i]);
                }
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "land_cover_lccs");
                variable.addAttribute("flag_values", (Array)valids);
                variable.addAttribute("flag_meanings", "terrestrial water");
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)1);
                variable.addAttribute("_Unsigned", "true");
                variable.addAttribute("_FillValue", (Number)0);
                if (ancillaryVariables.length() > 0) {
                    variable.addAttribute("ancillary_variables", ancillaryVariables);
                }
            }

            private void addObservationCountVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", "land_cover_lccs number_of_observations");
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)Short.MAX_VALUE);
                if (ncDataType == DataType.SHORT) {
                    variable.addAttribute("_FillValue", (Number)-1);
                } else {
                    variable.addAttribute("_FillValue", (Number)-1);
                }
            }

            private void addGeneralVariable(NFileWriteable ncFile, Band band, Dimension tileSize) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, tileSize, ncFile.getDimensions());
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", band.getName());
                if (band.getScalingOffset() != 0.0) {
                    variable.addAttribute("add_offset", (Number)band.getScalingOffset());
                }
                if (band.getScalingFactor() != 1.0) {
                    variable.addAttribute("scale_factor", (Number)band.getScalingFactor());
                }
                variable.addAttribute("_FillValue", (Number)Float.valueOf(Float.NaN));
            }

            private void addWbInlandWBVariable(NFileWriteable ncFile, Band band, Dimension tileSize, String ancillaryVariables) throws IOException {
                DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)band.getDataType());
                String variableName = ReaderUtils.getVariableName((RasterDataNode)band);
                NVariable variable = ncFile.addVariable(variableName, ncDataType, false, tileSize, ncFile.getDimensions());
                byte[] wbClassFlagValues = new byte[]{0, 1, 2};
                ArrayByte.D1 valids = new ArrayByte.D1(wbClassFlagValues.length, variable.getDataType().isUnsigned());
                for (int i = 0; i < wbClassFlagValues.length; ++i) {
                    valids.set(i, wbClassFlagValues[i]);
                }
                variable.addAttribute("long_name", band.getDescription());
                variable.addAttribute("standard_name", WB_CLASS_BAND_NAME);
                variable.addAttribute("flag_values", (Array)valids);
                variable.addAttribute("flag_meanings", "ocean_water terrestrial inland_water");
                variable.addAttribute("valid_min", (Number)0);
                variable.addAttribute("valid_max", (Number)2);
                variable.addAttribute("_Unsigned", "true");
                variable.addAttribute("_FillValue", (Number)127);
                if (ancillaryVariables.length() > 0) {
                    variable.addAttribute("ancillary_variables", ancillaryVariables);
                }
            }
        };
    }

    class LcWbInitialisationPart
    extends BeamInitialisationPart {
        LcWbInitialisationPart() {
        }

        public void writeProductBody(ProfileWriteContext ctx, Product product) throws IOException {
            NFileWriteable writeable = ctx.getNetcdfFileWriteable();
            LcWbMetadata lcWbMetadata = new LcWbMetadata(product);
            String spatialResolution = lcWbMetadata.getSpatialResolution();
            String temporalResolution = lcWbMetadata.getTemporalResolution();
            String epoch = lcWbMetadata.getEpoch();
            String version = lcWbMetadata.getVersion();
            GeoCoding geoCoding = product.getSceneGeoCoding();
            GeoPos upperLeft = geoCoding.getGeoPos(new PixelPos(0.0, 0.0), null);
            GeoPos lowerRight = geoCoding.getGeoPos(new PixelPos((double)product.getSceneRasterWidth(), (double)product.getSceneRasterHeight()), null);
            String latMax = String.valueOf(upperLeft.getLat());
            String latMin = String.valueOf(lowerRight.getLat());
            String lonMin = String.valueOf(upperLeft.getLon());
            String lonMax = String.valueOf(lowerRight.getLon());
            String spatialResolutionDegrees = "1000m".equals(spatialResolution) ? "0.011112" : ("300m".equals(spatialResolution) ? "0.002778" : ("150m".equals(spatialResolution) ? "0.001389" : "180*" + spatialResolution + "/19440km"));
            int epochInt = Integer.parseInt(epoch);
            int temporalResolutionInt = Integer.parseInt(temporalResolution);
            String startYear = String.valueOf(epochInt);
            String startTime = startYear + "0101";
            String endYear = String.valueOf(epochInt + temporalResolutionInt - 1);
            String endTime = endYear + "1231";
            String temporalCoverageYears = this.getTemporalCoverage(startYear, endYear);
            writeable.addGlobalAttribute("title", "ESA CCI Land Cover Water Bodies Map");
            writeable.addGlobalAttribute("summary", "This dataset contains the global ESA CCI land cover water bodies map derived from satellite data.");
            writeable.addGlobalAttribute("type", lcWbMetadata.getType());
            writeable.addGlobalAttribute("id", lcWbMetadata.getId());
            Dimension tileSize = product.getPreferredTileSize();
            LcWriterUtils.addGenericGlobalAttributes(writeable, String.format("%d:%d", tileSize.width, tileSize.height));
            LcWriterUtils.addSpecificGlobalAttributes("ASAR", "lc-wb-classification-1.0", spatialResolutionDegrees, spatialResolution, temporalCoverageYears, temporalResolution, "Y", startTime, endTime, version, latMax, latMin, lonMin, lonMax, writeable, "ESA 2015 - UCLouvain and Gamma-RS");
            writeable.addDimension("lat", product.getSceneRasterHeight());
            writeable.addDimension("lon", product.getSceneRasterWidth());
        }

        private String getTemporalCoverage(String startYear, String endYear) {
            String temporalCoverageYears;
            try {
                temporalCoverageYears = String.valueOf(Integer.parseInt(endYear) - Integer.parseInt(startYear) + 1);
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("cannot parse " + startYear + " and " + endYear + " as year numbers", ex);
            }
            return temporalCoverageYears;
        }
    }
}

