/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.cci.lc.io.LcWbTiffReaderPlugin;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;

public class LcWbTiffReader
extends AbstractProductReader {
    public static final String LC_WB_FILENAME_PATTERN = "ESACCI-LC-L4-WB-(?:Ocean-Land-)?Map-(.*m)-P(.*)Y-(....)-v(.*).(tiff?)";
    public static final String[] FLAG_NAMES = new String[]{"NObsImsWS", "NObsImsGM"};
    public static final String[] LC_VARIABLE_NAMES = new String[]{"wb_class", "ws_observation_count", "gm_observation_count"};
    private static final String[] LC_VARIABLE_DESCRIPTIONS = new String[]{"terrestrial or water pixel classification", "number of valid observations from WS mode", "number of valid observations from general mode"};
    private List<Product> bandProducts;

    public LcWbTiffReader(LcWbTiffReaderPlugin readerPlugin) {
        super((ProductReaderPlugIn)readerPlugin);
    }

    protected Product readProductNodesImpl() throws IOException {
        GeoTiffProductReaderPlugIn plugIn = new GeoTiffProductReaderPlugIn();
        this.bandProducts = new ArrayList<Product>();
        File lcWbFile = LcWbTiffReader.getFileInput(this.getInput());
        if (!lcWbFile.exists()) {
            throw new IOException("Input file does not exist: " + lcWbFile.getAbsolutePath());
        }
        File productDir = lcWbFile.getParentFile();
        String lcWbFilename = lcWbFile.getName();
        Matcher m = LcWbTiffReader.lcWbFileMatcher(lcWbFilename);
        String spatialResolution = m.group(1);
        String temporalResolution = m.group(2);
        String epoch = m.group(3);
        String version = m.group(4);
        String extension = m.group(5);
        Product lcWbProduct = LcWbTiffReader.readProduct(productDir, lcWbFilename, (ProductReaderPlugIn)plugIn);
        Product result = new Product("LC_WB_" + epoch + "_v" + version, "LC_WB_Map", lcWbProduct.getSceneRasterWidth(), lcWbProduct.getSceneRasterHeight());
        result.setPreferredTileSize(new Dimension(1024, 1024));
        result.setFileLocation(lcWbFile);
        ProductUtils.copyGeoCoding((Product)lcWbProduct, (Product)result);
        MetadataElement metadataRoot = result.getMetadataRoot();
        metadataRoot.setAttributeString("epoch", epoch);
        metadataRoot.setAttributeString("version", version);
        metadataRoot.setAttributeString("spatialResolution", spatialResolution);
        metadataRoot.setAttributeString("temporalResolution", temporalResolution);
        MetadataElement globalAttributes = new MetadataElement("global_attributes");
        metadataRoot.addElement(globalAttributes);
        globalAttributes = metadataRoot.getElement("global_attributes");
        globalAttributes.setAttributeString("epoch", epoch);
        globalAttributes.setAttributeString("version", version);
        globalAttributes.setAttributeString("spatialResolution", spatialResolution);
        globalAttributes.setAttributeString("temporalResolution", temporalResolution);
        globalAttributes.setAttributeString("id", lcWbFilename.substring(0, lcWbFilename.lastIndexOf(46)));
        globalAttributes.setAttributeString("type", lcWbFilename.substring(0, lcWbFilename.lastIndexOf(46)));
        this.bandProducts.add(lcWbProduct);
        Band band = LcWbTiffReader.addBand(0, lcWbProduct, result);
        band.setDescription(LC_VARIABLE_DESCRIPTIONS[0]);
        for (int i = 0; i < FLAG_NAMES.length; ++i) {
            String lcFlagFilename = lcWbFilename.replace("Map", FLAG_NAMES[i]);
            Product lcFlagProduct = LcWbTiffReader.readProduct(productDir, lcFlagFilename, (ProductReaderPlugIn)plugIn);
            if (lcFlagProduct == null) continue;
            if (result.getSceneRasterWidth() != lcFlagProduct.getSceneRasterWidth() || result.getSceneRasterHeight() != lcFlagProduct.getSceneRasterHeight()) {
                throw new IllegalArgumentException("dimensions of flag band " + FLAG_NAMES[i] + " does not match WB map");
            }
            this.bandProducts.add(lcFlagProduct);
            band = LcWbTiffReader.addBand(i + 1, lcFlagProduct, result);
            band.setDescription(LC_VARIABLE_DESCRIPTIONS[i + 1]);
        }
        return result;
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException();
    }

    private static File getFileInput(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        throw new IllegalArgumentException("unexpected class " + input.getClass() + " of the input");
    }

    private static Matcher lcWbFileMatcher(String lcWbFilename) {
        Pattern p = Pattern.compile(LC_WB_FILENAME_PATTERN);
        Matcher m = p.matcher(lcWbFilename);
        if (!m.matches()) {
            throw new IllegalArgumentException("input file name " + lcWbFilename + " does not match pattern " + LC_WB_FILENAME_PATTERN);
        }
        return m;
    }

    private static Product readProduct(File productDir, String lcFlagFilename, ProductReaderPlugIn plugIn) throws IOException {
        File lcFlagFile = new File(productDir, lcFlagFilename);
        if (!lcFlagFile.canRead()) {
            return null;
        }
        ProductReader productReader1 = plugIn.createReaderInstance();
        return productReader1.readProductNodes((Object)lcFlagFile, null);
    }

    private static Band addBand(int i, Product lcFlagProduct, Product result) {
        Band srcBand = lcFlagProduct.getBandAt(0);
        String bandName = LC_VARIABLE_NAMES[i];
        Band band = result.addBand(bandName, srcBand.getDataType());
        band.setNoDataValueUsed(false);
        band.setSourceImage(srcBand.getSourceImage());
        return band;
    }

    public void close() throws IOException {
        for (Product bandProduct : this.bandProducts) {
            bandProduct.closeIO();
        }
        this.bandProducts.clear();
        super.close();
    }
}

