/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import java.io.File;
import java.util.Locale;
import org.esa.cci.lc.io.LcWbTiffReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;

public class LcWbTiffReaderPlugin
implements ProductReaderPlugIn {
    private static final Class[] READER_INPUT_TYPES = new Class[]{String.class, File.class};
    private static final String FORMAT_NAME_TIFF = "LC_WB_TIFF";
    private static final String[] FORMAT_NAMES = new String[]{"LC_WB_TIFF"};
    private static final String[] DEFAULT_FILE_EXTENSIONS = new String[]{".tif", ".tiff", ".TIF", ".TIFF"};
    private static final String READER_DESCRIPTION = "Land Cover CCI Water Bodies map tiff with flag tiffs in same dir";
    private static final SnapFileFilter FILE_FILTER = new TiffFileFilter();

    public DecodeQualification getDecodeQualification(Object input) {
        String filename;
        if (input instanceof String) {
            filename = ((String)input).substring(((String)input).lastIndexOf(File.separatorChar) + 1);
        } else if (input instanceof File) {
            filename = ((File)input).getPath().substring(((File)input).getPath().lastIndexOf(File.separatorChar) + 1);
        } else {
            return DecodeQualification.UNABLE;
        }
        if (filename.matches("ESACCI-LC-L4-WB-(?:Ocean-Land-)?Map-(.*m)-P(.*)Y-(....)-v(.*).(tiff?)")) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return READER_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new LcWbTiffReader(this);
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return DEFAULT_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return READER_DESCRIPTION;
    }

    public SnapFileFilter getProductFileFilter() {
        return FILE_FILTER;
    }

    static boolean isTifFile(File file) {
        return file != null && FileUtils.getExtension((File)file) != null && (FileUtils.getExtension((File)file).equalsIgnoreCase(".tif") || FileUtils.getExtension((File)file).equalsIgnoreCase(".tiff"));
    }

    private static class TiffFileFilter
    extends SnapFileFilter {
        public TiffFileFilter() {
            this.setFormatName(FORMAT_NAMES[0]);
            this.setDescription(LcWbTiffReaderPlugin.READER_DESCRIPTION);
        }

        public boolean accept(File file) {
            return file.isDirectory() || LcWbTiffReaderPlugin.isTifFile(file);
        }

        public SnapFileFilter.FileSelectionMode getFileSelectionMode() {
            return SnapFileFilter.FileSelectionMode.FILES_ONLY;
        }
    }
}

