/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import org.esa.snap.binning.PlanetaryGrid;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class RegionalPlanetaryGrid
implements PlanetaryGrid {
    private final PlanetaryGrid globalGrid;
    private final ReferencedEnvelope region;
    private long binIndexOffset;
    private long binIndexMax;
    private int rowOffset;
    private int columnOffset;
    private int numRows;
    private long numBins;
    private int numCols;

    public RegionalPlanetaryGrid(PlanetaryGrid globalGrid, ReferencedEnvelope region) {
        this.globalGrid = globalGrid;
        this.region = new ReferencedEnvelope(region);
        this.initBinIndexValues(globalGrid);
    }

    public PlanetaryGrid getGlobalGrid() {
        return this.globalGrid;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public int getColumnOffset() {
        return this.columnOffset;
    }

    public long getBinIndex(double lat, double lon) {
        if (!this.contains(lat, lon)) {
            String msg = String.format("Location (%f, %f) not contained in this grid", lat, lon);
            throw new IllegalArgumentException(msg);
        }
        return this.globalGrid.getBinIndex(lat, lon);
    }

    public int getRowIndex(long bin) {
        if (!this.isBinIndexInRegionalGrid(bin)) {
            String msg = String.format("Bin index (%d) not contained in this grid", bin);
            throw new IllegalArgumentException(msg);
        }
        return this.globalGrid.getRowIndex(bin) - this.rowOffset;
    }

    public long getNumBins() {
        return this.numBins;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols(int row) {
        return this.numCols;
    }

    public long getFirstBinIndex(int row) {
        return this.globalGrid.getFirstBinIndex(this.rowOffset + row) + (long)this.columnOffset;
    }

    public double getCenterLat(int row) {
        return this.globalGrid.getCenterLat(this.rowOffset + row);
    }

    public double[] getCenterLatLon(long bin) {
        if (!this.isBinIndexInRegionalGrid(bin)) {
            return new double[]{Double.NaN, Double.NaN};
        }
        return this.globalGrid.getCenterLatLon(bin);
    }

    public boolean isBinIndexInRegionalGrid(long bin) {
        if (bin < this.binIndexOffset || bin > this.binIndexMax) {
            return false;
        }
        int numColsParent = this.globalGrid.getNumCols(0);
        for (int i = 0; i < this.getNumRows(); ++i) {
            long startBinIndex = this.getFirstBinIndex(i);
            long endBinIndex = startBinIndex + (long)this.numCols - 1L;
            long endParentRowBinIndex = this.globalGrid.getFirstBinIndex(i + this.rowOffset) + (long)numColsParent - 1L;
            if (bin >= startBinIndex && bin <= endBinIndex) {
                return true;
            }
            if (bin >= startBinIndex && (bin <= endBinIndex || bin > endParentRowBinIndex)) continue;
            return false;
        }
        return false;
    }

    private void initBinIndexValues(PlanetaryGrid globalGrid) {
        this.binIndexOffset = globalGrid.getBinIndex(this.getLatMaximum(), this.getLonMinimum());
        this.binIndexMax = globalGrid.getBinIndex(this.getLatMinimum(), this.getLonMaximum());
        long urIndex = globalGrid.getBinIndex(this.getLatMaximum(), this.getLonMaximum());
        this.numCols = (int)(urIndex - this.binIndexOffset) + 1;
        this.rowOffset = globalGrid.getRowIndex(this.binIndexOffset);
        this.columnOffset = (int)(this.binIndexOffset - globalGrid.getFirstBinIndex(this.rowOffset));
        int maxRowIndex = globalGrid.getRowIndex(this.binIndexMax);
        this.numRows = maxRowIndex + 1 - this.rowOffset;
        this.numBins = this.numCols * this.numRows;
    }

    private boolean contains(double lat, double lon) {
        return lat <= this.getLatMaximum() && lat >= this.getLatMinimum() && lon <= this.getLonMaximum() && lon >= this.getLonMinimum();
    }

    private double getLonMaximum() {
        return this.region.getMaximum(0);
    }

    private double getLatMinimum() {
        return this.region.getMinimum(1);
    }

    private double getLonMinimum() {
        return this.region.getMinimum(0);
    }

    private double getLatMaximum() {
        return this.region.getMaximum(1);
    }
}

