/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.io;

import org.esa.cci.lc.io.AbstractCoordinateEncoder;
import org.esa.snap.binning.PlanetaryGrid;

class RegularGaussianCoordinateEncoder
extends AbstractCoordinateEncoder {
    public RegularGaussianCoordinateEncoder(PlanetaryGrid planetaryGrid) {
        super(planetaryGrid);
    }

    @Override
    protected float[] getLonValues(int sceneWidth) {
        float[] lons = new float[sceneWidth];
        int firstBinIndex = (int)this.planetaryGrid.getFirstBinIndex(0);
        for (int i = 0; i < sceneWidth; ++i) {
            lons[i] = ((float)this.planetaryGrid.getCenterLatLon((long)(firstBinIndex + i))[1] + 360.0f) % 360.0f;
        }
        return lons;
    }

    @Override
    protected float[] getLatValues(int sceneHeight) {
        float[] lats = new float[sceneHeight];
        for (int i = 0; i < sceneHeight; ++i) {
            lats[i] = (float)this.planetaryGrid.getCenterLat(i);
        }
        return lats;
    }
}

