/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.subset;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import org.esa.cci.lc.subset.PredefinedRegion;
import org.esa.cci.lc.util.LcHelper;
import org.esa.cci.lc.util.PlanetaryGridName;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@OperatorMetadata(alias="LCCCI.Subset", version="5.0", authors="Marco Peters", copyright="(c) 2013 by Brockmann Consult", description="Allows to subset LC map and condition products.", autoWriteDisabled=true)
public class LcSubsetOp
extends Operator {
    @SourceProduct(description="LC CCI map or conditions product.", optional=false)
    private Product sourceProduct;
    @Parameter(description="The target directory.")
    private File targetDir;
    @Parameter(description="The western longitude.", interval="[-180,360]", unit="\u00b0")
    private Float west;
    @Parameter(description="The northern latitude.", interval="[-90,90]", unit="\u00b0")
    private Float north;
    @Parameter(description="The eastern longitude.", interval="[-180,360]", unit="\u00b0")
    private Float east;
    @Parameter(description="The southern latitude.", interval="[-90,90]", unit="\u00b0")
    private Float south;
    @Parameter(description="Format of the output file: lccci,lccds", defaultValue="lccci")
    private String format;
    @Parameter(description="A predefined set of north, east, south and west bounds.", valueSet={"NORTH_AMERICA", "CENTRAL_AMERICA", "SOUTH_AMERICA", "WESTERN_EUROPE_AND_MEDITERRANEAN", "ASIA", "AFRICA", "SOUTH_EAST_ASIA", "AUSTRALIA_AND_NEW_ZEALAND", "GREENLAND"})
    private PredefinedRegion predefinedRegion;
    Product subsetProduct;
    boolean writeProduct = true;
    private File targetFile;

    public void initialize() throws OperatorException {
        String formatName;
        this.validateInputSettings();
        this.targetDir = LcHelper.ensureTargetDir(this.targetDir, this.getSourceProduct());
        String id = this.createId();
        if (this.isPredefinedRegionSet()) {
            PredefinedRegion r = this.predefinedRegion;
            this.north = Float.valueOf(r.getNorth());
            this.east = Float.valueOf(r.getEast());
            this.south = Float.valueOf(r.getSouth());
            this.west = Float.valueOf(r.getWest());
            MetadataElement globalAttributes = this.getSourceProduct().getMetadataRoot().getElement("Global_Attributes");
            if (globalAttributes.getAttributeString("grid_name", "").startsWith("Regular gaussian grid")) {
                this.east = Float.valueOf((this.east.floatValue() + 360.0f) % 360.0f);
                this.west = Float.valueOf((this.west.floatValue() + 360.0f) % 360.0f);
            }
        }
        this.subsetProduct = LcHelper.createProductSubset(this.getSourceProduct(), this.north.floatValue(), this.east.floatValue(), this.south.floatValue(), this.west.floatValue(), this.getRegionIdentifier());
        this.subsetProduct.setPreferredTileSize(LcHelper.TILE_SIZE);
        this.updateIdMetadataAttribute(id);
        if (id.startsWith("ESACCI-LC-L4-LCCS-Map-") || id.startsWith("ESACCI-LC-L4-LCCS-AlternativeMap")) {
            formatName = "NetCDF4-LC-Map";
        } else if (id.startsWith("ESACCI-LC-L4-WB-Map-")) {
            formatName = "NetCDF4-LC-WB";
        } else if (id.startsWith("ESACCI-LC-L4-PFT")) {
            this.subsetProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("parent_path", this.sourceProduct.getFileLocation().getAbsolutePath());
            formatName = "NetCDF4-LC-CDS";
        } else if (id.startsWith("C3S-LC-L4-LCCS-Map")) {
            this.subsetProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("parent_path", this.sourceProduct.getFileLocation().getAbsolutePath());
            formatName = "NetCDF4-LC-CDS";
        } else {
            formatName = "NetCDF4-LC-Condition";
        }
        if (this.format.equals("lccds") || this.format.equals("lcpft")) {
            formatName = "NetCDF4-LC-CDS";
            this.subsetProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("parent_path", this.sourceProduct.getFileLocation().getAbsolutePath());
            this.subsetProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("geospatial_lat_min", this.south.toString());
            this.subsetProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("geospatial_lat_max", this.north.toString());
            this.subsetProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("geospatial_lon_min", this.west.toString());
            this.subsetProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("geospatial_lon_max", this.east.toString());
            this.subsetProduct.getMetadataRoot().getElement("global_attributes").setAttributeString("subsetted", "true");
        }
        if (this.targetFile == null) {
            this.targetFile = new File(this.targetDir, id + ".nc");
        }
        if (this.writeProduct) {
            GPF.writeProduct((Product)this.subsetProduct, (File)this.targetFile, (String)formatName, (boolean)false, (ProgressMonitor)ProgressMonitor.NULL);
        }
        this.setTargetProduct(new Product("dummy", "dummyType", 10, 10));
    }

    private void validateInputSettings() {
        if (!this.isPredefinedRegionSet() && !this.isUserDefinedRegionSet()) {
            throw new OperatorException("Either predefined region or geographical bounds must be given.");
        }
        if (this.isRegularGuassianGrid() && this.getRegionIdentifier() != null) {
            ReferencedEnvelope regionEnvelope = this.getRegionEnvelope();
            double maxLon = regionEnvelope.getMaximum(0);
            double minLon = regionEnvelope.getMinimum(0);
            if (maxLon > 0.0 && minLon < 0.0) {
                String msg = "The planetary grid '%s' can not be used in combination with a region which crosses the prime meridian.";
                throw new OperatorException(String.format(msg, new Object[]{PlanetaryGridName.REGULAR_GAUSSIAN_GRID}));
            }
        }
    }

    private boolean isRegularGuassianGrid() {
        MetadataElement globalAttributes = this.getSourceProduct().getMetadataRoot().getElement("Global_Attributes");
        return globalAttributes.getAttributeString("grid_name", "").startsWith("Regular gaussian grid");
    }

    private ReferencedEnvelope getRegionEnvelope() {
        if (this.isPredefinedRegionSet()) {
            return new ReferencedEnvelope((double)this.predefinedRegion.getEast(), (double)this.predefinedRegion.getWest(), (double)this.predefinedRegion.getNorth(), (double)this.predefinedRegion.getSouth(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        if (this.isUserDefinedRegionSet()) {
            return new ReferencedEnvelope((double)this.east.floatValue(), (double)this.west.floatValue(), (double)this.north.floatValue(), (double)this.south.floatValue(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        return null;
    }

    private void updateIdMetadataAttribute(String id) {
        MetadataElement metadataRoot = this.getSourceProduct().getMetadataRoot();
        if (metadataRoot.containsElement("Global_Attributes")) {
            MetadataElement globalAttributes = metadataRoot.getElement("Global_Attributes");
            globalAttributes.setAttributeString("id", id);
        }
    }

    private String createId() {
        MetadataElement metadataRoot = this.getSourceProduct().getMetadataRoot();
        if (metadataRoot.containsElement("Global_Attributes")) {
            MetadataElement globalAttributes = metadataRoot.getElement("Global_Attributes");
            String id = globalAttributes.getAttributeString("id");
            int p1 = id.lastIndexOf("-");
            int p2 = id.lastIndexOf("-", p1);
            return id.substring(0, p2) + "-" + this.getRegionIdentifier() + id.substring(p2);
        }
        throw new IllegalStateException("Missing metadata element Global_Attributes");
    }

    private String getRegionIdentifier() {
        if (this.isPredefinedRegionSet()) {
            return this.predefinedRegion.toString();
        }
        return "USER_REGION";
    }

    public void setWest(float west) {
        this.west = Float.valueOf(west);
    }

    public void setNorth(float north) {
        this.north = Float.valueOf(north);
    }

    public void setEast(float east) {
        this.east = Float.valueOf(east);
    }

    public void setSouth(float south) {
        this.south = Float.valueOf(south);
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    public void setPredefinedRegion(PredefinedRegion predefinedRegion) {
        this.predefinedRegion = predefinedRegion;
    }

    private boolean isPredefinedRegionSet() {
        return this.predefinedRegion != null;
    }

    private boolean isUserDefinedRegionSet() {
        boolean valid;
        boolean bl = valid = this.north != null && this.east != null && this.south != null && this.west != null;
        if (valid) {
            if (this.west.floatValue() >= this.east.floatValue()) {
                throw new OperatorException("West bound must be western of east bound.");
            }
            if (this.north.floatValue() <= this.south.floatValue()) {
                throw new OperatorException("North bound must be northern of south bound.");
            }
            if (this.isRegularGuassianGrid() && (this.west.floatValue() < 0.0f || this.east.floatValue() < 0.0f)) {
                throw new OperatorException("West and east bound must be between 0 and 360 for regular gaussian grid.");
            }
        }
        return valid;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(LcSubsetOp.class);
        }
    }
}

