/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;

public class CdsVariableWriter
extends ProfilePartIO {
    public void decode(ProfileReadContext ctx, Product p) {
    }

    public void encode(ProfileWriteContext ctx, Product p) throws IOException {
        Double lonMax;
        Double lonMin;
        NFileWriteable writeable = ctx.getNetcdfFileWriteable();
        MetadataElement element = p.getMetadataRoot().getElement("global_attributes");
        String path = element.getAttributeString("parent_path");
        Double latMin = -90.0;
        Double latMax = 90.0;
        if (p.getMetadataRoot().getElement("global_attributes").containsAttribute("geospatial_lat_min")) {
            latMin = p.getMetadataRoot().getElement("global_attributes").getAttributeDouble("geospatial_lat_min");
        }
        if (p.getMetadataRoot().getElement("global_attributes").containsAttribute("geospatial_lat_max")) {
            latMax = p.getMetadataRoot().getElement("global_attributes").getAttributeDouble("geospatial_lat_max");
        }
        if (element.containsAttribute("subsetted") || path.endsWith(".tif")) {
            lonMin = p.getMetadataRoot().getElement("global_attributes").getAttributeDouble("geospatial_lon_min");
            lonMax = p.getMetadataRoot().getElement("global_attributes").getAttributeDouble("geospatial_lon_max");
        } else {
            lonMin = -180.0;
            lonMax = 180.0;
        }
        CdsVariableWriter.lcLatLonCustomBoundsWriter(writeable, p.getSceneRasterHeight(), p.getSceneRasterWidth(), lonMin, lonMax, latMin, latMax);
        CdsVariableWriter.timeWriter(writeable, element);
    }

    public static void lcLatLonCustomBoundsWriter(NFileWriteable writeable, int heigth, int width, Double minLon, Double maxLon, Double minLat, Double maxLat) throws IOException {
        int numLatPixels = heigth;
        double divider = (double)numLatPixels / (maxLat - minLat);
        double step = 1.0 / divider;
        double[] latArray = new double[2 * numLatPixels];
        double[] lat = new double[numLatPixels];
        int j = 0;
        for (int i = 0; i < numLatPixels; ++i) {
            latArray[j] = minLat + (double)i * step;
            latArray[j + 1] = minLat + (double)(i + 1) * step;
            j += 2;
            lat[i] = minLat + ((double)i + 0.5) * step;
        }
        Array data = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{numLatPixels, 2}, (Object)latArray);
        try {
            data = data.flip(0);
            data = data.flip(1);
            writeable.getWriter().write("lat_bounds", data);
        }
        catch (InvalidRangeException i) {
            // empty catch block
        }
        data = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{numLatPixels, 1}, (Object)lat);
        data = data.flip(0);
        try {
            writeable.getWriter().write("lat", data);
        }
        catch (InvalidRangeException i) {
            // empty catch block
        }
        int numLonPixels = width;
        if (minLon > maxLon) {
            maxLon = maxLon + 360.0;
        }
        divider = (double)numLonPixels / (maxLon - minLon);
        step = 1.0 / divider;
        double[] lonArray = new double[2 * numLonPixels];
        double[] lon = new double[numLonPixels];
        j = 0;
        for (int i = 0; i < numLonPixels; ++i) {
            lonArray[j] = minLon + (double)i * step;
            lonArray[j + 1] = minLon + (double)(i + 1) * step;
            lon[i] = minLon + ((double)i + 0.5) * step;
            if (minLon + (double)i * step == 360.0) {
                lonArray[j] = 360.0;
            }
            if (minLon + (double)(i + 1) * step == 360.0) {
                lonArray[j + 1] = 360.0;
            }
            if (minLon + ((double)i + 0.5) * step == 360.0) {
                lon[i] = 360.0;
            }
            j += 2;
        }
        data = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{numLonPixels, 2}, (Object)lonArray);
        try {
            writeable.getWriter().write("lon_bounds", data);
        }
        catch (InvalidRangeException invalidRangeException) {
            // empty catch block
        }
        data = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{numLonPixels, 1}, (Object)lon);
        try {
            writeable.getWriter().write("lon", data);
        }
        catch (InvalidRangeException invalidRangeException) {
            // empty catch block
        }
    }

    public static void timeWriter(NFileWriteable writeable, MetadataElement element) throws IOException {
        String YearString = element.getAttributeString("time_coverage_start").substring(0, 4);
        String firstMonth = element.getAttributeString("time_coverage_start").substring(4, 6);
        String lastMonth = element.getAttributeString("time_coverage_end").substring(4, 6);
        String firstDay = element.getAttributeString("time_coverage_start").substring(6, 8);
        String lastDay = element.getAttributeString("time_coverage_end").substring(6, 8);
        try {
            SimpleDateFormat tempFormat = new SimpleDateFormat("dd MM yyyy");
            Date startDay = tempFormat.parse(firstDay + " " + firstMonth + " " + YearString);
            Date finalDay = tempFormat.parse(lastDay + " " + lastMonth + " " + YearString);
            Date startCalendar = tempFormat.parse("01 01 1970");
            long startYear = startDay.getTime() - startCalendar.getTime();
            double begTime = TimeUnit.DAYS.convert(startYear, TimeUnit.MILLISECONDS);
            long endYear = finalDay.getTime() - startCalendar.getTime();
            double endTime = TimeUnit.DAYS.convert(endYear, TimeUnit.MILLISECONDS);
            Array data = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{1, 2}, (Object)new double[]{begTime, endTime});
            try {
                writeable.getWriter().write("time_bounds", data);
            }
            catch (InvalidRangeException invalidRangeException) {
                // empty catch block
            }
            data = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{1}, (Object)new double[]{begTime});
            try {
                writeable.getWriter().write("time", data);
            }
            catch (InvalidRangeException invalidRangeException) {}
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
    }
}

