/*
 * Decompiled with CFR 0.152.
 */
package org.esa.cci.lc.util;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.esa.cci.lc.aggregation.Lccs2PftLut;
import org.esa.cci.lc.aggregation.Lccs2PftLutBuilder;
import org.esa.cci.lc.aggregation.Lccs2PftLutException;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;

public class LcHelper {
    public static final Dimension TILE_SIZE = new Dimension(2025, 2025);
    public static final String TILE_SIZE_STRING = LcHelper.format(TILE_SIZE);
    public static final String PROP_NAME_TILE_SIZE = "TileSize";

    public static String getTargetFileName(String sourceFileName, String insertion) {
        String sep = "-";
        String[] strings = sourceFileName.split("-");
        int insertionPos = strings.length - 2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length - 1; ++i) {
            String string = strings[i];
            if (i == insertionPos) {
                sb.append(insertion).append("-");
            }
            sb.append(string).append("-");
        }
        sb.append(strings[strings.length - 1]);
        return sb.toString();
    }

    public static Product createProductSubset(Product product, double north, double east, double south, double west, String regionIdentifier) {
        Rectangle pixelRect = LcHelper.getPixelBounds(north, east, south, west, product.getSceneGeoCoding());
        Rectangle productRect = new Rectangle(0, 0, product.getSceneRasterWidth(), product.getSceneRasterHeight());
        pixelRect = pixelRect.intersection(productRect);
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        parameters.put("region", pixelRect);
        parameters.put("copyMetadata", Boolean.valueOf(true));
        Product subset = GPF.createProduct((String)"Subset", parameters, (Product)product);
        if (regionIdentifier != null) {
            subset.getMetadataRoot().setAttributeString("regionIdentifier", regionIdentifier);
        }
        subset.getMetadataRoot().getElement("global_attributes").setAttributeString("geospatial_lat_min", String.valueOf(south));
        subset.getMetadataRoot().getElement("global_attributes").setAttributeString("geospatial_lat_max", String.valueOf(north));
        subset.getMetadataRoot().getElement("global_attributes").setAttributeString("geospatial_lon_min", String.valueOf(west));
        subset.getMetadataRoot().getElement("global_attributes").setAttributeString("geospatial_lon_max", String.valueOf(east));
        subset.getMetadataRoot().getElement("global_attributes").setAttributeString("subsetted", "true");
        return subset;
    }

    private static Rectangle getPixelBounds(double north, double east, double south, double west, GeoCoding geoCoding) {
        GeoPos ulGePo = new GeoPos((double)((float)north), (double)((float)west));
        GeoPos lrGePo = new GeoPos((double)((float)south), (double)((float)east));
        PixelPos ulPiPo = geoCoding.getPixelPos(ulGePo, null);
        PixelPos lrPiPo = geoCoding.getPixelPos(lrGePo, null);
        int x = (int)ulPiPo.x;
        int y = (int)ulPiPo.y;
        int width = (int)lrPiPo.x - x + 1;
        int height = (int)lrPiPo.y - y + 1;
        return new Rectangle(x, y, width, height);
    }

    public static File ensureTargetDir(File targetDir, Product sourceProduct) {
        if (targetDir == null) {
            File fileLocation = sourceProduct.getFileLocation();
            if (fileLocation != null && (targetDir = fileLocation.getParentFile()) == null) {
                throw new OperatorException("Can not retrieve parent directory from source product");
            }
        } else {
            if (!targetDir.isDirectory() && targetDir.isFile()) {
                throw new OperatorException("The target directory is not a directory. Looks like a file.");
            }
            if (!targetDir.exists() && !targetDir.mkdir()) {
                throw new OperatorException("The target directory could not be created.");
            }
        }
        return targetDir;
    }

    public static void addPFTTableInfoToLcProperties(HashMap<String, String> lcProperties, boolean outputPFTClasses, File userPFTConversionTable, File additionalUserMapPFTConversionTable) {
        if (outputPFTClasses) {
            try {
                Lccs2PftLut pftLut;
                String pftTableEntry;
                Lccs2PftLutBuilder lutBuilder = new Lccs2PftLutBuilder();
                if (userPFTConversionTable != null) {
                    pftTableEntry = String.format("User defined PFT conversion table used (%s)", userPFTConversionTable.getName());
                    lutBuilder = lutBuilder.useLccs2PftTable(new FileReader(userPFTConversionTable));
                } else {
                    pftTableEntry = "LC-CCI conform PFT conversion table";
                }
                if (additionalUserMapPFTConversionTable != null) {
                    pftTableEntry = pftTableEntry + String.format(" + additional user map PFT conversion table (%s)", additionalUserMapPFTConversionTable.getName());
                    lutBuilder = lutBuilder.useAdditionalUserMap(new FileReader(additionalUserMapPFTConversionTable));
                }
                if ((pftLut = lutBuilder.create()).getComment() != null) {
                    lcProperties.put("pft_table_comment", pftLut.getComment());
                }
                lcProperties.put("pft_table", pftTableEntry);
            }
            catch (IOException | Lccs2PftLutException e) {
                throw new OperatorException("Could not read specified PFT table.", (Throwable)e);
            }
            if (userPFTConversionTable == null && additionalUserMapPFTConversionTable == null) {
                lcProperties.put("pft_table", "LC-CCI conform PFT conversion table used.");
            }
        } else {
            lcProperties.put("pft_table", "No PFT computed.");
        }
    }

    public static Dimension convertToDimension(String tileSizeString) {
        if (tileSizeString == null || !tileSizeString.contains(":") || tileSizeString.split(":").length != 2) {
            String msg = String.format("Not able to convert missing or invalid value (%s)", tileSizeString);
            throw new IllegalStateException(msg);
        }
        String[] tileSizes = tileSizeString.split(":");
        return new Dimension(Integer.parseInt(tileSizes[1]), Integer.parseInt(tileSizes[0]));
    }

    public static String format(Dimension tileSize) {
        return String.format("%d:%d", tileSize.width, tileSize.height);
    }
}

