/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;

public class BooleanConverter
implements Converter<Boolean> {
    @Override
    public Class<Boolean> getValueType() {
        return Boolean.class;
    }

    @Override
    public Boolean parse(String text) throws ConversionException {
        if (text.isEmpty()) {
            return null;
        }
        if (text.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (text.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (text.equalsIgnoreCase("0")) {
            return Boolean.FALSE;
        }
        try {
            return Double.parseDouble(text) != 0.0 ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (NumberFormatException e) {
            return Boolean.FALSE;
        }
    }

    @Override
    public String format(Boolean value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

