/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassConverter
implements Converter<Class> {
    private static final String ARRAY_SUFFIX = "[]";
    private static final Map<String, Class<?>> primitiveTypes = new HashMap();
    private final List<String> packageQualifiers = new ArrayList<String>();
    private final ClassLoader[] classLoaders;

    public ClassConverter() {
        this(Thread.currentThread().getContextClassLoader());
    }

    private ClassConverter(ClassLoader classLoader) {
        this.addPackageQualifier("");
        this.addPackageQualifier("java.lang.");
        this.addPackageQualifier("java.util.");
        this.classLoaders = new ClassLoader[]{this.getClass().getClassLoader(), classLoader};
    }

    @Override
    public Class<Class> getValueType() {
        return Class.class;
    }

    @Override
    public Class<?> parse(String text) throws ConversionException {
        if (text.isEmpty()) {
            return null;
        }
        Class<?> aClass = primitiveTypes.get(text);
        if (aClass != null) {
            return aClass;
        }
        Class<?> type = null;
        for (String defaultPackageQualifier : this.packageQualifiers) {
            if (text.endsWith(ARRAY_SUFFIX)) {
                String typeString = defaultPackageQualifier + text.subSequence(0, text.length() - ARRAY_SUFFIX.length());
                String arrayTypeString = "[L" + typeString + ";";
                type = this.loadClass(arrayTypeString);
            } else {
                type = this.loadClass(defaultPackageQualifier + text);
            }
            if (type == null) continue;
            break;
        }
        if (type == null) {
            throw new ConversionException(text);
        }
        return type;
    }

    private Class<?> loadClass(String typeString) {
        try {
            return Class.forName(typeString);
        }
        catch (ClassNotFoundException cnfe) {
            for (ClassLoader loader : this.classLoaders) {
                try {
                    return loader.loadClass(typeString);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            return null;
        }
    }

    @Override
    public String format(Class javaType) {
        if (javaType == null) {
            return "";
        }
        String name = javaType.getName();
        for (int i = 1; i < this.packageQualifiers.size(); ++i) {
            String defaultPackageQualifier = this.packageQualifiers.get(i);
            if (name.startsWith("[L")) {
                name = name.substring(2, name.length() - 1) + ARRAY_SUFFIX;
            }
            if (!name.startsWith(defaultPackageQualifier)) continue;
            return name.substring(defaultPackageQualifier.length());
        }
        return name;
    }

    protected void addPackageQualifier(String qualifier) {
        this.packageQualifiers.add(qualifier);
    }

    static {
        primitiveTypes.put("char", Character.TYPE);
        primitiveTypes.put("boolean", Boolean.TYPE);
        primitiveTypes.put("byte", Byte.TYPE);
        primitiveTypes.put("short", Short.TYPE);
        primitiveTypes.put("int", Integer.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("float", Float.TYPE);
        primitiveTypes.put("double", Double.TYPE);
        primitiveTypes.put("void", Void.TYPE);
    }
}

