/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.dom;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import com.bc.ceres.binding.DefaultPropertyDescriptorFactory;
import com.bc.ceres.binding.DefaultPropertySetDescriptor;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.binding.dom.DomConverterRegistry;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.core.Assert;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class DefaultDomConverter
implements DomConverter {
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private final Class<?> valueType;
    private PropertySetDescriptor propertySetDescriptor;
    private PropertyDescriptorFactory propertyDescriptorFactory;

    public DefaultDomConverter(Class<?> valueType) {
        this(valueType, new DefaultPropertyDescriptorFactory());
    }

    public DefaultDomConverter(Class<?> valueType, PropertyDescriptorFactory propertyDescriptorFactory) {
        this(valueType, propertyDescriptorFactory, null);
    }

    public DefaultDomConverter(Class<?> valueType, PropertyDescriptorFactory propertyDescriptorFactory, PropertySetDescriptor propertySetDescriptor) {
        Assert.notNull(valueType, (String)"valueType");
        Assert.notNull((Object)propertyDescriptorFactory, (String)"propertyDescriptorFactory");
        this.valueType = valueType;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
        this.propertySetDescriptor = propertySetDescriptor;
    }

    @Override
    public Class<?> getValueType() {
        return this.valueType;
    }

    public PropertyDescriptorFactory getPropertyDescriptorFactory() {
        return this.propertyDescriptorFactory;
    }

    public PropertySetDescriptor getPropertySetDescriptor() {
        if (this.propertySetDescriptor == null) {
            this.propertySetDescriptor = DefaultPropertySetDescriptor.createFromClass(this.valueType, this.propertyDescriptorFactory);
        }
        return this.propertySetDescriptor;
    }

    @Override
    public void convertValueToDom(Object value, DomElement parentElement) throws ConversionException {
        PropertySet propertySet = this.getPropertySet(value);
        for (Property property : propertySet.getProperties()) {
            this.convertPropertyToDom(property, parentElement);
        }
    }

    private void convertPropertyToDom(Property property, DomElement parentElement) throws ConversionException {
        ChildConverter childConverter;
        PropertyDescriptor descriptor = property.getDescriptor();
        if (descriptor.isTransient() || descriptor.isDeprecated()) {
            return;
        }
        Object value = property.getValue();
        if (value == null) {
            return;
        }
        DomElement childElement = parentElement.createChild(DefaultDomConverter.getNameOrAlias(property));
        Class<?> type = property.getDescriptor().getType();
        Class<?> actualType = value.getClass();
        if (this.isExplicitClassNameRequired(type, value)) {
            childElement.setAttribute(CLASS_ATTRIBUTE_NAME, actualType.getName());
        }
        if ((childConverter = this.findChildConverter(descriptor, actualType)) == null) {
            throw new ConversionException(String.format("Don't know how to convert property '%s'", childElement.getName()));
        }
        childConverter.convertValueToDom(value, childElement);
    }

    private static String getNameOrAlias(Property property) {
        String alias = property.getDescriptor().getAlias();
        if (alias != null && !alias.isEmpty()) {
            return alias;
        }
        return property.getDescriptor().getName();
    }

    @Override
    public Object convertDomToValue(DomElement parentElement, Object value) throws ConversionException, ValidationException {
        PropertySet propertySet;
        if (value == null) {
            value = this.createValueInstance(parentElement, this.getValueType());
            propertySet = this.getPropertySet(value);
            propertySet.setDefaultValues();
        } else {
            propertySet = this.getPropertySet(value);
        }
        this.convertDomToPropertySet(parentElement, propertySet);
        return value;
    }

    private void convertDomToPropertySet(DomElement parentElement, PropertySet propertySet) throws ConversionException, ValidationException {
        for (DomElement childElement : (DomElement[])parentElement.getChildren()) {
            this.convertDomChildToPropertySet(childElement, propertySet);
        }
    }

    private void convertDomChildToPropertySet(DomElement child, PropertySet propertySet) throws ConversionException, ValidationException {
        String childName = child.getName();
        Property property = propertySet.getProperty(childName);
        if (property == null) {
            throw new ConversionException(String.format("Unknown element '%s'", childName));
        }
        if (property.getDescriptor().isTransient()) {
            return;
        }
        this.convertDomChildToProperty(child, property);
    }

    private void convertDomChildToProperty(DomElement childElement, Property property) throws ConversionException, ValidationException {
        Object currentValue;
        Class<?> actualType;
        PropertyDescriptor descriptor = property.getDescriptor();
        ChildConverter childConverter = this.findChildConverter(descriptor, actualType = this.getActualType(childElement, (currentValue = property.getValue()) != null ? currentValue.getClass() : null, false));
        if (childConverter == null) {
            throw new ConversionException(String.format("Don't know how to convert element '%s'", childElement.getName()));
        }
        Object value = childConverter.convertDomToValue(childElement, currentValue);
        property.setValue(value);
    }

    private Object createValueInstance(DomElement parentElement, Class<?> defaultType) throws ConversionException {
        Class<?> itemType = this.getActualType(parentElement, defaultType, true);
        return this.createValueInstance(itemType);
    }

    private Class<?> getActualType(DomElement parentElement, Class<?> defaultType, boolean failIfNotFound) throws ConversionException {
        Class<?> actualType;
        String className = parentElement.getAttribute(CLASS_ATTRIBUTE_NAME);
        if (className != null) {
            try {
                actualType = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                if (failIfNotFound) {
                    throw new ConversionException(e);
                }
                actualType = defaultType;
            }
        } else {
            actualType = defaultType;
        }
        return actualType;
    }

    protected Object createValueInstance(Class<?> type) {
        Object childValue;
        if (type == Map.class) {
            return new LinkedHashMap();
        }
        if (type == SortedMap.class) {
            return new TreeMap();
        }
        try {
            childValue = type.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Failed to create instance of %s (default constructor missing?).", type.getName()), t);
        }
        return childValue;
    }

    protected PropertySet getPropertySet(Object value) {
        PropertySet propertySet = value instanceof PropertySet ? (PropertySet)value : (value instanceof Map ? PropertyContainer.createMapBacked((Map<String, Object>)((Map)value), this.getPropertySetDescriptor()) : (value.getClass().equals(this.getValueType()) ? PropertyContainer.createObjectBacked(value, this.getPropertySetDescriptor()) : PropertyContainer.createObjectBacked(value, this.getPropertyDescriptorFactory())));
        return propertySet;
    }

    protected DomConverter createChildDomConverter(Class<?> valueType, PropertyDescriptorFactory propertyDescriptorFactory, PropertySetDescriptor propertySetDescriptor) {
        return new DefaultDomConverter(valueType, propertyDescriptorFactory, propertySetDescriptor);
    }

    protected DomConverter findChildDomConverter(PropertyDescriptor descriptor) {
        return null;
    }

    private ChildConverter findChildConverter(PropertyDescriptor descriptor, Class<?> actualType) {
        Converter<?> converter;
        DomConverter domConverter = this.findChildDomConverter(descriptor);
        if (domConverter != null) {
            return new ComplexChildConverter(domConverter);
        }
        domConverter = descriptor.getDomConverter();
        if (domConverter != null) {
            return new ComplexChildConverter(domConverter);
        }
        PropertySetDescriptor psd = descriptor.getPropertySetDescriptor();
        if (psd != null) {
            return new ComplexChildConverter(this.createChildDomConverter(descriptor.getType(), this.getPropertyDescriptorFactory(), psd));
        }
        if (descriptor.getType().isArray()) {
            Class<?> itemType;
            String itemName;
            PropertyDescriptor itemDescriptor;
            ChildConverter itemChildConverter;
            boolean hasItemAlias;
            boolean bl = hasItemAlias = descriptor.getItemAlias() != null && !descriptor.getItemAlias().isEmpty();
            if (hasItemAlias && (itemChildConverter = this.findChildConverter(itemDescriptor = new PropertyDescriptor(itemName = descriptor.getItemAlias(), itemType = descriptor.getType().getComponentType()), actualType != null ? actualType.getComponentType() : null)) != null) {
                return new ArrayToDomConverter(itemName, itemType, itemChildConverter);
            }
        }
        if ((converter = descriptor.getConverter()) != null) {
            return new SingleValueChildConverter(converter);
        }
        ChildConverter globalChildConverter = DefaultDomConverter.findGlobalChildConverter(descriptor.getType());
        if (globalChildConverter != null) {
            return globalChildConverter;
        }
        if (actualType != null) {
            ChildConverter childConverter;
            if (!actualType.equals(descriptor.getType()) && (childConverter = DefaultDomConverter.findGlobalChildConverter(actualType)) != null) {
                return childConverter;
            }
            return this.createChildConverter(actualType);
        }
        if (this.isInstantiable(descriptor.getType())) {
            return this.createChildConverter(descriptor.getType());
        }
        return null;
    }

    private boolean isInstantiable(Class<?> type) {
        return !type.isInterface() && !Modifier.isAbstract(type.getModifiers()) && !type.isEnum() && !type.isArray() && Modifier.isPublic(type.getModifiers());
    }

    private boolean isExplicitClassNameRequired(Class<?> type, Object value) {
        return type.isInstance(value) && type != value.getClass() && this.isInstantiable(value.getClass());
    }

    private ChildConverter createChildConverter(Class<?> actualType) {
        PropertySetDescriptor actualTypePsd = DefaultPropertySetDescriptor.createFromClass(actualType, this.getPropertyDescriptorFactory());
        return new ComplexChildConverter(this.createChildDomConverter(actualType, this.getPropertyDescriptorFactory(), actualTypePsd));
    }

    private static ChildConverter findGlobalChildConverter(Class<?> type) {
        Converter<?> converter = ConverterRegistry.getInstance().getConverter(type);
        if (converter != null) {
            return new SingleValueChildConverter(converter);
        }
        DomConverter domConverter = DomConverterRegistry.getInstance().getConverter(type);
        if (domConverter != null) {
            return new ComplexChildConverter(domConverter);
        }
        return null;
    }

    private static class ArrayToDomConverter
    implements ChildConverter {
        private final String itemName;
        private final Class<?> itemType;
        final ChildConverter itemConverter;

        private ArrayToDomConverter(String itemName, Class<?> itemType, ChildConverter itemConverter) {
            this.itemName = itemName;
            this.itemType = itemType;
            this.itemConverter = itemConverter;
        }

        @Override
        public void convertValueToDom(Object value, DomElement childElement) throws ConversionException {
            int arrayLength = Array.getLength(value);
            for (int i = 0; i < arrayLength; ++i) {
                Object item = Array.get(value, i);
                DomElement itemDomElement = childElement.createChild(this.itemName);
                this.itemConverter.convertValueToDom(item, itemDomElement);
            }
        }

        @Override
        public Object convertDomToValue(DomElement childElement, Object value) throws ConversionException, ValidationException {
            DomElement[] itemElements = (DomElement[])childElement.getChildren(this.itemName);
            if (value == null || itemElements.length != Array.getLength(value)) {
                value = Array.newInstance(this.itemType, itemElements.length);
            } else {
                if (value.getClass().getComponentType() == null) {
                    throw new ConversionException(String.format("Incompatible value type: array of type '%s' expected", this.itemType.getName()));
                }
                if (!this.itemType.isAssignableFrom(value.getClass().getComponentType())) {
                    throw new ConversionException(String.format("Incompatible array item type: expected '%s', got '%s'", this.itemType.getName(), value.getClass().getComponentType()));
                }
            }
            for (int i = 0; i < itemElements.length; ++i) {
                Object item = this.itemConverter.convertDomToValue(itemElements[i], null);
                Array.set(value, i, item);
            }
            return value;
        }
    }

    private static class ComplexChildConverter
    implements ChildConverter {
        final DomConverter domConverter;

        private ComplexChildConverter(DomConverter domConverter) {
            this.domConverter = domConverter;
        }

        @Override
        public void convertValueToDom(Object value, DomElement childElement) throws ConversionException {
            this.domConverter.convertValueToDom(value, childElement);
        }

        @Override
        public Object convertDomToValue(DomElement childElement, Object value) throws ConversionException, ValidationException {
            return this.domConverter.convertDomToValue(childElement, value);
        }
    }

    private static class SingleValueChildConverter
    implements ChildConverter {
        final Converter converter;

        private SingleValueChildConverter(Converter converter) {
            this.converter = converter;
        }

        @Override
        public void convertValueToDom(Object value, DomElement childElement) throws ConversionException {
            String text = this.converter.format(value);
            if (text != null && !text.isEmpty()) {
                childElement.setValue(text);
            }
        }

        @Override
        public Object convertDomToValue(DomElement childElement, Object value) throws ConversionException {
            String text = childElement.getValue();
            if (text != null) {
                return this.converter.parse(text);
            }
            return null;
        }
    }

    private static interface ChildConverter {
        public void convertValueToDom(Object var1, DomElement var2) throws ConversionException;

        public Object convertDomToValue(DomElement var1, Object var2) throws ConversionException, ValidationException;
    }
}

