/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import com.bc.ceres.core.Assert;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.esa.snap.binning.MosaickingGrid;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.TemporalBinRenderer;
import org.esa.snap.binning.TemporalBinSource;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.support.CrsGrid;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class Reprojector {
    private final PlanetaryGrid planetaryGrid;
    private final TemporalBinRenderer temporalBinRenderer;
    private final Rectangle rasterRegion;
    private int yGlobalUltimate;

    public static void reproject(PlanetaryGrid planetaryGrid, TemporalBinSource temporalBinSource, TemporalBinRenderer temporalBinRenderer) throws Exception {
        Reprojector reprojector = new Reprojector(planetaryGrid, temporalBinRenderer);
        int partCount = temporalBinSource.open();
        reprojector.begin();
        for (int i = 0; i < partCount; ++i) {
            Iterator<? extends TemporalBin> part = temporalBinSource.getPart(i);
            reprojector.processPart(part);
            temporalBinSource.partProcessed(i, part);
        }
        reprojector.end();
        temporalBinSource.close();
    }

    Reprojector(PlanetaryGrid planetaryGrid, TemporalBinRenderer temporalBinRenderer) {
        Assert.notNull((Object)planetaryGrid, (String)"planetaryGrid");
        Assert.notNull((Object)temporalBinRenderer, (String)"binRenderer");
        this.planetaryGrid = planetaryGrid;
        this.temporalBinRenderer = temporalBinRenderer;
        this.rasterRegion = temporalBinRenderer.getRasterRegion();
    }

    public static Rectangle computeRasterSubRegion(PlanetaryGrid planetaryGrid, Geometry roiGeometry) {
        int gridHeight = planetaryGrid.getNumRows();
        int gridWidth = Reprojector.determineGridWidth(planetaryGrid);
        Rectangle outputRegion = new Rectangle(gridWidth, gridHeight);
        if (roiGeometry != null) {
            if (planetaryGrid instanceof CrsGrid) {
                Coordinate[] coordinates = Reprojector.getBoundsCoordinates(roiGeometry);
                int gxmin = gridWidth;
                int gxmax = 0;
                int gymin = gridHeight;
                int gymax = 0;
                for (Coordinate coordinate : coordinates) {
                    int row;
                    long bin = planetaryGrid.getBinIndex(coordinate.y, coordinate.x);
                    int col = (int)(bin - planetaryGrid.getFirstBinIndex(row = planetaryGrid.getRowIndex(bin)));
                    if (col < gxmin) {
                        gxmin = col;
                    }
                    if (col > gxmax) {
                        gxmax = col;
                    }
                    if (row < gymin) {
                        gymin = row;
                    }
                    if (row <= gymax) continue;
                    gymax = row;
                }
                int x = gxmin;
                int y = gymin;
                int width = gxmax - gxmin + 1;
                int height = gymax - gymin + 1;
                Rectangle unclippedOutputRegion = new Rectangle(x, y, width, height);
                outputRegion = unclippedOutputRegion.intersection(outputRegion);
            } else {
                double pixelSize = Reprojector.getRasterPixelSize(planetaryGrid);
                Coordinate[] coordinates = Reprojector.getBoundsCoordinates(roiGeometry);
                double gxmin = Double.POSITIVE_INFINITY;
                double gxmax = Double.NEGATIVE_INFINITY;
                double gymin = Double.POSITIVE_INFINITY;
                double gymax = Double.NEGATIVE_INFINITY;
                for (Coordinate coordinate : coordinates) {
                    gxmin = Math.min(gxmin, coordinate.x);
                    gxmax = Math.max(gxmax, coordinate.x);
                    gymin = Math.min(gymin, coordinate.y);
                    gymax = Math.max(gymax, coordinate.y);
                }
                int x = (int)Math.floor((180.0 + gxmin) / pixelSize);
                int y = (int)Math.floor((90.0 - gymax) / pixelSize);
                int width = (int)Math.ceil((gxmax - gxmin) / pixelSize);
                int height = (int)Math.ceil((gymax - gymin) / pixelSize);
                Rectangle unclippedOutputRegion = new Rectangle(x, y, width, height);
                outputRegion = unclippedOutputRegion.intersection(outputRegion);
            }
        }
        return outputRegion;
    }

    private static int determineGridWidth(PlanetaryGrid planetaryGrid) {
        int gridWidth = 0;
        for (int row = 0; row < planetaryGrid.getNumRows(); ++row) {
            int width = planetaryGrid.getNumCols(row);
            if (width <= gridWidth) continue;
            gridWidth = width;
        }
        return gridWidth;
    }

    private static Coordinate[] getBoundsCoordinates(Geometry roiGeometry) {
        GeneralPath shape = new GeneralPath();
        shape.moveTo((float)roiGeometry.getCoordinates()[0].x, (float)roiGeometry.getCoordinates()[0].y);
        for (int i = 1; i < roiGeometry.getNumPoints(); ++i) {
            shape.lineTo((float)roiGeometry.getCoordinates()[i].x, (float)roiGeometry.getCoordinates()[i].y);
        }
        roiGeometry = JTS.toGeometry((Shape)shape.getBounds2D(), (GeometryFactory)new GeometryFactory());
        return roiGeometry.getCoordinates();
    }

    public static double getRasterPixelSize(PlanetaryGrid planetaryGrid) {
        return 180.0 / (double)planetaryGrid.getNumRows();
    }

    void begin() throws Exception {
        this.yGlobalUltimate = this.rasterRegion.y - 1;
        this.temporalBinRenderer.begin();
    }

    void end() throws Exception {
        int x1 = this.rasterRegion.x;
        int x2 = x1 + this.rasterRegion.width - 1;
        int y1 = this.rasterRegion.y;
        int y2 = y1 + this.rasterRegion.height - 1;
        this.processRowsWithoutBins(x1, x2, this.yGlobalUltimate + 1, y2);
        this.temporalBinRenderer.end();
    }

    void processPart(Iterator<? extends TemporalBin> temporalBins) throws Exception {
        int x1 = this.rasterRegion.x;
        int x2 = x1 + this.rasterRegion.width - 1;
        int y1 = this.rasterRegion.y;
        int y2 = y1 + this.rasterRegion.height - 1;
        ArrayList<TemporalBin> binRow = new ArrayList<TemporalBin>();
        int yUltimate = -1;
        while (temporalBins.hasNext()) {
            TemporalBin temporalBin = temporalBins.next();
            long temporalBinIndex = temporalBin.getIndex();
            int y = this.planetaryGrid.getRowIndex(temporalBinIndex);
            if (y != yUltimate) {
                if (yUltimate >= y1 && yUltimate <= y2) {
                    this.processRowsWithoutBins(x1, x2, this.yGlobalUltimate + 1, yUltimate - 1);
                    this.processRowWithBins(yUltimate, binRow);
                    this.yGlobalUltimate = yUltimate;
                }
                binRow.clear();
                yUltimate = y;
            }
            binRow.add(temporalBin);
        }
        if (yUltimate >= y1 && yUltimate <= y2) {
            this.processRowsWithoutBins(x1, x2, this.yGlobalUltimate + 1, yUltimate - 1);
            this.processRowWithBins(yUltimate, binRow);
            this.yGlobalUltimate = yUltimate;
        }
    }

    private void processRowWithBins(int y, List<TemporalBin> binRow) throws Exception {
        Assert.argument((!binRow.isEmpty() ? 1 : 0) != 0, (String)"!binRow.isEmpty()");
        int x1 = this.rasterRegion.x;
        int x2 = this.rasterRegion.x + this.rasterRegion.width - 1;
        int y1 = this.rasterRegion.y;
        long[] binIndicesForBinningLine = this.planetaryGrid instanceof MosaickingGrid ? this.binIndicesForMosaickingLine(y, x1, x2) : this.binIndicesForBinningLine(y, x1, x2);
        WritableVector resultVector = null;
        long lastBinIndex = -1L;
        TemporalBin temporalBin = null;
        int rowIndex = -1;
        int x = x1;
        int xb = 0;
        while (x <= x2) {
            long wantedBinIndex = binIndicesForBinningLine[xb];
            if (lastBinIndex != wantedBinIndex) {
                temporalBin = null;
                for (int i = rowIndex + 1; i < binRow.size(); ++i) {
                    long binIndex = binRow.get(i).getIndex();
                    if (binIndex == wantedBinIndex) {
                        temporalBin = binRow.get(i);
                        resultVector = temporalBin.toVector();
                        lastBinIndex = wantedBinIndex;
                        rowIndex = i;
                        break;
                    }
                    if (binIndex > wantedBinIndex) break;
                }
            }
            if (temporalBin != null) {
                this.temporalBinRenderer.renderBin(x - x1, y - y1, temporalBin, resultVector);
            } else {
                this.temporalBinRenderer.renderMissingBin(x - x1, y - y1);
            }
            ++x;
            ++xb;
        }
    }

    private void processRowsWithoutBins(int x1, int x2, int yStart, int yEnd) throws Exception {
        for (int y = yStart; y <= yEnd; ++y) {
            this.processRowWithoutBins(x1, x2, y - this.rasterRegion.y);
        }
    }

    private void processRowWithoutBins(int x1, int x2, int y) throws Exception {
        for (int x = x1; x <= x2; ++x) {
            this.temporalBinRenderer.renderMissingBin(x - x1, y);
        }
    }

    private long[] binIndicesForBinningLine(int y, int x1, int x2) {
        int gridWidth = this.planetaryGrid.getNumRows() * 2;
        int gridHeight = this.planetaryGrid.getNumRows();
        long[] binIndices = new long[x2 - x1 + 1];
        double lat = 90.0 - ((double)y + 0.5) * 180.0 / (double)gridHeight;
        int x = x1;
        int i = 0;
        while (x <= x2) {
            double lon = -180.0 + ((double)x + 0.5) * 360.0 / (double)gridWidth;
            binIndices[i] = this.planetaryGrid.getBinIndex(lat, lon);
            ++x;
            ++i;
        }
        return binIndices;
    }

    private long[] binIndicesForMosaickingLine(int y, int x1, int x2) {
        long gridWidth = this.planetaryGrid.getNumCols(0);
        long[] binIndices = new long[x2 - x1 + 1];
        int x = x1;
        int i = 0;
        while (x <= x2) {
            binIndices[i] = (long)x + (long)y * gridWidth;
            ++x;
            ++i;
        }
        return binIndices;
    }
}

