/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.aggregators;

import org.esa.snap.binning.AbstractAggregator;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.AggregatorDescriptor;
import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.support.GrowableVector;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.util.StringUtils;

public class AggregatorAverageOutlierAware
extends AbstractAggregator {
    private String vectorName;
    private final int varIndex;
    private final double deviationFactor;

    public AggregatorAverageOutlierAware(VariableContext varCtx, String varName, double deviationFactor) {
        this(varCtx, varName, varName, deviationFactor);
    }

    private AggregatorAverageOutlierAware(VariableContext varCtx, String varName, String targetName, double deviationFactor) {
        super("AVG_OUTLIER", new String[0], AggregatorAverageOutlierAware.createFeatureNames(varName, "mean", "sigma", "counts"), AggregatorAverageOutlierAware.createFeatureNames(targetName, "mean", "sigma", "counts"));
        this.vectorName = "values." + varName;
        this.deviationFactor = deviationFactor;
        this.varIndex = varCtx.getVariableIndex(varName);
    }

    @Override
    public boolean requiresGrowableSpatialData() {
        return true;
    }

    @Override
    public void initSpatial(BinContext ctx, WritableVector vector) {
    }

    @Override
    public void aggregateSpatial(BinContext ctx, Observation observationVector, WritableVector spatialVector) {
        float value = observationVector.get(this.varIndex);
        if (!Float.isNaN(value)) {
            ((GrowableVector)spatialVector).add(value);
        }
    }

    @Override
    public void completeSpatial(BinContext ctx, int numSpatialObs, WritableVector spatialVector) {
    }

    @Override
    public void initTemporal(BinContext ctx, WritableVector vector) {
        vector.set(0, 0.0f);
        vector.set(1, 0.0f);
        vector.set(2, 0.0f);
        this.vectorName = ctx.ensureUnique(this.vectorName);
        ctx.put(this.vectorName, new GrowableVector(256));
    }

    @Override
    public void aggregateTemporal(BinContext ctx, Vector spatialVector, int numSpatialObs, WritableVector temporalVector) {
        GrowableVector measurementsVec = (GrowableVector)ctx.get(this.vectorName);
        for (int i = 0; i < spatialVector.size(); ++i) {
            measurementsVec.add(spatialVector.get(i));
        }
    }

    @Override
    public void completeTemporal(BinContext ctx, int numTemporalObs, WritableVector temporalVector) {
        GrowableVector measurementsVec = (GrowableVector)ctx.get(this.vectorName);
        int count = measurementsVec.size();
        if (count == 0) {
            temporalVector.set(0, Float.NaN);
            temporalVector.set(1, Float.NaN);
            temporalVector.set(2, 0.0f);
        }
        double[] statistics = this.calculateStatistics(measurementsVec);
        if (count > 2) {
            double maxDelta = statistics[1] * this.deviationFactor;
            GrowableVector consolidatedMeasurements = new GrowableVector(count);
            for (int i = 0; i < count; ++i) {
                float measurement = measurementsVec.get(i);
                if (!(Math.abs((double)measurement - statistics[0]) <= maxDelta)) continue;
                consolidatedMeasurements.add(measurement);
            }
            if (count > consolidatedMeasurements.size()) {
                statistics = this.calculateStatistics(consolidatedMeasurements);
                count = consolidatedMeasurements.size();
            }
        }
        temporalVector.set(0, (float)statistics[0]);
        temporalVector.set(1, (float)statistics[1]);
        temporalVector.set(2, count);
    }

    @Override
    public void computeOutput(Vector temporalVector, WritableVector outputVector) {
        outputVector.set(0, temporalVector.get(0));
        outputVector.set(1, temporalVector.get(1));
        outputVector.set(2, temporalVector.get(2));
    }

    private double[] calculateStatistics(GrowableVector measurementsVec) {
        int count = measurementsVec.size();
        double sum = 0.0;
        for (int i = 0; i < count; ++i) {
            sum += (double)measurementsVec.get(i);
        }
        double mean = sum / (double)count;
        sum = 0.0;
        for (int i = 0; i < count; ++i) {
            double delta = (double)measurementsVec.get(i) - mean;
            sum += delta * delta;
        }
        double stdDev = Math.sqrt(sum / (double)count);
        return new double[]{mean, stdDev};
    }

    public static class Descriptor
    implements AggregatorDescriptor {
        public static final String NAME = "AVG_OUTLIER";

        @Override
        public Aggregator createAggregator(VariableContext varCtx, AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            if (StringUtils.isNullOrEmpty((String)config.targetName)) {
                return new AggregatorAverageOutlierAware(varCtx, config.varName, config.deviationFactor);
            }
            return new AggregatorAverageOutlierAware(varCtx, config.varName, config.targetName, config.deviationFactor);
        }

        @Override
        public String[] getSourceVarNames(AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            return new String[]{config.varName};
        }

        @Override
        public String[] getTargetVarNames(AggregatorConfig aggregatorConfig) {
            Config config = (Config)aggregatorConfig;
            if (StringUtils.isNullOrEmpty((String)config.targetName)) {
                return AbstractAggregator.createFeatureNames(config.varName, "mean", "sigma", "counts");
            }
            return AbstractAggregator.createFeatureNames(config.targetName, "mean", "sigma", "counts");
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public AggregatorConfig createConfig() {
            return new Config();
        }
    }

    public static class Config
    extends AggregatorConfig {
        @Parameter(label="Source band name", notEmpty=true, notNull=true, description="The source band used for aggregation.")
        String varName;
        @Parameter(label="Target band name prefix (optional)", description="The name prefix for the resulting bands. If empty, the source band name is used.")
        String targetName;
        @Parameter(label="Deviation Factor", defaultValue="1.0", description="Factor multiplied with the standard deviation that defines the distance to the mean that serves as threshold for outlier detection.")
        Double deviationFactor;

        public Config() {
            this(null, null, 1.0);
        }

        public Config(String varName, String targetName, double deviationFactor) {
            super("AVG_OUTLIER");
            this.varName = varName;
            this.targetName = targetName;
            this.deviationFactor = deviationFactor;
        }
    }
}

