/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.CellProcessorConfig;
import org.esa.snap.binning.CompositingType;
import org.esa.snap.binning.DataPeriod;
import org.esa.snap.binning.ProductCustomizerConfig;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.SpatialBinner;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.TemporalBinSource;
import org.esa.snap.binning.TemporalBinner;
import org.esa.snap.binning.cellprocessor.CellProcessorChain;
import org.esa.snap.binning.operator.AggregatorConfigDomConverter;
import org.esa.snap.binning.operator.BinWriter;
import org.esa.snap.binning.operator.BinningConfig;
import org.esa.snap.binning.operator.BinningProductFilter;
import org.esa.snap.binning.operator.CellProcessorConfigDomConverter;
import org.esa.snap.binning.operator.GeneralSpatialBinCollector;
import org.esa.snap.binning.operator.GeoCodingProductFilter;
import org.esa.snap.binning.operator.ProductCustomizerConfigDomConverter;
import org.esa.snap.binning.operator.RegionProductFilter;
import org.esa.snap.binning.operator.SeaDASLevel3BinWriter;
import org.esa.snap.binning.operator.SpatialBinCollection;
import org.esa.snap.binning.operator.SpatialDataDaySourceProductFilter;
import org.esa.snap.binning.operator.SpatialProductBinner;
import org.esa.snap.binning.operator.TemporalBinList;
import org.esa.snap.binning.operator.TimeRangeProductFilter;
import org.esa.snap.binning.operator.VariableConfig;
import org.esa.snap.binning.operator.formatter.Formatter;
import org.esa.snap.binning.operator.formatter.FormatterConfig;
import org.esa.snap.binning.operator.formatter.FormatterFactory;
import org.esa.snap.binning.operator.metadata.GlobalMetadata;
import org.esa.snap.binning.operator.metadata.MetadataAggregator;
import org.esa.snap.binning.operator.metadata.MetadataAggregatorFactory;
import org.esa.snap.binning.support.SpatialDataPeriod;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.SubsetOp;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphContext;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.RectangleExtender;
import org.esa.snap.core.util.StopWatch;
import org.esa.snap.core.util.converters.JtsGeometryConverter;
import org.esa.snap.core.util.io.WildcardMatcher;
import org.geotools.geometry.jts.JTS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

@OperatorMetadata(alias="Binning", category="Raster/Geometric", version="1.0", authors="Norman Fomferra, Marco Z\u00fchlke, Thomas Storm", copyright="(c) 2014 by Brockmann Consult GmbH", description="Performs spatial and temporal aggregation of pixel values into cells ('bins') of a planetary grid", autoWriteDisabled=true)
public class BinningOp
extends Operator {
    public static final String DATE_INPUT_PATTERN = "yyyy-MM-dd";
    public static final String DATETIME_INPUT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATETIME_OUTPUT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    @SourceProducts(description="The source products to be binned. Must be all of the same structure.\nIf not given, the parameter 'sourceProductPaths' must be provided.")
    Product[] sourceProducts;
    @TargetProduct
    Product targetProduct;
    @Parameter(description="A comma-separated list of file paths specifying the source products.\nEach path may contain the wildcards '**' (matches recursively any directory),\n'*' (matches any character sequence in path names) and\n'?' (matches any single character).")
    String[] sourceProductPaths;
    @Parameter(description="The common product format of all source products.\nThis parameter is optional and may be used in conjunction with\nparameter 'sourceProductPaths'. Can be set if multiple reader are \navailable for the source files and a specific one shall be used.Try \"NetCDF-CF\", \"GeoTIFF\", \"BEAM-DIMAP\", or \"ENVISAT\", etc.")
    private String sourceProductFormat;
    @Parameter(description="A comma-separated list of file paths specifying the source graphs.\nEach path may contain the wildcards '**' (matches recursively any directory),\n'*' (matches any character sequence in path names) and\n'?' (matches any single character).")
    String[] sourceGraphPaths;
    @Parameter(converter=JtsGeometryConverter.class, description="The considered geographical region as a geometry in well-known text format (WKT).\nIf not given, the geographical region will be computed according to the extents of the input products.")
    Geometry region;
    @Parameter(pattern="\\d{4}-\\d{2}-\\d{2}(\\s\\d{2}:\\d{2}:\\d{2})?", description="The UTC start date of the binning period.\nThe format is either 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'.\n If only the date part is given, the time 00:00:00 is assumed.")
    private String startDateTime;
    @Parameter(description="Duration of the binning period in days.")
    private Double periodDuration;
    @Parameter(description="The method that is used to decide which source pixels are used with respect to their observation time.\n'NONE': ignore pixel observation time, use all source pixels.\n'TIME_RANGE': use all pixels that have been acquired in the given binning period.\n'SPATIOTEMPORAL_DATA_DAY': use a sensor-dependent, spatial \"data-day\" definition with the goal\nto minimise the time between the first and last observation contributing to the same bin in the given binning period.\nThe decision, whether a source pixel contributes to a bin or not, is a function of the pixel's observation longitude and time.\nRequires the parameter 'minDataHour'.", defaultValue="NONE")
    private TimeFilterMethod timeFilterMethod;
    @Parameter(interval="[0,24]", description="A sensor-dependent constant given in hours of a day (0 to 24)\nat which a sensor has a minimum number of observations at the date line (the 180 degree meridian).\nOnly used if parameter 'dataDayMode' is set to 'SPATIOTEMPORAL_DATADAY'.")
    private Double minDataHour;
    @Parameter(description="Number of rows in the (global) planetary grid. Must be even.", defaultValue="2160")
    private int numRows;
    @Parameter(description="The square of the number of pixels used for super-sampling an input pixel into multiple sub-pixels", defaultValue="1")
    private Integer superSampling;
    @Parameter(description="Skips binning of sub-pixel if distance on earth to the center of the main-pixel is larger as this value. A value <=0 disables this check", defaultValue="-1")
    private Integer maxDistanceOnEarth;
    @Parameter(description="The band maths expression used to filter input pixels")
    private String maskExpr;
    @Parameter(alias="variables", itemAlias="variable", description="List of variables. A variable will generate a virtual band\nin each source data product, so that it can be used as input for the binning.")
    private VariableConfig[] variableConfigs;
    @Parameter(alias="aggregators", domConverter=AggregatorConfigDomConverter.class, description="List of aggregators. Aggregators generate the bands in the binned output products")
    private AggregatorConfig[] aggregatorConfigs;
    @Parameter(alias="postProcessor", domConverter=CellProcessorConfigDomConverter.class)
    private CellProcessorConfig postProcessorConfig;
    @Parameter(valueSet={"Product", "RGB", "Grey"}, defaultValue="Product")
    private String outputType;
    @Parameter
    private String outputFile;
    @Parameter(defaultValue="BEAM-DIMAP")
    private String outputFormat;
    @Parameter(alias="outputBands", itemAlias="band", description="Configures the target bands. Not needed if output type 'Product' is chosen.")
    private BandConfiguration[] bandConfigurations;
    @Parameter(alias="productCustomizer", domConverter=ProductCustomizerConfigDomConverter.class)
    private ProductCustomizerConfig productCustomizerConfig;
    @Parameter(description="If true, a SeaDAS-style, binned data NetCDF file is written in addition to the\ntarget product. The output file name will be <target>-bins.nc", defaultValue="false")
    private boolean outputBinnedData;
    @Parameter(description="If true, a mapped product is written. Set this to 'false' if only a binned product is needed.", alias="outputMappedProduct", defaultValue="true")
    private boolean outputTargetProduct;
    @Parameter(description="The name of the file containing metadata key-value pairs (google \"Java Properties file format\").", defaultValue="./metadata.properties")
    File metadataPropertiesFile;
    @Parameter(description="The name of the directory containing metadata templates (google \"Apache Velocity VTL format\").", defaultValue=".")
    File metadataTemplateDir;
    @Parameter(description="The type of metadata aggregation to be used. Possible values are:\n'NAME': aggregate the name of each input product\n'FIRST_HISTORY': aggregates all input product names and the processing history of the first product\n'ALL_HISTORIES': aggregates all input product names and processing histories", defaultValue="NAME")
    private String metadataAggregatorName;
    private transient BinningContext binningContext;
    private transient FormatterConfig formatterConfig;
    private transient int numProductsAggregated;
    private transient ProductData.UTC minDateUtc;
    private transient ProductData.UTC maxDateUtc;
    private transient GlobalMetadata globalMetadata;
    private transient BinWriter binWriter;
    private transient Area regionArea;
    private transient MetadataAggregator metadataAggregator;
    @Parameter(defaultValue="org.esa.snap.binning.support.SEAGrid")
    private String planetaryGridClass;
    private transient CompositingType compositingType;
    private final Map<Product, List<Band>> addedVariableBands = new HashMap<Product, List<Band>>();
    private Product writtenProduct;

    public Geometry getRegion() {
        return this.region;
    }

    public void setRegion(Geometry region) {
        this.region = region;
    }

    public String getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(String startDateTime) {
        this.startDateTime = startDateTime;
    }

    public Double getPeriodDuration() {
        return this.periodDuration;
    }

    public void setPeriodDuration(Double periodDuration) {
        this.periodDuration = periodDuration;
    }

    public TimeFilterMethod getTimeFilterMethod() {
        return this.timeFilterMethod;
    }

    public void setTimeFilterMethod(TimeFilterMethod timeFilterMethod) {
        this.timeFilterMethod = timeFilterMethod;
    }

    public Double getMinDataHour() {
        return this.minDataHour;
    }

    public void setMinDataHour(Double minDataHour) {
        this.minDataHour = minDataHour;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public Integer getSuperSampling() {
        return this.superSampling;
    }

    public void setSuperSampling(Integer superSampling) {
        this.superSampling = superSampling;
    }

    public String getMaskExpr() {
        return this.maskExpr;
    }

    public void setMaskExpr(String maskExpr) {
        this.maskExpr = maskExpr;
    }

    public String getSourceProductFormat() {
        return this.sourceProductFormat;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public VariableConfig[] getVariableConfigs() {
        return this.variableConfigs;
    }

    public void setVariableConfigs(VariableConfig ... variableConfigs) {
        this.variableConfigs = variableConfigs;
    }

    public AggregatorConfig[] getAggregatorConfigs() {
        return this.aggregatorConfigs;
    }

    public void setAggregatorConfigs(AggregatorConfig ... aggregatorConfigs) {
        this.aggregatorConfigs = aggregatorConfigs;
    }

    public CellProcessorConfig getPostProcessorConfig() {
        return this.postProcessorConfig;
    }

    public void setPostProcessorConfig(CellProcessorConfig postProcessorConfig) {
        this.postProcessorConfig = postProcessorConfig;
    }

    SortedMap<String, String> getMetadataProperties() {
        if (this.globalMetadata == null) {
            return null;
        }
        return this.globalMetadata.asSortedMap();
    }

    public void setBinWriter(BinWriter binWriter) {
        this.binWriter = binWriter;
    }

    public void setOutputTargetProduct(boolean outputTargetProduct) {
        this.outputTargetProduct = outputTargetProduct;
    }

    public void setMetadataAggregatorName(String metadataAggregatorName) {
        this.metadataAggregatorName = metadataAggregatorName;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setPlanetaryGridClass(String planetaryGridClass) {
        this.planetaryGridClass = planetaryGridClass;
    }

    public void setCompositingType(CompositingType compositingType) {
        this.compositingType = compositingType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws OperatorException {
        StopWatch stopWatch;
        block16: {
            this.formatterConfig = new FormatterConfig();
            this.formatterConfig.setBandConfigurations(this.bandConfigurations);
            this.formatterConfig.setOutputFile(this.outputFile);
            this.formatterConfig.setOutputFormat(this.outputFormat);
            this.formatterConfig.setOutputType(this.outputType);
            this.formatterConfig.setProductCustomizerConfig(this.productCustomizerConfig);
            this.validateInput();
            ProductData.UTC startDateUtc = null;
            ProductData.UTC endDateUtc = null;
            if (this.startDateTime != null) {
                startDateUtc = BinningOp.parseStartDateUtc(this.startDateTime);
                double startMJD = startDateUtc.getMJD();
                double endMJD = startMJD + this.periodDuration;
                endDateUtc = new ProductData.UTC(endMJD);
            }
            stopWatch = new StopWatch();
            stopWatch.start();
            if (this.region == null) {
                this.regionArea = new Area();
            }
            BinningConfig binningConfig = this.createConfig();
            this.binningContext = binningConfig.createBinningContext(this.region, startDateUtc, this.periodDuration);
            BinningProductFilter productFilter = BinningOp.createSourceProductFilter(this.binningContext.getDataPeriod(), startDateUtc, endDateUtc, this.region);
            this.metadataAggregator = MetadataAggregatorFactory.create(this.metadataAggregatorName);
            this.numProductsAggregated = 0;
            try {
                SpatialBinCollection spatialBinMap = this.doSpatialBinning(productFilter);
                if (this.numProductsAggregated == 0) {
                    throw new OperatorException("No valid input products found during spatial binning. Quitting operator");
                }
                if (!spatialBinMap.isEmpty()) {
                    if (this.region == null && this.regionArea != null) {
                        this.region = JTS.toGeometry((Shape)this.regionArea, (GeometryFactory)new GeometryFactory());
                    }
                    try (TemporalBinList temporalBins = this.doTemporalBinning(spatialBinMap);){
                        if (this.startDateTime != null) {
                            this.writeOutput(temporalBins, startDateUtc, endDateUtc);
                        } else {
                            this.writeOutput(temporalBins, this.minDateUtc, this.maxDateUtc);
                        }
                        break block16;
                    }
                }
                this.getLogger().warning("No bins have been generated, no output has been written");
            }
            catch (OperatorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new OperatorException((Throwable)e);
            }
            finally {
                this.cleanSourceProducts();
            }
        }
        stopWatch.stopAndTrace(String.format("Total time for binning %d product(s)", this.numProductsAggregated));
        this.globalMetadata.processMetadataTemplates(this.metadataTemplateDir, this, this.targetProduct, this.getLogger());
    }

    public void dispose() {
        if (this.writtenProduct != null) {
            this.writtenProduct.dispose();
        }
        super.dispose();
    }

    public BinningConfig createConfig() {
        BinningConfig config = new BinningConfig();
        config.setNumRows(this.numRows);
        config.setSuperSampling(this.superSampling);
        config.setMaxDistanceOnEarth(this.maxDistanceOnEarth);
        config.setMaskExpr(this.maskExpr);
        config.setVariableConfigs(this.variableConfigs);
        config.setAggregatorConfigs(this.aggregatorConfigs);
        config.setPostProcessorConfig(this.postProcessorConfig);
        config.setMinDataHour(this.minDataHour);
        config.setMetadataAggregatorName(this.metadataAggregatorName);
        config.setStartDateTime(this.startDateTime);
        config.setPeriodDuration(this.periodDuration);
        config.setTimeFilterMethod(this.timeFilterMethod);
        config.setOutputFile(this.outputFile);
        config.setRegion(this.region);
        if (this.planetaryGridClass != null) {
            config.setPlanetaryGrid(this.planetaryGridClass);
        }
        if (this.compositingType != null) {
            config.setCompositingType(this.compositingType);
        }
        return config;
    }

    private void validateInput() {
        if (this.timeFilterMethod == null) {
            this.timeFilterMethod = TimeFilterMethod.NONE;
        }
        if (this.timeFilterMethod != TimeFilterMethod.NONE && (this.startDateTime == null || this.periodDuration == null)) {
            throw new OperatorException("Using a time filer requires the parameters 'startDateTime' and 'periodDuration'");
        }
        if (this.periodDuration != null && this.periodDuration < 0.0) {
            throw new OperatorException("The parameter 'periodDuration' must be a positive value");
        }
        if (this.timeFilterMethod == TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY && this.minDataHour == null) {
            throw new OperatorException("If SPATIOTEMPORAL_DATADAY filtering is used the parameters 'minDataHour' must be given");
        }
        if (!(this.sourceProducts != null || this.sourceProductPaths != null && this.sourceProductPaths.length != 0 || this.sourceGraphPaths != null && this.sourceGraphPaths.length != 0)) {
            String msg = "Either source products must be given or parameter 'sourceProductPaths' or parameter 'sourceGraphPaths' must be specified";
            throw new OperatorException(msg);
        }
        if (this.numRows < 2 || this.numRows % 2 != 0) {
            throw new OperatorException("Operator parameter 'numRows' must be greater than 0 and even");
        }
        if (this.aggregatorConfigs == null || this.aggregatorConfigs.length == 0) {
            throw new OperatorException("No aggregators have been defined");
        }
        if (this.formatterConfig.getOutputFile() == null) {
            throw new OperatorException("Missing operator parameter 'formatterConfig.outputFile'");
        }
        if (this.metadataTemplateDir == null || "".equals(this.metadataTemplateDir.getPath())) {
            this.metadataTemplateDir = new File(".");
        }
        if (!this.metadataTemplateDir.exists()) {
            String msgPattern = "Directory given by 'metadataTemplateDir' does not exist: %s";
            throw new OperatorException(String.format(msgPattern, this.metadataTemplateDir));
        }
        if (!this.outputBinnedData && !this.outputTargetProduct) {
            throw new OperatorException("At least one of the parameters 'outputBinnedData' and 'outputTargetProduct' must be 'true'");
        }
    }

    static BinningProductFilter createSourceProductFilter(DataPeriod dataPeriod, ProductData.UTC startTime, ProductData.UTC endTime, Geometry region) {
        BinningProductFilter productFilter = new GeoCodingProductFilter();
        productFilter = new MultiSizeProductFilter(productFilter);
        if (dataPeriod != null) {
            productFilter = dataPeriod instanceof SpatialDataPeriod ? new SpatialDataDaySourceProductFilter(productFilter, dataPeriod) : new TimeRangeProductFilter(productFilter, startTime, endTime);
        }
        if (region != null) {
            productFilter = new RegionProductFilter(productFilter, region);
        }
        return productFilter;
    }

    private void cleanSourceProducts() {
        for (Map.Entry<Product, List<Band>> entry : this.addedVariableBands.entrySet()) {
            for (Band band : entry.getValue()) {
                entry.getKey().removeBand(band);
            }
        }
    }

    private void initMetadataProperties() {
        this.globalMetadata = GlobalMetadata.create(this);
        this.globalMetadata.load(this.metadataPropertiesFile, this.getLogger());
    }

    private static Product copyProduct(Product writtenProduct) {
        Product targetProduct = new Product(writtenProduct.getName(), writtenProduct.getProductType(), writtenProduct.getSceneRasterWidth(), writtenProduct.getSceneRasterHeight());
        targetProduct.setStartTime(writtenProduct.getStartTime());
        targetProduct.setEndTime(writtenProduct.getEndTime());
        ProductUtils.copyMetadata((Product)writtenProduct, (Product)targetProduct);
        ProductUtils.copyGeoCoding((Product)writtenProduct, (Product)targetProduct);
        ProductUtils.copyTiePointGrids((Product)writtenProduct, (Product)targetProduct);
        ProductUtils.copyMasks((Product)writtenProduct, (Product)targetProduct);
        ProductUtils.copyVectorData((Product)writtenProduct, (Product)targetProduct);
        for (Band band : writtenProduct.getBands()) {
            ProductUtils.copyBand((String)band.getName(), (Product)writtenProduct, (Product)targetProduct, (boolean)true);
        }
        return targetProduct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpatialBinCollection doSpatialBinning(BinningProductFilter productFilter) throws IOException {
        String msgPattern;
        TreeSet fileSet;
        GeneralSpatialBinCollector spatialBinCollector = new GeneralSpatialBinCollector(this.binningContext.getPlanetaryGrid().getNumBins());
        SpatialBinner spatialBinner = new SpatialBinner(this.binningContext, spatialBinCollector);
        if (this.sourceProducts != null) {
            for (Product sourceProduct : this.sourceProducts) {
                if (productFilter.accept(sourceProduct)) {
                    this.processSource(sourceProduct, spatialBinner);
                    continue;
                }
                this.getLogger().warning("Filtered out product '" + sourceProduct.getFileLocation() + "'");
                this.getLogger().warning("              reason: " + productFilter.getReason());
            }
        }
        if (this.sourceProductPaths != null && this.sourceProductPaths.length > 0) {
            this.getLogger().info("expanding sourceProductPaths wildcards.");
            fileSet = new TreeSet();
            for (String filePattern : this.sourceProductPaths) {
                WildcardMatcher.glob((String)filePattern, fileSet);
            }
            if (fileSet.isEmpty()) {
                this.getLogger().warning("The given source file patterns did not match any files");
            } else {
                this.getLogger().info("found " + fileSet.size() + " product files.");
                for (File file : fileSet) {
                    this.getLogger().info(file.getCanonicalPath());
                }
            }
            for (File file : fileSet) {
                Product sourceProduct = null;
                try {
                    sourceProduct = this.sourceProductFormat != null ? ProductIO.readProduct((File)file, (String[])new String[]{this.sourceProductFormat}) : ProductIO.readProduct((File)file);
                }
                catch (Exception e) {
                    msgPattern = "Failed to read file '%s'. %s: %s";
                    this.getLogger().severe(String.format(msgPattern, file, e.getClass().getSimpleName(), e.getMessage()));
                }
                if (sourceProduct != null) {
                    try {
                        if (productFilter.accept(sourceProduct)) {
                            this.processSource(sourceProduct, spatialBinner);
                            continue;
                        }
                        this.getLogger().warning("Filtered out product '" + sourceProduct.getFileLocation() + "'");
                        this.getLogger().warning("              reason: " + productFilter.getReason());
                        continue;
                    }
                    finally {
                        sourceProduct.dispose();
                        continue;
                    }
                }
                String msgPattern2 = "Failed to read file '%s' (not a data product or reader missing)";
                this.getLogger().severe(String.format(msgPattern2, file));
            }
        }
        if (this.sourceGraphPaths != null && this.sourceGraphPaths.length > 0) {
            this.getLogger().info("expanding sourceGraphPaths wildcards.");
            fileSet = new TreeSet();
            for (String filePattern : this.sourceGraphPaths) {
                WildcardMatcher.glob((String)filePattern, fileSet);
            }
            if (fileSet.isEmpty()) {
                this.getLogger().warning("The given graph file patterns did not match any files");
            } else {
                this.getLogger().info("found " + fileSet.size() + " graph files.");
                for (File file : fileSet) {
                    this.getLogger().info(file.getCanonicalPath());
                }
            }
            for (File file : fileSet) {
                Product sourceProduct = null;
                GraphContext graphContext = null;
                try {
                    Graph graph = GraphIO.read((Reader)new FileReader(file));
                    graphContext = new GraphContext(graph);
                    Product[] outputProducts = graphContext.getOutputProducts();
                    if (outputProducts.length != 1) {
                        this.getLogger().warning("Filtered out graph '" + file + "'");
                        this.getLogger().warning("            reason: graph has more than one 'outputNode'.");
                    } else {
                        sourceProduct = outputProducts[0];
                    }
                }
                catch (Exception e) {
                    String msgPattern3 = "Failed to execute graph from file '%s'. %s: %s";
                    this.getLogger().severe(String.format(msgPattern3, file, e.getClass().getSimpleName(), e.getMessage()));
                }
                if (sourceProduct != null) {
                    try {
                        if (productFilter.accept(sourceProduct)) {
                            this.processSource(sourceProduct, spatialBinner);
                        }
                        this.getLogger().warning("Filtered out result of graph '" + file + "'");
                        this.getLogger().warning("                      reason: " + productFilter.getReason());
                    }
                    finally {
                        sourceProduct.dispose();
                    }
                } else {
                    msgPattern = "Failed to use graph '%s'";
                    this.getLogger().severe(String.format(msgPattern, file));
                }
                if (graphContext == null) continue;
                graphContext.dispose();
            }
        }
        spatialBinCollector.consumingCompleted();
        return spatialBinCollector.getSpatialBinCollection();
    }

    private void processSource(Product sourceProduct, SpatialBinner spatialBinner) throws IOException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.updateDateRangeUtc(sourceProduct);
        this.metadataAggregator.aggregateMetadata(sourceProduct);
        String productName = sourceProduct.getName();
        this.getLogger().info(String.format("Spatial binning of product '%s'...", productName));
        if (this.region != null) {
            SubsetOp subsetOp = new SubsetOp();
            subsetOp.setSourceProduct(sourceProduct);
            Rectangle subsetRectangle = SubsetOp.computePixelRegion((Product)sourceProduct, (Geometry)this.region, (int)0);
            if (sourceProduct.getSceneGeoCoding() instanceof BasicPixelGeoCoding && (subsetRectangle.height <= 2 || subsetRectangle.width <= 2)) {
                int sceneRasterWidth = sourceProduct.getSceneRasterWidth();
                int sceneRasterHeight = sourceProduct.getSceneRasterHeight();
                Rectangle clippingRect = new Rectangle(sceneRasterWidth, sceneRasterHeight);
                RectangleExtender rectangleExtender = new RectangleExtender(clippingRect, 1, 1);
                Rectangle extendedSubsetRectangle = rectangleExtender.extend(subsetRectangle);
                if (extendedSubsetRectangle.height <= 2 || extendedSubsetRectangle.width <= 2) {
                    this.getLogger().warning(String.format("Skipped binning of product '%s', raster dimensions are to small [%d,%d]", productName, sceneRasterWidth, sceneRasterHeight));
                    return;
                }
                subsetOp.setRegion(extendedSubsetRectangle);
            } else {
                subsetOp.setGeoRegion(this.region);
            }
            sourceProduct = subsetOp.getTargetProduct();
        }
        long numObs = SpatialProductBinner.processProduct(sourceProduct, spatialBinner, this.addedVariableBands, ProgressMonitor.NULL);
        stopWatch.stop();
        this.getLogger().fine(String.format("Product start time: '%s'", sourceProduct.getStartTime()));
        this.getLogger().fine(String.format("Product end time:   '%s'", sourceProduct.getEndTime()));
        this.getLogger().info(String.format("Spatial binning of product '%s' done, %d observations seen, took %s", productName, numObs, stopWatch));
        if (this.region == null && this.regionArea != null) {
            for (GeneralPath generalPath : ProductUtils.createGeoBoundaryPaths((Product)sourceProduct)) {
                try {
                    Area area = new Area(generalPath);
                    this.regionArea.add(area);
                }
                catch (Throwable e) {
                    this.getLogger().log(Level.SEVERE, String.format("Failed to handle product boundary: %s", e.getMessage()), e);
                }
            }
        }
        ++this.numProductsAggregated;
    }

    private TemporalBinList doTemporalBinning(SpatialBinCollection spatialBinMap) throws IOException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        long numberOfBins = spatialBinMap.size();
        TemporalBinner temporalBinner = new TemporalBinner(this.binningContext);
        CellProcessorChain cellChain = new CellProcessorChain(this.binningContext);
        TemporalBinList temporalBins = new TemporalBinList((int)numberOfBins);
        Iterable<List<SpatialBin>> spatialBinListCollection = spatialBinMap.getBinCollection();
        int binCounter = 0;
        int percentCounter = 0;
        long hundredthOfNumBins = numberOfBins / 100L;
        for (List<SpatialBin> spatialBinList : spatialBinListCollection) {
            binCounter += spatialBinList.size();
            SpatialBin spatialBin = spatialBinList.get(0);
            long spatialBinIndex = spatialBin.getIndex();
            TemporalBin temporalBin = temporalBinner.processSpatialBins(spatialBinIndex, spatialBinList);
            temporalBin = temporalBinner.computeOutput(spatialBinIndex, temporalBin);
            temporalBin = cellChain.process(temporalBin);
            temporalBins.add(temporalBin);
            if ((long)binCounter < hundredthOfNumBins) continue;
            binCounter = 0;
            this.getLogger().info(String.format("Finished %d%% of temporal bins", ++percentCounter));
        }
        stopWatch.stop();
        this.getLogger().info(String.format("Temporal binning of %d bins done, took %s", numberOfBins, stopWatch));
        return temporalBins;
    }

    private void writeOutput(List<TemporalBin> temporalBins, ProductData.UTC startTime, ProductData.UTC stopTime) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.initMetadataProperties();
        if (this.outputBinnedData) {
            try {
                this.writeNetCDFBinFile(temporalBins, startTime, stopTime);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, String.format("Failed to write binned data: %s", e.getMessage()), e);
            }
        }
        if (this.outputTargetProduct) {
            this.getLogger().info(String.format("Writing mapped product '%s'...", this.formatterConfig.getOutputFile()));
            MetadataElement processingGraphMetadata = this.getProcessingGraphMetadata();
            Formatter defaultFormatter = FormatterFactory.get("default");
            defaultFormatter.format(this.binningContext.getPlanetaryGrid(), this.getTemporalBinSource(temporalBins), this.binningContext.getBinManager().getResultFeatureNames(), this.formatterConfig, this.region, startTime, stopTime, processingGraphMetadata);
            stopWatch.stop();
            String msgPattern = "Writing mapped product '%s' done, took %s";
            this.getLogger().info(String.format(msgPattern, this.formatterConfig.getOutputFile(), stopWatch));
            if (this.outputType.equalsIgnoreCase("Product")) {
                File writtenProductFile = new File(this.outputFile);
                String format = FormatterFactory.getOutputFormat(this.formatterConfig, writtenProductFile);
                this.writtenProduct = ProductIO.readProduct((File)writtenProductFile, (String[])new String[]{format});
                this.targetProduct = BinningOp.copyProduct(this.writtenProduct);
            } else {
                this.targetProduct = new Product("Dummy", "t", 10, 10);
            }
        } else {
            this.targetProduct = new Product("Dummy", "t", 10, 10);
        }
    }

    private MetadataElement getProcessingGraphMetadata() {
        MetadataElement processingGraphMetadata = this.globalMetadata.asMetadataElement();
        MetadataElement node_0 = processingGraphMetadata.getElement("node.0");
        node_0.addElement(this.metadataAggregator.getMetadata());
        return processingGraphMetadata;
    }

    private TemporalBinSource getTemporalBinSource(List<TemporalBin> temporalBins) throws IOException {
        return new SimpleTemporalBinSource(temporalBins);
    }

    private void writeNetCDFBinFile(List<TemporalBin> temporalBins, ProductData.UTC startTime, ProductData.UTC stopTime) throws IOException {
        this.initBinWriter(startTime, stopTime);
        this.getLogger().info(String.format("Writing binned data to '%s'...", this.binWriter.getTargetFilePath()));
        this.binWriter.write(this.globalMetadata.asSortedMap(), temporalBins);
        this.getLogger().info(String.format("Writing binned data to '%s' done.", this.binWriter.getTargetFilePath()));
    }

    private void initBinWriter(ProductData.UTC startTime, ProductData.UTC stopTime) {
        if (this.binWriter == null) {
            this.binWriter = new SeaDASLevel3BinWriter(this.region, startTime, stopTime);
        }
        this.binWriter.setBinningContext(this.binningContext);
        this.binWriter.setTargetFileTemplatePath(this.formatterConfig.getOutputFile());
        this.binWriter.setLogger(this.getLogger());
    }

    private void updateDateRangeUtc(Product sourceProduct) {
        if (this.startDateTime == null) {
            if (sourceProduct.getStartTime() != null && (this.minDateUtc == null || sourceProduct.getStartTime().getAsDate().before(this.minDateUtc.getAsDate()))) {
                this.minDateUtc = sourceProduct.getStartTime();
            }
            if (sourceProduct.getEndTime() != null && (this.maxDateUtc == null || sourceProduct.getEndTime().getAsDate().after(this.maxDateUtc.getAsDate()))) {
                this.maxDateUtc = sourceProduct.getStartTime();
            }
        }
    }

    static ProductData.UTC parseStartDateUtc(String date) {
        try {
            if (date.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
                return ProductData.UTC.parse((String)date, (String)DATETIME_INPUT_PATTERN);
            }
            return ProductData.UTC.parse((String)date, (String)DATE_INPUT_PATTERN);
        }
        catch (ParseException e) {
            throw new OperatorException(String.format("Error while parsing start date parameter '%s': %s", date, e.getMessage()));
        }
    }

    private static class MultiSizeProductFilter
    extends BinningProductFilter {
        public MultiSizeProductFilter(BinningProductFilter parent) {
            this.setParent(parent);
        }

        @Override
        protected boolean acceptForBinning(Product product) {
            if (!product.isMultiSize()) {
                return true;
            }
            this.setReason("Product with rasters of different size are not supported yet.");
            return false;
        }
    }

    public static class BandConfiguration {
        public String index;
        public String name;
        public String minValue;
        public String maxValue;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BandConfiguration that = (BandConfiguration)o;
            if (this.index != null ? !this.index.equals(that.index) : that.index != null) {
                return false;
            }
            if (this.maxValue != null ? !this.maxValue.equals(that.maxValue) : that.maxValue != null) {
                return false;
            }
            if (this.minValue != null ? !this.minValue.equals(that.minValue) : that.minValue != null) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.index != null ? this.index.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.minValue != null ? this.minValue.hashCode() : 0);
            result = 31 * result + (this.maxValue != null ? this.maxValue.hashCode() : 0);
            return result;
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(BinningOp.class);
        }
    }

    public static class SimpleTemporalBinSource
    implements TemporalBinSource {
        private final List<TemporalBin> temporalBins;

        public SimpleTemporalBinSource(List<TemporalBin> temporalBins) {
            this.temporalBins = temporalBins;
        }

        @Override
        public int open() throws IOException {
            return 1;
        }

        @Override
        public Iterator<? extends TemporalBin> getPart(int index) throws IOException {
            return this.temporalBins.iterator();
        }

        @Override
        public void partProcessed(int index, Iterator<? extends TemporalBin> part) throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static enum TimeFilterMethod {
        NONE,
        TIME_RANGE,
        SPATIOTEMPORAL_DATA_DAY;

    }
}

