/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import java.io.IOException;
import java.util.List;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.operator.FileBackedSpatialBinCollector;
import org.esa.snap.binning.operator.MapBackedSpatialBinCollector;
import org.esa.snap.binning.operator.SpatialBinCollection;
import org.esa.snap.binning.operator.SpatialBinCollector;

public class GeneralSpatialBinCollector
implements SpatialBinCollector {
    private final FileBackedSpatialBinCollector fileBinCollector;
    private MapBackedSpatialBinCollector mapBinCollector;
    private boolean consumingCompleted;

    public GeneralSpatialBinCollector(long numBins) throws IOException {
        this.fileBinCollector = new FileBackedSpatialBinCollector(numBins);
        this.mapBinCollector = new MapBackedSpatialBinCollector();
        this.consumingCompleted = false;
    }

    @Override
    public void consumeSpatialBins(BinningContext ctx, List<SpatialBin> spatialBins) throws Exception {
        if (this.consumingCompleted) {
            throw new IllegalStateException("Consuming of bins has already been completed.");
        }
        this.mapBinCollector.consumeSpatialBins(ctx, spatialBins);
        if (this.mapBinCollector.getSpatialBinCollection().size() > 12000L) {
            this.moveBinsToFile(ctx);
        }
    }

    @Override
    public SpatialBinCollection getSpatialBinCollection() throws IOException {
        return this.fileBinCollector.getSpatialBinCollection();
    }

    @Override
    public void consumingCompleted() throws IOException {
        this.consumingCompleted = true;
        this.moveBinsToFile(null);
        this.mapBinCollector.consumingCompleted();
        this.mapBinCollector.close();
        this.mapBinCollector = null;
        this.fileBinCollector.consumingCompleted();
    }

    @Override
    public void close() throws IOException {
        if (this.fileBinCollector != null) {
            this.fileBinCollector.close();
        }
        if (this.mapBinCollector != null) {
            this.mapBinCollector.close();
        }
    }

    private void moveBinsToFile(BinningContext ignored) throws IOException {
        SpatialBinCollection spatialBinCollection = this.mapBinCollector.getSpatialBinCollection();
        Iterable<List<SpatialBin>> values = spatialBinCollection.getBinCollection();
        for (List<SpatialBin> value : values) {
            try {
                this.fileBinCollector.consumeSpatialBins(ignored, value);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        this.mapBinCollector.clearMap();
    }
}

