/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.formatter;

import java.awt.Rectangle;
import java.io.File;
import org.esa.snap.binning.MosaickingGrid;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.ProductCustomizer;
import org.esa.snap.binning.Reprojector;
import org.esa.snap.binning.TemporalBinRenderer;
import org.esa.snap.binning.TemporalBinSource;
import org.esa.snap.binning.operator.ImageTemporalBinRenderer;
import org.esa.snap.binning.operator.ProductTemporalBinRenderer;
import org.esa.snap.binning.operator.formatter.Formatter;
import org.esa.snap.binning.operator.formatter.FormatterConfig;
import org.esa.snap.binning.operator.formatter.FormatterFactory;
import org.esa.snap.binning.support.CrsGrid;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;

class DefaultFormatter
implements Formatter {
    DefaultFormatter() {
    }

    @Override
    public void format(PlanetaryGrid planetaryGrid, TemporalBinSource temporalBinSource, String[] featureNames, FormatterConfig formatterConfig, Geometry roiGeometry, ProductData.UTC startTime, ProductData.UTC stopTime, MetadataElement ... metadataElements) throws Exception {
        TemporalBinRenderer temporalBinRenderer;
        if (featureNames.length == 0) {
            throw new IllegalArgumentException("Illegal binning context: featureNames.length == 0");
        }
        File outputFile = new File(formatterConfig.getOutputFile());
        String outputType = formatterConfig.getOutputType();
        String outputFormat = FormatterFactory.getOutputFormat(formatterConfig, outputFile);
        Rectangle outputRegion = DefaultFormatter.getOutputRegion(planetaryGrid, roiGeometry);
        ProductCustomizer productCustomizer = formatterConfig.getProductCustomizer();
        if (outputType.equalsIgnoreCase("Product")) {
            GeoCoding geoCoding;
            if (planetaryGrid instanceof MosaickingGrid) {
                MosaickingGrid mosaickingGrid = (MosaickingGrid)planetaryGrid;
                geoCoding = mosaickingGrid.getGeoCoding(outputRegion);
            } else {
                double pixelSize = Reprojector.getRasterPixelSize(planetaryGrid);
                geoCoding = ProductTemporalBinRenderer.createMapGeoCoding(outputRegion, pixelSize);
            }
            temporalBinRenderer = new ProductTemporalBinRenderer(featureNames, outputFile, outputFormat, outputRegion, geoCoding, startTime, stopTime, productCustomizer, metadataElements);
        } else {
            temporalBinRenderer = new ImageTemporalBinRenderer(featureNames, outputFile, outputFormat, outputRegion, formatterConfig.getBandConfigurations(), outputType.equalsIgnoreCase("RGB"));
        }
        Reprojector.reproject(planetaryGrid, temporalBinSource, temporalBinRenderer);
    }

    static Rectangle getOutputRegion(PlanetaryGrid planetaryGrid, Geometry roiGeometry) {
        Rectangle outputRegion;
        if (planetaryGrid instanceof CrsGrid) {
            if (roiGeometry == null) {
                outputRegion = new Rectangle(planetaryGrid.getNumCols(0), planetaryGrid.getNumRows());
            } else {
                Geometry imageGeometry;
                CrsGrid crsGrid = (CrsGrid)planetaryGrid;
                if (roiGeometry instanceof LinearRing) {
                    LinearRing linearRing = (LinearRing)roiGeometry;
                    roiGeometry = new GeometryFactory().createPolygon(linearRing);
                }
                outputRegion = (imageGeometry = crsGrid.getImageGeometry(roiGeometry)) == null ? new Rectangle(planetaryGrid.getNumCols(0), planetaryGrid.getNumRows()) : crsGrid.getBounds(imageGeometry);
            }
        } else {
            outputRegion = Reprojector.computeRasterSubRegion(planetaryGrid, roiGeometry);
        }
        return outputRegion;
    }
}

