/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.formatter;

import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import java.io.File;
import java.util.Set;
import org.esa.snap.binning.operator.formatter.Formatter;
import org.esa.snap.binning.operator.formatter.FormatterConfig;
import org.esa.snap.binning.operator.formatter.FormatterPlugin;
import org.esa.snap.core.util.ServiceLoader;
import org.esa.snap.core.util.StringUtils;

public class FormatterFactory {
    private static ServiceRegistry<FormatterPlugin> formatterPlugins = null;

    public static Formatter get(String key) {
        FormatterFactory.ensureServicesLoaded();
        if (StringUtils.isNullOrEmpty((String)key)) {
            key = "default";
        }
        Set services = formatterPlugins.getServices();
        for (FormatterPlugin plugin : services) {
            if (!plugin.getName().equalsIgnoreCase(key)) continue;
            return plugin.create();
        }
        throw new RuntimeException("Unknown formatter key: " + key);
    }

    public static String getOutputFormat(FormatterConfig formatterConfig, File outputFile) {
        String fileName = outputFile.getName();
        int extPos = fileName.lastIndexOf(".");
        String outputFileNameExt = fileName.substring(extPos + 1);
        String outputFormat = formatterConfig.getOutputFormat();
        if (outputFormat == null) {
            String string = outputFileNameExt.equalsIgnoreCase("nc") ? "NetCDF" : (outputFileNameExt.equalsIgnoreCase("dim") ? "BEAM-DIMAP" : (outputFileNameExt.equalsIgnoreCase("tiff") ? "GeoTIFF" : (outputFileNameExt.equalsIgnoreCase("png") ? "PNG" : (outputFormat = outputFileNameExt.equalsIgnoreCase("jpg") ? "JPEG" : null))));
        }
        if (outputFormat == null) {
            throw new IllegalArgumentException("No output format given");
        }
        if (!(outputFormat.startsWith("NetCDF") || outputFormat.equalsIgnoreCase("BEAM-DIMAP") || outputFormat.equalsIgnoreCase("GeoTIFF") || outputFormat.startsWith("GeoTIFF") || outputFormat.equalsIgnoreCase("PNG") || outputFormat.equalsIgnoreCase("JPEG"))) {
            throw new IllegalArgumentException("Unknown output format: " + outputFormat);
        }
        if (outputFormat.equalsIgnoreCase("NetCDF")) {
            outputFormat = "NetCDF-BEAM";
        }
        return outputFormat;
    }

    private static void ensureServicesLoaded() {
        if (formatterPlugins == null) {
            ServiceRegistryManager serviceRegistryManager = ServiceRegistryManager.getInstance();
            formatterPlugins = serviceRegistryManager.getServiceRegistry(FormatterPlugin.class);
            ServiceLoader.loadServices(formatterPlugins);
        }
    }
}

