/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.metadata;

import org.esa.snap.binning.operator.metadata.AbstractMetadataAggregator;
import org.esa.snap.binning.operator.metadata.Utilities;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.StringUtils;

class ProductNameMetaAggregator
extends AbstractMetadataAggregator {
    ProductNameMetaAggregator() {
    }

    @Override
    public MetadataElement getMetadata() {
        return this.inputsMetaElement;
    }

    @Override
    public void aggregateMetadata(Product product) {
        String productName = Utilities.extractProductName(product);
        this.aggregate(productName);
    }

    @Override
    public void aggregateMetadata(MetadataElement processingGraphElement) {
        String productName = Utilities.extractProductName(processingGraphElement);
        if (StringUtils.isNullOrEmpty((String)productName)) {
            productName = "unknown";
        }
        this.aggregate(productName);
    }

    private void aggregate(String productName) {
        MetadataElement productElement = Utilities.createSourceMetaElement(productName, this.aggregatedCount);
        this.inputsMetaElement.addElementAt(productElement, this.aggregatedCount);
        ++this.aggregatedCount;
    }
}

