/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.reader;

import java.io.File;
import org.esa.snap.core.util.io.SnapFileFilter;

public class BinnedFileFilter
extends SnapFileFilter {
    public BinnedFileFilter() {
        super("Binned_data_product", ".nc", "SeaDAS-Level-3-alike NetCDF files containing binned Level-3 data");
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (super.accept(file)) {
            return BinnedFileFilter.isBinnedName(file.getName());
        }
        return false;
    }

    public static boolean isBinnedName(String name) {
        return name != null && (name.startsWith("ESACCI-OC-") && name.contains("L3") || name.contains("-bins")) && name.endsWith(".nc");
    }
}

