/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import org.esa.snap.binning.MosaickingGrid;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.PlainFeatureFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.common.reproject.ReprojectionOp;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.FeatureUtils;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CrsGrid
implements MosaickingGrid {
    private static final int LON_DIM = 0;
    private static final int LAT_DIM = 1;
    private final CoordinateReferenceSystem crs;
    private final int numRows;
    private final int numCols;
    private final double pixelSize;
    private final GeometryFactory geometryFactory;
    private final CrsGeoCoding crsGeoCoding;
    private final double easting;
    private final double northing;

    public CrsGrid(int numRowsGlobal, String crsCode) {
        try {
            this.crs = CRS.decode((String)crsCode, (boolean)true);
            org.opengis.geometry.Envelope envelopeCRS = CRS.getEnvelope((CoordinateReferenceSystem)this.crs);
            System.out.println("envelopeCRS = " + envelopeCRS);
            String units = this.crs.getCoordinateSystem().getAxis(0).getUnit().toString();
            if (!units.equalsIgnoreCase("m") && !units.equalsIgnoreCase("meter")) {
                this.pixelSize = 180.0 / (double)numRowsGlobal;
            } else {
                Ellipsoid ellipsoid = CRS.getEllipsoid((CoordinateReferenceSystem)this.crs);
                double semiMinorAxis = ellipsoid.getSemiMinorAxis();
                double meterSpanGlobal = semiMinorAxis * Math.PI;
                this.pixelSize = meterSpanGlobal / (double)numRowsGlobal;
            }
            System.out.println("pixelSize = " + this.pixelSize + " [" + units + "]");
            this.numCols = (int)(envelopeCRS.getSpan(0) / this.pixelSize);
            this.easting = envelopeCRS.getMinimum(0);
            this.numRows = (int)(envelopeCRS.getSpan(1) / this.pixelSize);
            this.northing = envelopeCRS.getMaximum(1);
            this.crsGeoCoding = new CrsGeoCoding(this.crs, this.numCols, this.numRows, this.easting, this.northing, this.pixelSize, this.pixelSize, 0.0, 0.0);
        }
        catch (FactoryException | TransformException var9) {
            throw new IllegalArgumentException("Can not create crs for:" + crsCode, var9);
        }
        this.geometryFactory = new GeometryFactory();
    }

    @Override
    public long getBinIndex(double lat, double lon) {
        PixelPos pixelPos = this.crsGeoCoding.getPixelPos(new GeoPos(lat, lon), null);
        long x = (long)pixelPos.getX();
        long y = (long)pixelPos.getY();
        return y * (long)this.numCols + x;
    }

    @Override
    public int getRowIndex(long bin) {
        long x = bin % (long)this.numCols;
        return (int)((bin - x) / (long)this.numCols);
    }

    @Override
    public long getNumBins() {
        return (long)this.numCols * (long)this.numRows;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols(int row) {
        return this.numCols;
    }

    @Override
    public long getFirstBinIndex(int row) {
        return (long)row * (long)this.numCols;
    }

    @Override
    public double getCenterLat(int row) {
        GeoPos geoPos = this.crsGeoCoding.getGeoPos(new PixelPos(0.5, (double)row + 0.5), null);
        return geoPos.getLat();
    }

    @Override
    public double[] getCenterLatLon(long bin) {
        int x = (int)(bin % (long)this.numCols);
        int y = (int)((bin - (long)x) / (long)this.numCols);
        GeoPos geoPos = this.crsGeoCoding.getGeoPos(new PixelPos((double)x + 0.5, (double)y + 0.5), null);
        return new double[]{geoPos.getLat(), geoPos.getLon()};
    }

    @Override
    public Product reprojectToGrid(Product sourceProduct) {
        Product gridProduct = new Product("ColocationGrid", "ColocationGrid", this.numCols, this.numRows);
        gridProduct.setSceneGeoCoding((GeoCoding)this.crsGeoCoding);
        ReprojectionOp repro = new ReprojectionOp();
        repro.setParameter("resampling", (Object)"Nearest");
        repro.setParameter("includeTiePointGrids", (Object)false);
        Dimension tileSize = ImageManager.getPreferredTileSize((Product)sourceProduct);
        repro.setParameter("tileSizeX", (Object)tileSize.width);
        repro.setParameter("tileSizeY", (Object)tileSize.height);
        repro.setSourceProduct("collocateWith", gridProduct);
        repro.setSourceProduct("source", sourceProduct);
        Product targetProduct = repro.getTargetProduct();
        targetProduct.setStartTime(sourceProduct.getStartTime());
        targetProduct.setEndTime(sourceProduct.getEndTime());
        return targetProduct;
    }

    public Geometry getImageGeometry(Geometry Geometry2) {
        Product gridProduct = new Product("ColocationGrid", "ColocationGrid", this.numCols, this.numRows);
        gridProduct.setSceneGeoCoding((GeoCoding)this.crsGeoCoding);
        Band rdn = gridProduct.addBand("dummy", 20);
        SimpleFeatureType wktFeatureType = PlainFeatureFactory.createDefaultFeatureType((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ListFeatureCollection featureCollection = new ListFeatureCollection(wktFeatureType);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(wktFeatureType);
        SimpleFeature wktFeature = featureBuilder.buildFeature("ID1");
        wktFeature.setDefaultGeometry((Object)Geometry2);
        featureCollection.add(wktFeature);
        DefaultFeatureCollection productFeatures = FeatureUtils.clipFeatureCollectionToProductBounds((FeatureCollection)featureCollection, (Product)gridProduct, null, (ProgressMonitor)ProgressMonitor.NULL);
        FeatureIterator features = productFeatures.features();
        if (!features.hasNext()) {
            return null;
        }
        SimpleFeature simpleFeature = (SimpleFeature)features.next();
        Geometry clippedGeometry = (Geometry)simpleFeature.getDefaultGeometry();
        try {
            AffineTransform i2mTransform = rdn.getImageToModelTransform();
            i2mTransform.invert();
            GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
            transformer.setMathTransform((MathTransform)new AffineTransform2D(i2mTransform));
            return transformer.transform(clippedGeometry);
        }
        catch (NoninvertibleTransformException | TransformException e) {
            throw new IllegalArgumentException("Could not invert model-to-image transformation.", e);
        }
    }

    public Rectangle getBounds(Geometry pixelGeometry) {
        Envelope envelopeInternal = pixelGeometry.getEnvelopeInternal();
        int minX = (int)Math.floor(envelopeInternal.getMinX());
        int minY = (int)Math.floor(envelopeInternal.getMinY());
        int maxX = (int)Math.ceil(envelopeInternal.getMaxX());
        int maxY = (int)Math.ceil(envelopeInternal.getMaxY());
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public GeoCoding getGeoCoding(Rectangle outputRegion) {
        try {
            return new CrsGeoCoding(this.crs, outputRegion.width, outputRegion.height, this.easting + this.pixelSize * (double)outputRegion.x, this.northing - this.pixelSize * (double)outputRegion.y, this.pixelSize, this.pixelSize);
        }
        catch (FactoryException | TransformException e) {
            throw new IllegalArgumentException("Can not create geocoding for crs.", e);
        }
    }

    @Override
    public Rectangle[] getDataSliceRectangles(Geometry sourceProductGeometry, Dimension tileSize) {
        Geometry imageGeometry = this.getImageGeometry(sourceProductGeometry);
        if (imageGeometry == null) {
            return new Rectangle[0];
        }
        Rectangle productBoundingBox = this.getBounds(imageGeometry);
        Rectangle gridAlignedBoundingBox = MosaickingGrid.alignToTileGrid(productBoundingBox, tileSize);
        int xStart = gridAlignedBoundingBox.x / tileSize.width;
        int yStart = gridAlignedBoundingBox.y / tileSize.height;
        int width = gridAlignedBoundingBox.width / tileSize.width;
        int height = gridAlignedBoundingBox.height / tileSize.height;
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>((int)((long)this.numCols * (long)this.numRows / (long)(tileSize.width * tileSize.height)));
        for (int y = yStart; y < yStart + height; ++y) {
            for (int x = xStart; x < xStart + width; ++x) {
                Rectangle tileRect = new Rectangle(x * tileSize.width, y * tileSize.height, tileSize.width, tileSize.height);
                Geometry tileGeometry = this.getTileGeometry(tileRect);
                Geometry intersection = imageGeometry.intersection(tileGeometry);
                if (intersection.isEmpty() || intersection.getDimension() != 2) continue;
                System.out.println("tileRect = " + tileRect);
                rectangles.add(productBoundingBox.intersection(tileRect));
            }
        }
        System.out.println("rectangles = " + rectangles.size());
        return rectangles.toArray(new Rectangle[0]);
    }

    private Geometry getTileGeometry(Rectangle rect) {
        return this.geometryFactory.toGeometry(new Envelope((double)rect.x, (double)(rect.x + rect.width), (double)rect.y, (double)(rect.y + rect.height)));
    }
}

