/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.core.util.grid.isin.IsinAPI;
import org.esa.snap.core.util.grid.isin.IsinPoint;

public class IsinPlanetaryGrid
implements PlanetaryGrid {
    private static final int NUM_TILES_VERTICAL = 18;
    private static final int NUM_TILES_HORIZONTAL = 36;
    private static final int NUM_ROWS_1KM = 21600;
    private static final int NUM_ROWS_500M = 43200;
    private static final int NUM_ROWS_250M = 86400;
    private final IsinAPI isinAPI;
    private final IsinAPI.Raster raster;

    public IsinPlanetaryGrid(int numRows) {
        if (numRows == 21600) {
            this.isinAPI = new IsinAPI(IsinAPI.Raster.GRID_1_KM);
            this.raster = IsinAPI.Raster.GRID_1_KM;
        } else if (numRows == 43200) {
            this.isinAPI = new IsinAPI(IsinAPI.Raster.GRID_500_M);
            this.raster = IsinAPI.Raster.GRID_500_M;
        } else if (numRows == 86400) {
            this.isinAPI = new IsinAPI(IsinAPI.Raster.GRID_250_M);
            this.raster = IsinAPI.Raster.GRID_250_M;
        } else {
            throw new IllegalArgumentException("Invalid number of rows");
        }
    }

    @Override
    public long getBinIndex(double lat, double lon) {
        IsinPoint isinPoint = this.isinAPI.toTileImageCoordinates(lon, lat);
        return IsinPlanetaryGrid.toBinIndex(isinPoint);
    }

    @Override
    public int getRowIndex(long bin) {
        IsinPoint isinPoint = IsinPlanetaryGrid.toIsinPoint(bin);
        IsinPoint tileDimensions = this.isinAPI.getTileDimensions();
        return isinPoint.getTile_line() * (int)(tileDimensions.getY() + 0.5) + (int)(isinPoint.getY() + 0.5);
    }

    @Override
    public long getNumBins() {
        IsinPoint tileDimensions = this.isinAPI.getTileDimensions();
        return (long)(tileDimensions.getX() + 0.5) * (long)(tileDimensions.getY() + 0.5) * 18L * 36L;
    }

    @Override
    public int getNumRows() {
        IsinPoint tileDimensions = this.isinAPI.getTileDimensions();
        return (int)(tileDimensions.getY() + 0.5) * 18;
    }

    @Override
    public int getNumCols(int row) {
        IsinPoint tileDimensions = this.isinAPI.getTileDimensions();
        return (int)(tileDimensions.getX() + 0.5) * 36;
    }

    @Override
    public long getFirstBinIndex(int row) {
        IsinPoint tileDimensions = this.isinAPI.getTileDimensions();
        int tileHeight = (int)(tileDimensions.getY() + 0.5);
        int tileIdx = row / tileHeight;
        int y = row - tileHeight * tileIdx;
        IsinPoint isinPoint = new IsinPoint(0.0, (double)y, 0, tileIdx);
        return IsinPlanetaryGrid.toBinIndex(isinPoint);
    }

    @Override
    public double getCenterLat(int row) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double[] getCenterLatLon(long bin) {
        throw new RuntimeException("not implemented");
    }

    public IsinAPI.Raster getRaster() {
        return this.raster;
    }

    public static long toBinIndex(IsinPoint point) {
        short x = (short)(point.getX() + 0.5);
        short y = (short)(point.getY() + 0.5);
        int tile_x = point.getTile_col();
        int tile_y = point.getTile_line();
        return 10000000000L * (long)tile_y + 100000000L * (long)tile_x + 10000L * (long)y + (long)x;
    }

    public static IsinPoint toIsinPoint(long binIndex) {
        int tile_y = (int)(binIndex / 10000000000L);
        long partIndex = binIndex - 10000000000L * (long)tile_y;
        int tile_x = (int)(partIndex / 100000000L);
        int y = (int)((partIndex -= 100000000L * (long)tile_x) / 10000L);
        int x = (int)(partIndex - 10000L * (long)y);
        return new IsinPoint((double)x, (double)y, tile_x, tile_y);
    }
}

