/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.jdom2.Element;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.Property;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.ThreddsMetadataContainer;
import thredds.client.catalog.builder.AccessBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;

@Immutable
public class Dataset
extends DatasetNode
implements ThreddsMetadataContainer {
    public static final String Access = "Access";
    public static final String Alias = "Alias";
    public static final String Authority = "Authority";
    public static final String CollectionType = "CollectionType";
    public static final String Contributors = "Contributors";
    public static final String Creators = "Creators";
    public static final String DataFormatType = "DataFormatType";
    public static final String Datasets = "Datasets";
    public static final String DataSize = "DataSize";
    public static final String Dates = "Dates";
    public static final String Documentation = "Documentation";
    public static final String FeatureType = "FeatureType";
    public static final String GeospatialCoverage = "GeospatialCoverage";
    public static final String Harvest = "Harvest";
    public static final String Id = "Id";
    public static final String Keywords = "Keywords";
    public static final String MetadataOther = "MetadataOther";
    public static final String Ncml = "Ncml";
    public static final String Projects = "Projects";
    public static final String Properties = "Properties";
    public static final String Publishers = "Publishers";
    public static final String RestrictAccess = "RestrictAccess";
    public static final String ServiceName = "ServiceName";
    public static final String ThreddsMetadataInheritable = "ThreddsMetadataInheritable";
    public static final String TimeCoverage = "TimeCoverage";
    public static final String VariableGroups = "VariableGroups";
    public static final String VariableMapLinkURI = "VariableMapLinkURI";
    public static final String UrlPath = "UrlPath";
    public static final String UseRemoteCatalogService = "UseRemoteCatalogService";
    public static final String NotAThreddsDataset = "NotAThreddsDataset";
    public static final ImmutableSet<String> listFlds = ImmutableSet.of("Access", "Contributors", "Creators", "Dates", "Documentation", "Keywords", new String[]{"MetadataOther", "Projects", "Properties", "Publishers", "VariableGroups"});

    public Dataset(DatasetNode parent, String name, Map<String, Object> flds, List<AccessBuilder> accessBuilders, List<DatasetBuilder> datasetBuilders) {
        super(parent, name, flds, datasetBuilders);
        if (accessBuilders != null && !accessBuilders.isEmpty()) {
            ArrayList<Access> access = new ArrayList<Access>(accessBuilders.size());
            for (AccessBuilder acc : accessBuilders) {
                access.add(acc.makeAccess(this));
            }
            flds.put(Access, Collections.unmodifiableList(access));
        }
    }

    public static Dataset makeStandalone(String urlPath, String featureType, String dataFormatS, String serviceType) {
        DatasetBuilder builder = new DatasetBuilder(null);
        builder.put(FeatureType, featureType);
        Service service = new Service("anon", "", serviceType, null, null, null, null, null);
        AccessBuilder access = new AccessBuilder(builder, urlPath, service, dataFormatS, 0L);
        builder.addAccess(access);
        return builder.makeDataset(null);
    }

    public List<Access> getAccess() {
        List access;
        ArrayList<Access> result = new ArrayList<Access>();
        String urlPath = this.getUrlPath();
        String serviceDefault = this.getServiceNameDefault();
        String dataFormat = this.getDataFormatName();
        long dataSize = this.getDataSize();
        Catalog cat = this.getParentCatalog();
        if (cat != null) {
            Service s2 = cat.findService(serviceDefault);
            if (urlPath != null && s2 != null) {
                Access a = new Access(this, urlPath, s2, dataFormat, dataSize);
                this.addAllAccess(a, result);
            }
        }
        if ((access = this.getLocalFieldAsList(Access)) != null) {
            for (Access a : access) {
                this.addAllAccess(a, result);
            }
        }
        return result;
    }

    private void addAllAccess(Access a, List<Access> result) {
        if (a.getService().getType() == ServiceType.Compound) {
            for (Service nested : a.getService().getNestedServices()) {
                Access nestedAccess = new Access(this, a.getUrlPath(), nested, a.getDataFormatName(), a.getDataSize());
                this.addAllAccess(nestedAccess, result);
            }
        } else {
            result.add(a);
        }
    }

    public Access getAccess(ServiceType type) {
        for (Access acc : this.getAccess()) {
            if (acc.getService().getType() != type) continue;
            return acc;
        }
        return null;
    }

    public boolean hasAccess() {
        List<Access> access = this.getAccess();
        return !access.isEmpty();
    }

    public Access findAccess(String accessURL) {
        for (Access a : this.getAccess()) {
            if (!accessURL.equals(a.getStandardUrlName())) continue;
            return a;
        }
        return null;
    }

    public String getCatalogUrl() {
        Catalog parent = this.getParentCatalog();
        if (parent == null) {
            return null;
        }
        String baseUri = parent.getUriString();
        if (baseUri == null) {
            return null;
        }
        return baseUri + "#" + this.getId();
    }

    public String getCollectionType() {
        return (String)this.flds.get(CollectionType);
    }

    public boolean isDatasetScan() {
        return false;
    }

    public boolean isHarvest() {
        Boolean result = (Boolean)this.flds.get(Harvest);
        return result != null && result != false;
    }

    public String getId() {
        return (String)this.flds.get(Id);
    }

    public String getID() {
        return this.getId();
    }

    public String getUrlPath() {
        return (String)this.flds.get(UrlPath);
    }

    public String getIdOrPath() {
        String id = this.getId();
        return id != null ? id : this.getUrlPath();
    }

    public Element getNcmlElement() {
        return (Element)this.getLocalField(Ncml);
    }

    @Override
    public Object getLocalField(String fldName) {
        return this.flds.get(fldName);
    }

    Object getInheritedOnlyField(String fldName) {
        Object value;
        ThreddsMetadata tmi = (ThreddsMetadata)this.flds.get(ThreddsMetadataInheritable);
        if (tmi != null && (value = tmi.getLocalField(fldName)) != null) {
            return value;
        }
        Dataset parent = this.getParentDataset();
        return parent == null ? null : parent.getInheritedOnlyField(fldName);
    }

    Object getInheritedField(String fldName) {
        Object value = this.flds.get(fldName);
        if (value != null) {
            return value;
        }
        return this.getInheritedOnlyField(fldName);
    }

    public String getAuthority() {
        return (String)this.getInheritedField(Authority);
    }

    public String getDataFormatName() {
        return (String)this.getInheritedField(DataFormatType);
    }

    public DataFormatType getDataFormatType() {
        String name = this.getDataFormatName();
        if (name == null) {
            return null;
        }
        try {
            return ucar.nc2.constants.DataFormatType.getType(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getDataSize() {
        Long size = (Long)this.getInheritedField(DataSize);
        return size == null ? -1L : size;
    }

    public boolean hasDataSize() {
        Long size = (Long)this.getInheritedField(DataSize);
        return size != null && size > 0L;
    }

    public FeatureType getFeatureType() {
        String name = this.getFeatureTypeName();
        try {
            return ucar.nc2.constants.FeatureType.getType(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFeatureTypeName() {
        return (String)this.getInheritedField(FeatureType);
    }

    public ThreddsMetadata.GeospatialCoverage getGeospatialCoverage() {
        return (ThreddsMetadata.GeospatialCoverage)this.getInheritedField(GeospatialCoverage);
    }

    public String getServiceNameDefault() {
        return (String)this.getInheritedField(ServiceName);
    }

    public Service getServiceDefault() {
        Catalog cat = this.getParentCatalog();
        if (cat == null) {
            return null;
        }
        return cat.findService(this.getServiceNameDefault());
    }

    public String getRestrictAccess() {
        return (String)this.getInheritedField(RestrictAccess);
    }

    public DateRange getTimeCoverage() {
        return (DateRange)this.getInheritedField(TimeCoverage);
    }

    public ThreddsMetadata.UriResolved getVariableMapLink() {
        return (ThreddsMetadata.UriResolved)this.getInheritedField(VariableMapLinkURI);
    }

    List getInheritedFieldAsList(String fldName) {
        ArrayList result = new ArrayList();
        Object value = this.flds.get(fldName);
        if (value != null) {
            if (value instanceof List) {
                result.addAll((List)value);
            } else {
                result.add(value);
            }
        }
        this.getAllFromInherited(fldName, result);
        return result;
    }

    void getAllFromInherited(String fldName, List result) {
        Dataset parent;
        Object value;
        ThreddsMetadata tmi = (ThreddsMetadata)this.flds.get(ThreddsMetadataInheritable);
        if (tmi != null && (value = tmi.getLocalField(fldName)) != null) {
            if (value instanceof List) {
                result.addAll((List)value);
            } else {
                result.add(value);
            }
        }
        if ((parent = this.getParentDataset()) != null) {
            parent.getAllFromInherited(fldName, result);
        }
    }

    public List<ThreddsMetadata.Source> getCreators() {
        return this.getInheritedFieldAsList(Creators);
    }

    public List<ThreddsMetadata.Contributor> getContributors() {
        return this.getInheritedFieldAsList(Contributors);
    }

    public List<DateType> getDates() {
        return this.getInheritedFieldAsList(Dates);
    }

    public List<Documentation> getDocumentation() {
        return this.getInheritedFieldAsList(Documentation);
    }

    public List<ThreddsMetadata.Vocab> getKeywords() {
        return this.getInheritedFieldAsList(Keywords);
    }

    public List<ThreddsMetadata.MetadataOther> getMetadataOther() {
        return this.getInheritedFieldAsList(MetadataOther);
    }

    public List<ThreddsMetadata.MetadataOther> getMetadata(String want) {
        ArrayList<ThreddsMetadata.MetadataOther> result = new ArrayList<ThreddsMetadata.MetadataOther>();
        for (ThreddsMetadata.MetadataOther m3 : this.getMetadataOther()) {
            if (m3.getType() == null || !m3.getType().equalsIgnoreCase(want)) continue;
            result.add(m3);
        }
        return result;
    }

    public List<ThreddsMetadata.Vocab> getProjects() {
        return this.getInheritedFieldAsList(Projects);
    }

    public List<Property> getProperties() {
        List result = this.getInheritedFieldAsList(Properties);
        return Property.removeDups(result);
    }

    public String findProperty(String name) {
        Property result = null;
        for (Property p : this.getProperties()) {
            if (!p.getName().equals(name)) continue;
            result = p;
        }
        return result == null ? null : result.getValue();
    }

    public boolean hasProperty(Property want) {
        return this.getProperties().contains(want);
    }

    public boolean hasProperty(String name) {
        return this.findProperty(name) != null;
    }

    public List<ThreddsMetadata.Source> getPublishers() {
        return this.getInheritedFieldAsList(Publishers);
    }

    public List<ThreddsMetadata.VariableGroup> getVariables() {
        return this.getInheritedFieldAsList(VariableGroups);
    }

    public String getDocumentation(String type) {
        for (Documentation doc : this.getDocumentation()) {
            String dtype = doc.getType();
            if (dtype == null || !dtype.equalsIgnoreCase(type)) continue;
            return doc.getInlineContent();
        }
        return null;
    }

    public String getHistory() {
        return this.getDocumentation("history");
    }

    public String getProcessing() {
        return this.getDocumentation("processing_level");
    }

    public String getRights() {
        return this.getDocumentation("rights");
    }

    public String getSummary() {
        return this.getDocumentation("summary");
    }

    public DateType getLastModifiedDate() {
        for (DateType dateType : this.getDates()) {
            if (dateType.getType() == null || !dateType.getType().equals("modified")) continue;
            return dateType;
        }
        return null;
    }
}

