/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.image.output;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import ucar.jpeg.jj2000.j2k.image.BlkImgDataSrc;
import ucar.jpeg.jj2000.j2k.image.DataBlkInt;
import ucar.jpeg.jj2000.j2k.image.output.ImgWriter;

public class ImgWriterPGX
extends ImgWriter {
    int maxVal;
    int minVal;
    int levShift;
    boolean isSigned;
    private int bitDepth;
    private RandomAccessFile out;
    private int offset;
    private DataBlkInt db = new DataBlkInt();
    private int fb;
    private int c;
    private int packBytes;
    private byte[] buf;

    public ImgWriterPGX(File out, BlkImgDataSrc imgSrc, int c, boolean isSigned) throws IOException {
        this.c = c;
        if (out.exists() && !out.delete()) {
            throw new IOException("Could not reset file");
        }
        this.out = new RandomAccessFile(out, "rw");
        this.isSigned = isSigned;
        this.src = imgSrc;
        this.w = this.src.getImgWidth();
        this.h = this.src.getImgHeight();
        this.fb = imgSrc.getFixedPoint(c);
        this.bitDepth = this.src.getNomRangeBits(this.c);
        if (this.bitDepth <= 0 || this.bitDepth > 31) {
            throw new IOException("PGX supports only bit-depth between 1 and 31");
        }
        this.packBytes = this.bitDepth <= 8 ? 1 : (this.bitDepth <= 16 ? 2 : 4);
        String tmpString = "PG ML " + (this.isSigned ? "- " : "+ ") + this.bitDepth + " " + this.w + " " + this.h + "\n";
        byte[] tmpByte = tmpString.getBytes();
        for (int i = 0; i < tmpByte.length; ++i) {
            this.out.write(tmpByte[i]);
        }
        this.offset = tmpByte.length;
        this.maxVal = this.isSigned ? (1 << this.src.getNomRangeBits(c) - 1) - 1 : (1 << this.src.getNomRangeBits(c)) - 1;
        this.minVal = this.isSigned ? -1 * (1 << this.src.getNomRangeBits(c) - 1) : 0;
        this.levShift = this.isSigned ? 0 : 1 << this.src.getNomRangeBits(c) - 1;
    }

    public ImgWriterPGX(String fname, BlkImgDataSrc imgSrc, int c, boolean isSigned) throws IOException {
        this(new File(fname), imgSrc, c, isSigned);
    }

    @Override
    public void close() throws IOException {
        if (this.out.length() != (long)(this.w * this.h * this.packBytes + this.offset)) {
            this.out.seek(this.out.length());
            for (int i = this.offset + this.w * this.h * this.packBytes - (int)this.out.length(); i > 0; --i) {
                this.out.writeByte(0);
            }
        }
        this.out.close();
        this.src = null;
        this.out = null;
        this.db = null;
    }

    @Override
    public void flush() throws IOException {
        this.buf = null;
    }

    @Override
    public void write(int ulx, int uly, int w, int h2) throws IOException {
        int fracbits = this.fb;
        this.db.ulx = ulx;
        this.db.uly = uly;
        this.db.w = w;
        this.db.h = h2;
        int tOffx = this.src.getCompULX(this.c) - (int)Math.ceil((double)this.src.getImgULX() / (double)this.src.getCompSubsX(this.c));
        int tOffy = this.src.getCompULY(this.c) - (int)Math.ceil((double)this.src.getImgULY() / (double)this.src.getCompSubsY(this.c));
        if (this.db.data != null && this.db.data.length < w * h2) {
            this.db.data = null;
        }
        do {
            this.db = (DataBlkInt)this.src.getInternCompData(this.db, this.c);
        } while (this.db.progressive);
        if (this.buf == null || this.buf.length < this.packBytes * w) {
            this.buf = new byte[this.packBytes * w];
        }
        switch (this.packBytes) {
            case 1: {
                for (int i = 0; i < h2; ++i) {
                    int tmp;
                    int j;
                    int k;
                    this.out.seek(this.offset + this.w * (uly + tOffy + i) + ulx + tOffx);
                    if (fracbits == 0) {
                        k = this.db.offset + i * this.db.scanw + w - 1;
                        j = w - 1;
                        while (j >= 0) {
                            tmp = this.db.data[k] + this.levShift;
                            this.buf[j--] = (byte)(tmp < this.minVal ? this.minVal : (tmp > this.maxVal ? this.maxVal : tmp));
                            --k;
                        }
                    } else {
                        k = this.db.offset + i * this.db.scanw + w - 1;
                        j = w - 1;
                        while (j >= 0) {
                            tmp = (this.db.data[k] >>> fracbits) + this.levShift;
                            this.buf[j--] = (byte)(tmp < this.minVal ? this.minVal : (tmp > this.maxVal ? this.maxVal : tmp));
                            --k;
                        }
                    }
                    this.out.write(this.buf, 0, w);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < h2; ++i) {
                    int tmp;
                    int j;
                    int k;
                    this.out.seek(this.offset + 2 * (this.w * (uly + tOffy + i) + ulx + tOffx));
                    if (fracbits == 0) {
                        k = this.db.offset + i * this.db.scanw + w - 1;
                        j = (w << 1) - 1;
                        while (j >= 0) {
                            tmp = this.db.data[k] + this.levShift;
                            tmp = tmp < this.minVal ? this.minVal : (tmp > this.maxVal ? this.maxVal : tmp);
                            this.buf[j--] = (byte)tmp;
                            this.buf[j--] = (byte)(tmp >>> 8);
                            --k;
                        }
                    } else {
                        k = this.db.offset + i * this.db.scanw + w - 1;
                        j = (w << 1) - 1;
                        while (j >= 0) {
                            tmp = (this.db.data[k] >>> fracbits) + this.levShift;
                            tmp = tmp < this.minVal ? this.minVal : (tmp > this.maxVal ? this.maxVal : tmp);
                            this.buf[j--] = (byte)tmp;
                            this.buf[j--] = (byte)(tmp >>> 8);
                            --k;
                        }
                    }
                    this.out.write(this.buf, 0, w << 1);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < h2; ++i) {
                    int tmp;
                    int j;
                    int k;
                    this.out.seek(this.offset + 4 * (this.w * (uly + tOffy + i) + ulx + tOffx));
                    if (fracbits == 0) {
                        k = this.db.offset + i * this.db.scanw + w - 1;
                        j = (w << 2) - 1;
                        while (j >= 0) {
                            tmp = this.db.data[k] + this.levShift;
                            tmp = tmp < this.minVal ? this.minVal : (tmp > this.maxVal ? this.maxVal : tmp);
                            this.buf[j--] = (byte)tmp;
                            this.buf[j--] = (byte)(tmp >>> 8);
                            this.buf[j--] = (byte)(tmp >>> 16);
                            this.buf[j--] = (byte)(tmp >>> 24);
                            --k;
                        }
                    } else {
                        k = this.db.offset + i * this.db.scanw + w - 1;
                        j = (w << 2) - 1;
                        while (j >= 0) {
                            tmp = (this.db.data[k] >>> fracbits) + this.levShift;
                            tmp = tmp < this.minVal ? this.minVal : (tmp > this.maxVal ? this.maxVal : tmp);
                            this.buf[j--] = (byte)tmp;
                            this.buf[j--] = (byte)(tmp >>> 8);
                            this.buf[j--] = (byte)(tmp >>> 16);
                            this.buf[j--] = (byte)(tmp >>> 24);
                            --k;
                        }
                    }
                    this.out.write(this.buf, 0, w << 2);
                }
                break;
            }
            default: {
                throw new IOException("PGX supports only bit-depth between 1 and 31");
            }
        }
    }

    @Override
    public void write() throws IOException {
        int tIdx = this.src.getTileIdx();
        int tw = this.src.getTileCompWidth(tIdx, this.c);
        int th = this.src.getTileCompHeight(tIdx, this.c);
        for (int i = 0; i < th; i += 64) {
            this.write(0, i, tw, th - i < 64 ? th - i : 64);
        }
    }

    public String toString() {
        return "ImgWriterPGX: WxH = " + this.w + "x" + this.h + ", Component = " + this.c + ", Bit-depth = " + this.bitDepth + ", signed = " + this.isSigned + "\nUnderlying RandomAccessFile:\n" + this.out.toString();
    }
}

