/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2TableConfig;
import ucar.nc2.grib.grib2.table.LocalTables;

public class NdfdLocalTables
extends LocalTables {
    NdfdLocalTables(Grib2TableConfig config) {
        super(config);
        this.init();
    }

    @Override
    public String getParamTablePathUsedFor(int discipline, int category, int number) {
        if (category <= 191 && number <= 191) {
            return super.getParamTablePathUsedFor(discipline, category, number);
        }
        return this.getClass().getName();
    }

    private void init() {
        this.add(0, 0, 193, "ApparentT", "Apparent Temperature", "K");
        this.add(0, 1, 192, "Wx", "Weather string", "");
        this.add(0, 10, 8, "PoP12", "Prob of 0.01 In. of Precip", "%");
        this.add(0, 13, 194, "smokes", "Surface level smoke from fires", "log10(g/m^3)");
        this.add(0, 13, 195, "smokec", "Average vertical column smoke from fires", "log10(g/m^3)");
        this.add(0, 14, 192, "O3MR", "Ozone Mixing Ratio", "kg/kg");
        this.add(0, 14, 193, "OZCON", "Ozone Concentration", "PPB");
        this.add(0, 14, 200, "OZMAX1", "Ozone Daily Max from 1-hour Average", "ppbV");
        this.add(0, 14, 201, "OZMAX8", "Ozone Daily Max from 8-hour Average", "ppbV");
        this.add(0, 19, 194, "ConvOutlook", "Convective Hazard Outlook", "0=none; 2=tstm; 4=slight; 6=moderate; 8=high");
        this.add(0, 19, 197, "TornadoProb", "Tornado Probability", "%");
        this.add(0, 19, 198, "HailProb", "Hail Probability", "%");
        this.add(0, 19, 199, "WindProb", "Damaging Thunderstorm Wind Probability", "%");
        this.add(0, 19, 200, "XtrmTornProb", "Extreme Tornado Probability", "%");
        this.add(0, 19, 201, "XtrmHailProb", "Extreme Hail Probability", "%");
        this.add(0, 19, 202, "XtrmWindProb", "Extreme Thunderstorm Wind Probability", "%");
        this.add(0, 19, 215, "TotalSvrProb", "Total Probability of Severe Thunderstorms", "%");
        this.add(0, 19, 216, "TotalXtrmProb", "Total Probability of Extreme Severe Thunderstorms", "%");
        this.add(0, 19, 217, "WWA", "Watch Warning Advisory", "");
        this.add(0, 19, 203, "TotalSvrProb", "Total Probability of Severe Thunderstorms", "%");
        this.add(0, 19, 204, "TotalXtrmProb", "Total Probability of Extreme Severe Thunderstorms", "%");
        this.add(0, 192, 192, "FireWx", "Critical Fire Weather", "%");
        this.add(0, 192, 194, "DryLightning", "Dry Lightning", "%");
        this.add(10, 3, 192, "Surge", "Hurricane Storm Surge", "m");
        this.add(10, 3, 193, "ETSurge", "Extra Tropical Storm Surge", "m");
    }

    private void add(int discipline, int category, int number, String abbrev, String name, String unit) {
        this.localParams.put(NdfdLocalTables.makeParamId(discipline, category, number), new Grib2Parameter(discipline, category, number, name, unit, abbrev, null));
    }
}

