/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.ncml;

import java.util.Optional;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ReplaceVariableCheck;
import ucar.nc2.dataset.VariableDS;

class BuilderHelper {
    BuilderHelper() {
    }

    static void transferDataset(NetcdfFile src, NetcdfDataset.Builder target, ReplaceVariableCheck replaceCheck) {
        BuilderHelper.transferGroup(src, target, src.getRootGroup(), target.rootGroup, replaceCheck);
    }

    private static void transferGroup(NetcdfFile ds, NetcdfDataset.Builder targetDs, Group src, Group.Builder targetGroup, ReplaceVariableCheck replaceCheck) {
        boolean unlimitedOK = true;
        BuilderHelper.transferAttributes(src, targetGroup.getAttributeContainer());
        for (Dimension d : src.getDimensions()) {
            if (targetGroup.findDimensionLocal(d.getShortName()).isPresent()) continue;
            Dimension newd = Dimension.builder(d.getShortName(), d.getLength()).setIsShared(d.isShared()).setIsUnlimited(unlimitedOK && d.isUnlimited()).setIsVariableLength(d.isVariableLength()).build();
            targetGroup.addDimension(newd);
        }
        for (Variable v : src.getVariables()) {
            boolean replace;
            Optional<Variable.Builder<?>> targetV = targetGroup.findVariable(v.getShortName());
            boolean bl = replace = replaceCheck != null && replaceCheck.replace(v);
            if (!replace && targetV.isPresent()) continue;
            Variable.Builder vb = !(v instanceof VariableDS) ? VariableDS.builder().copyFrom(v) : (VariableDS.Builder)((VariableDS)v).toBuilder().setProxyReader(null);
            targetGroup.replaceVariable(vb);
        }
        for (Group srcNested : src.getGroups()) {
            Optional<Group.Builder> existing = targetGroup.findGroup(srcNested.getShortName());
            if (!existing.isPresent()) {
                Group.Builder nested = Group.builder(targetGroup).setName(srcNested.getShortName());
                targetGroup.addGroup(nested);
                BuilderHelper.transferGroup(ds, targetDs, srcNested, nested, replaceCheck);
                continue;
            }
            BuilderHelper.transferGroup(ds, targetDs, srcNested, existing.get(), replaceCheck);
        }
    }

    static void transferAttributes(AttributeContainer src, AttributeContainerMutable target) {
        for (Attribute a : src) {
            if (null != target.findAttribute(a.getShortName())) continue;
            target.addAttribute(a);
        }
    }
}

