/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.writer;

import com.google.common.escape.Escaper;
import com.google.common.xml.XmlEscapers;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Formatter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.util.Indent;
import ucar.unidata.util.StringUtil2;

public class Bufr2Xml {
    private XMLStreamWriter staxWriter;
    private Indent indent;
    private Escaper escaper = XmlEscapers.xmlAttributeEscaper();

    public Bufr2Xml(Message message, NetcdfFile ncfile, OutputStream os, boolean skipMissing) throws IOException {
        this.indent = new Indent(2);
        this.indent.setIndentLevel(0);
        try {
            XMLOutputFactory fac = XMLOutputFactory.newInstance();
            this.staxWriter = fac.createXMLStreamWriter(os, "UTF-8");
            this.staxWriter.writeStartDocument("UTF-8", "1.0");
            this.writeMessage(message, ncfile);
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeEndDocument();
            this.staxWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
    }

    void writeMessage(Message message, NetcdfFile ncfile) {
        try {
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(this.indent.toString());
            this.staxWriter.writeStartElement("bufrMessage");
            this.staxWriter.writeAttribute("nobs", Integer.toString(message.getNumberDatasets()));
            this.indent.incr();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(this.indent.toString());
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(this.indent.toString());
            this.staxWriter.writeStartElement("edition");
            this.staxWriter.writeCharacters(Integer.toString(message.is.getBufrEdition()));
            this.staxWriter.writeEndElement();
            String header = message.getHeader().trim();
            if (!header.isEmpty()) {
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeCharacters(this.indent.toString());
                this.staxWriter.writeStartElement("header");
                this.staxWriter.writeCharacters(header);
                this.staxWriter.writeEndElement();
            }
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(this.indent.toString());
            this.staxWriter.writeStartElement("tableVersion");
            this.staxWriter.writeCharacters(message.getLookup().getTableName());
            this.staxWriter.writeEndElement();
            this.staxWriter.writeStartElement("center");
            this.staxWriter.writeCharacters(message.getLookup().getCenterName());
            this.staxWriter.writeEndElement();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(this.indent.toString());
            this.staxWriter.writeStartElement("category");
            this.staxWriter.writeCharacters(message.getLookup().getCategoryFullName());
            this.staxWriter.writeEndElement();
            SequenceDS obs = (SequenceDS)ncfile.findVariable("obs");
            StructureDataIterator sdataIter = obs.getStructureIterator(-1);
            this.writeSequence(obs, sdataIter);
            this.indent.decr();
            this.staxWriter.writeCharacters("\n");
            this.staxWriter.writeCharacters(this.indent.toString());
            this.staxWriter.writeEndElement();
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSequence(StructureDS s2, StructureDataIterator sdataIter) throws IOException, XMLStreamException {
        int count = 0;
        try {
            while (sdataIter.hasNext()) {
                StructureData sdata = sdataIter.next();
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeCharacters(this.indent.toString());
                this.staxWriter.writeStartElement("struct");
                this.staxWriter.writeAttribute("name", this.escaper.escape(s2.getShortName()));
                this.staxWriter.writeAttribute("count", Integer.toString(count++));
                for (StructureMembers.Member m3 : sdata.getMembers()) {
                    ArrayStructure data;
                    StructureDS sds;
                    Variable v = s2.findVariable(m3.getName());
                    this.indent.incr();
                    if (m3.getDataType().isString() || m3.getDataType().isNumeric()) {
                        this.writeVariable((VariableDS)v, sdata.getArray(m3));
                    } else if (m3.getDataType() == DataType.STRUCTURE) {
                        sds = (StructureDS)v;
                        data = (ArrayStructure)sdata.getArray(m3);
                        this.writeSequence(sds, data.getStructureDataIterator());
                    } else if (m3.getDataType() == DataType.SEQUENCE) {
                        sds = (SequenceDS)v;
                        data = (ArraySequence)sdata.getArray(m3);
                        this.writeSequence(sds, ((ArraySequence)data).getStructureDataIterator());
                    }
                    this.indent.decr();
                }
                this.staxWriter.writeCharacters("\n");
                this.staxWriter.writeCharacters(this.indent.toString());
                this.staxWriter.writeEndElement();
            }
        }
        finally {
            sdataIter.close();
        }
    }

    void writeVariable(VariableDS v, Array mdata) throws XMLStreamException {
        this.staxWriter.writeCharacters("\n");
        this.staxWriter.writeCharacters(this.indent.toString());
        this.staxWriter.writeStartElement("data");
        String name = v.getShortName();
        this.staxWriter.writeAttribute("name", this.escaper.escape(name));
        String units = v.getUnitsString();
        if (units != null && !units.equals(name) && !units.startsWith("Code")) {
            this.staxWriter.writeAttribute("units", this.escaper.escape(v.getUnitsString()));
        }
        String desc = v.attributes().findAttValueIgnoreCase("BUFR:TableB_descriptor", "N/A");
        this.staxWriter.writeAttribute("bufr", this.escaper.escape(desc));
        if (v.getDataType() == DataType.CHAR) {
            ArrayChar ac = (ArrayChar)mdata;
            this.staxWriter.writeCharacters(ac.getString());
        } else {
            int count = 0;
            mdata.resetLocalIterator();
            while (mdata.hasNext()) {
                if (count > 0) {
                    this.staxWriter.writeCharacters(" ");
                }
                ++count;
                if (v.getDataType().isNumeric()) {
                    double val = mdata.nextDouble();
                    if (v.isMissing(val)) {
                        this.staxWriter.writeCharacters("missing");
                        continue;
                    }
                    if (v.getDataType() == DataType.FLOAT || v.getDataType() == DataType.DOUBLE) {
                        this.writeFloat(v, val);
                        continue;
                    }
                    this.staxWriter.writeCharacters(mdata.toString());
                    continue;
                }
                String s2 = StringUtil2.filter7bits(mdata.next().toString());
                this.staxWriter.writeCharacters(this.escaper.escape(s2));
            }
        }
        this.staxWriter.writeEndElement();
    }

    private void writeFloat(Variable v, double val) throws XMLStreamException {
        int sigDigits;
        int bitWidth = v.attributes().findAttributeInteger("BUFR:bitWidth", -99);
        if (bitWidth == -99) {
            sigDigits = 7;
        } else if (bitWidth < 30) {
            double sigDigitsD = Math.log10(2 << bitWidth);
            sigDigits = (int)(sigDigitsD + 1.0);
        } else {
            sigDigits = 7;
        }
        Formatter stringFormatter = new Formatter();
        String format = "%." + sigDigits + "g";
        stringFormatter.format(format, val);
        this.staxWriter.writeCharacters(stringFormatter.toString());
    }
}

