/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.resource;

import com.bc.ceres.resource.Resource;
import com.bc.ceres.resource.StringResource;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class ResourceEngine {
    private final VelocityContext velocityContext;
    private final VelocityEngine velocityEngine;

    public ResourceEngine() {
        this(ResourceEngine.createVelocityEngine());
    }

    public ResourceEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
        this.velocityContext = new VelocityContext();
    }

    private static VelocityEngine createVelocityEngine() {
        VelocityEngine velocityEngine = new VelocityEngine();
        try {
            velocityEngine.init();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize velocity engine", e);
        }
        return velocityEngine;
    }

    public VelocityContext getVelocityContext() {
        return this.velocityContext;
    }

    public Resource processResource(Resource resource) {
        StringWriter stringWriter = new StringWriter();
        String content = resource.getContent();
        this.velocityEngine.evaluate((Context)this.velocityContext, (Writer)stringWriter, "resourceEngine", content);
        String processedContent = stringWriter.toString();
        Resource processedResource = resource;
        if (!processedContent.equals(content)) {
            processedResource = new StringResource(resource.getPath(), processedContent, resource);
        }
        return processedResource;
    }

    public Resource processAndAddResource(String name, Resource resource) {
        Resource processedResource = this.processResource(resource);
        this.velocityContext.put(name, (Object)processedResource);
        return processedResource;
    }

    public Resource getResource(String name) {
        Object object = this.velocityContext.get(name);
        if (object instanceof Resource) {
            return (Resource)object;
        }
        throw new IllegalArgumentException("The requested resource is not of type resource.");
    }
}

