/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.geometry.BoundingBox;

class FastBBOX
implements BBOX,
BinarySpatialOperator,
BinaryComparisonOperator {
    PropertyName property;
    Envelope envelope;
    FilterFactory factory;

    public FastBBOX(PropertyName propertyName, Envelope env, FilterFactory factory) {
        this.property = propertyName;
        this.envelope = env;
        this.factory = factory;
    }

    public double getMaxX() {
        return this.envelope.getMaxX();
    }

    public double getMaxY() {
        return this.envelope.getMaxY();
    }

    public double getMinX() {
        return this.envelope.getMinX();
    }

    public double getMinY() {
        return this.envelope.getMinY();
    }

    public PropertyName getProperty() {
        return this.property;
    }

    public String getPropertyName() {
        return this.property.getPropertyName();
    }

    public String getSRS() {
        return null;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public BoundingBox getBounds() {
        return ReferencedEnvelope.reference(this.envelope);
    }

    public Expression getExpression1() {
        return this.property;
    }

    public Expression getExpression2() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(this.envelope.getMinX(), this.envelope.getMinY()), new Coordinate(this.envelope.getMinX(), this.envelope.getMaxY()), new Coordinate(this.envelope.getMaxX(), this.envelope.getMaxY()), new Coordinate(this.envelope.getMaxX(), this.envelope.getMinY()), new Coordinate(this.envelope.getMinX(), this.envelope.getMinY())};
        LinearRing ring = null;
        GeometryFactory gfac = new GeometryFactory();
        try {
            ring = gfac.createLinearRing(coords);
        }
        catch (TopologyException tex) {
            throw new IllegalFilterException(tex.toString());
        }
        Polygon polygon = gfac.createPolygon(ring, null);
        if (this.envelope instanceof ReferencedEnvelope) {
            ReferencedEnvelope refEnv = (ReferencedEnvelope)this.envelope;
            polygon.setUserData(refEnv.getCoordinateReferenceSystem());
        }
        return this.factory.literal((Object)polygon);
    }

    public Object accept(FilterVisitor visitor, Object context) {
        Object result = visitor.visit((BBOX)this, context);
        if (!(result instanceof BBOX)) {
            return result;
        }
        BBOX clone = (BBOX)result;
        if (clone.getExpression1().equals(this.getExpression1()) && clone.getExpression2().equals(this.getExpression2())) {
            return new FastBBOX(this.property, this.envelope, this.factory);
        }
        return result;
    }

    public boolean evaluate(Object feature) {
        if (feature == null) {
            return false;
        }
        Geometry other = (Geometry)this.property.evaluate(feature);
        if (other == null) {
            return false;
        }
        return other.getEnvelopeInternal().intersects(this.envelope);
    }

    public boolean isMatchingCase() {
        return false;
    }

    public MultiValuedFilter.MatchAction getMatchAction() {
        return MultiValuedFilter.MatchAction.ANY;
    }

    public String toString() {
        return "FastBBOX [property=" + this.property + ", envelope=" + this.envelope + "]";
    }
}

