/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.geotools.filter.ConstantExpression;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UserLayer;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.GraphicalSymbol;

public class MetaBufferEstimator
extends FilterAttributeExtractor
implements StyleVisitor {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");
    protected FilterAttributeExtractor attributeExtractor = new FilterAttributeExtractor();
    protected boolean estimateAccurate = true;
    protected int buffer = 0;
    Feature sample;

    public MetaBufferEstimator() {
    }

    public MetaBufferEstimator(Feature sample) {
        this.sample = sample;
    }

    public void reset() {
        this.estimateAccurate = true;
        this.buffer = 0;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public boolean isEstimateAccurate() {
        return this.estimateAccurate;
    }

    @Override
    public void visit(Style style) {
        FeatureTypeStyle[] ftStyles = style.getFeatureTypeStyles();
        for (int i = 0; i < ftStyles.length; ++i) {
            ftStyles[i].accept(this);
        }
    }

    @Override
    public void visit(Rule rule) {
        Graphic[] legendGraphics;
        Symbolizer[] symbolizers;
        Filter filter = rule.getFilter();
        if (filter != null) {
            filter.accept((FilterVisitor)this, null);
        }
        if ((symbolizers = rule.getSymbolizers()) != null) {
            for (int i = 0; i < symbolizers.length; ++i) {
                Symbolizer symbolizer = symbolizers[i];
                symbolizer.accept(this);
            }
        }
        if ((legendGraphics = rule.getLegendGraphic()) != null) {
            // empty if block
        }
    }

    @Override
    public void visit(FeatureTypeStyle fts) {
        Rule[] rules = fts.getRules();
        for (int i = 0; i < rules.length; ++i) {
            Rule rule = rules[i];
            rule.accept(this);
        }
    }

    @Override
    public void visit(Fill fill) {
    }

    @Override
    public void visit(Stroke stroke) {
        try {
            Expression width = stroke.getWidth();
            if (!this.isNull(width)) {
                this.evaluateWidth(width);
            }
            if (stroke.getGraphicStroke() != null) {
                stroke.getGraphicStroke().accept(this);
            }
        }
        catch (ClassCastException e) {
            this.estimateAccurate = false;
            LOGGER.info("Could not parse stroke width, it's a literal but not a Number...");
        }
    }

    protected boolean isNull(Expression exp) {
        return exp == null || exp instanceof NilExpression || exp instanceof ConstantExpression && ((ConstantExpression)exp).getValue() == null;
    }

    @Override
    public void visit(Symbolizer sym) {
        if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        }
        if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        }
        if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        }
        if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        }
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        }
    }

    @Override
    public void visit(RasterSymbolizer rs) {
        if (rs.getGeometryPropertyName() != null) {
            this.attributeNames.add(rs.getGeometryPropertyName());
        }
        if (rs.getImageOutline() != null) {
            rs.getImageOutline().accept(this);
        }
        if (rs.getOpacity() != null) {
            rs.getOpacity().accept((ExpressionVisitor)this, null);
        }
    }

    @Override
    public void visit(PointSymbolizer ps) {
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept(this);
        }
    }

    @Override
    public void visit(LineSymbolizer line) {
        if (line.getStroke() != null) {
            line.getStroke().accept(this);
        }
    }

    @Override
    public void visit(PolygonSymbolizer poly) {
        if (poly.getStroke() != null) {
            poly.getStroke().accept(this);
        }
    }

    @Override
    public void visit(TextSymbolizer text) {
        Graphic graphic;
        if (text.fonts() != null && !text.fonts().isEmpty()) {
            for (Font font : text.fonts()) {
                int textSize = this.getPositiveValue(font.getSize());
                int delta = -1;
                if (text.getLabelPlacement() instanceof PointPlacement) {
                    AnchorPoint ap;
                    PointPlacement pp = (PointPlacement)text.getLabelPlacement();
                    Displacement pd = pp.getDisplacement();
                    if (pd != null) {
                        int dx = this.getPositiveValue(pd.getDisplacementX());
                        int dy = this.getPositiveValue(pd.getDisplacementY());
                        delta = Math.max(dx, dy);
                    }
                    if ((ap = pp.getAnchorPoint()) != null) {
                        double ax = Math.abs(this.getDouble(ap.getAnchorPointX()) - 0.5);
                        double ay = Math.abs(this.getDouble(ap.getAnchorPointY()) - 0.5);
                        int anchorDelta = (int)Math.ceil(Math.max(ax, ay) * (double)textSize);
                        delta = delta > 0 ? (delta += anchorDelta) : anchorDelta;
                    }
                }
                int total = -1;
                if (delta > 0) {
                    total = textSize > 0 ? delta + textSize : delta;
                } else if (textSize > 0) {
                    total = textSize;
                }
                this.buffer = Math.max(this.buffer, total);
            }
        }
        if (text instanceof TextSymbolizer2 && (graphic = ((TextSymbolizer2)text).getGraphic()) != null) {
            graphic.accept(this);
        }
    }

    @Override
    public void visit(Graphic gr) {
        try {
            Expression grSize = gr.getSize();
            int imageSize = -1;
            boolean isSizeNull = this.isNull(grSize);
            boolean isSizeConstant = false;
            if (!isSizeNull) {
                isSizeConstant = this.isConstant(grSize);
                if (isSizeConstant) {
                    imageSize = (int)Math.ceil((Double)grSize.evaluate(null, Double.class));
                } else {
                    this.estimateAccurate = false;
                    return;
                }
            }
            for (GraphicalSymbol gs : gr.graphicalSymbols()) {
                if (gs instanceof ExternalGraphic) {
                    ExternalGraphic eg = (ExternalGraphic)gs;
                    Icon icon = null;
                    if (eg.getInlineContent() != null) {
                        icon = eg.getInlineContent();
                    } else {
                        String location = eg.getLocation().toExternalForm();
                        Expression expanded = ExpressionExtractor.extractCqlExpressions(location);
                        if (!(expanded instanceof Literal)) {
                            this.estimateAccurate = false;
                            return;
                        }
                        Iterator<ExternalGraphicFactory> it = DynamicSymbolFactoryFinder.getExternalGraphicFactories();
                        while (it.hasNext() && icon == null) {
                            try {
                                ExternalGraphicFactory factory = it.next();
                                icon = factory.getIcon(null, expanded, eg.getFormat(), imageSize);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.FINE, "Error occurred evaluating external graphic", e);
                            }
                        }
                    }
                    if (icon != null && icon != null) {
                        int size = Math.max(icon.getIconHeight(), icon.getIconWidth());
                        if (size > this.buffer) {
                            this.buffer = size;
                        }
                        return;
                    }
                } else if (gs instanceof Mark) {
                    Mark mark = (Mark)gs;
                    int markSize = isSizeConstant ? imageSize : 16;
                    if (mark.getStroke() != null) {
                        int strokeWidth = this.getPositiveValue(mark.getStroke().getWidth());
                        if (strokeWidth < 0) {
                            this.estimateAccurate = false;
                        } else {
                            markSize += strokeWidth;
                        }
                    }
                    if (markSize > this.buffer) {
                        this.buffer = markSize;
                    }
                    return;
                }
                this.estimateAccurate = false;
            }
        }
        catch (ClassCastException e) {
            this.estimateAccurate = false;
            LOGGER.info("Could not parse graphic size, it's a literal but not a Number...");
        }
        catch (Exception e) {
            this.estimateAccurate = false;
            LOGGER.log(Level.INFO, "Error occured during the graphic size estimation, meta buffer estimate cannot be performed", e);
        }
    }

    protected void evaluateWidth(Expression width) {
        int value = this.getPositiveValue(width);
        if (value < 0) {
            this.estimateAccurate = false;
        } else if (value > this.buffer) {
            this.buffer = value;
        }
    }

    protected int getPositiveValue(Expression ex) {
        double value = this.getDouble(ex);
        if (value == -1.0) {
            return -1;
        }
        return (int)Math.ceil(value);
    }

    protected double getDouble(Expression ex) {
        if (this.isConstant(ex) || this.sample != null) {
            Double result = (Double)ex.evaluate((Object)this.sample, Double.class);
            if (result != null) {
                return result;
            }
            return -1.0;
        }
        return -1.0;
    }

    protected boolean isConstant(Expression ex) {
        if (ex instanceof Literal) {
            return true;
        }
        if (ex instanceof PropertyName) {
            return false;
        }
        this.attributeExtractor.clear();
        ex.accept((ExpressionVisitor)this.attributeExtractor, null);
        return this.attributeExtractor.isConstantExpression();
    }

    @Override
    public void visit(Mark mark) {
    }

    @Override
    public void visit(ExternalGraphic exgr) {
    }

    @Override
    public void visit(PointPlacement pp) {
    }

    @Override
    public void visit(AnchorPoint ap) {
    }

    @Override
    public void visit(Displacement dis) {
    }

    @Override
    public void visit(LinePlacement lp) {
    }

    @Override
    public void visit(Halo halo) {
    }

    @Override
    public void visit(StyledLayerDescriptor sld) {
        StyledLayer[] layers = sld.getStyledLayers();
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i] instanceof NamedLayer) {
                ((NamedLayer)layers[i]).accept(this);
                continue;
            }
            if (!(layers[i] instanceof UserLayer)) continue;
            ((UserLayer)layers[i]).accept(this);
        }
    }

    @Override
    public void visit(NamedLayer layer) {
        Style[] styles = layer.getStyles();
        for (int i = 0; i < styles.length; ++i) {
            styles[i].accept(this);
        }
    }

    @Override
    public void visit(UserLayer layer) {
        Style[] styles = layer.getUserStyles();
        for (int i = 0; i < styles.length; ++i) {
            styles[i].accept(this);
        }
    }

    @Override
    public void visit(FeatureTypeConstraint ftc) {
        ftc.accept(this);
    }

    @Override
    public void visit(ColorMap map) {
    }

    @Override
    public void visit(ColorMapEntry entry) {
    }

    @Override
    public void visit(ContrastEnhancement contrastEnhancement) {
    }

    @Override
    public void visit(ImageOutline outline) {
        outline.accept(this);
    }

    @Override
    public void visit(ChannelSelection cs) {
    }

    @Override
    public void visit(OverlapBehavior ob) {
    }

    @Override
    public void visit(SelectedChannelType sct) {
    }

    @Override
    public void visit(ShadedRelief sr) {
    }
}

