/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;

class SimpleGeometryFactory
extends GeometryFactory {
    public SimpleGeometryFactory(CoordinateSequenceFactory csFactory) {
        super(csFactory);
    }

    @Override
    public GeometryCollection createGeometryCollection(Geometry[] geometries) {
        if (geometries != null && geometries.length == 1) {
            return new CollectionOfOne(geometries, this);
        }
        return super.createGeometryCollection(geometries);
    }

    @Override
    public MultiLineString createMultiLineString(LineString[] lineStrings) {
        if (lineStrings != null && lineStrings.length == 1) {
            return new SingleLineCollection(lineStrings, (GeometryFactory)this);
        }
        return super.createMultiLineString(lineStrings);
    }

    @Override
    public MultiPolygon createMultiPolygon(Polygon[] polygons) {
        if (polygons != null && polygons.length == 1) {
            return new SinglePolygonCollection(polygons, (GeometryFactory)this);
        }
        return super.createMultiPolygon(polygons);
    }

    static class SinglePointCollection
    extends MultiPoint {
        Point point;

        public SinglePointCollection(Point[] points, GeometryFactory factory) {
            super(points, factory);
            this.point = points[0];
        }

        @Override
        public void apply(CoordinateFilter filter) {
            this.point.apply(filter);
        }

        @Override
        public void apply(CoordinateSequenceFilter filter) {
            this.point.apply(filter);
        }

        @Override
        public void apply(GeometryComponentFilter filter) {
            this.point.apply(filter);
        }

        @Override
        public void apply(GeometryFilter filter) {
            this.point.apply(filter);
        }

        @Override
        public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
            return this.point.buffer(distance, quadrantSegments, endCapStyle);
        }

        @Override
        public Geometry buffer(double distance, int quadrantSegments) {
            return this.point.buffer(distance, quadrantSegments);
        }

        @Override
        public Geometry buffer(double distance) {
            return this.point.buffer(distance);
        }

        @Override
        public int compareTo(Object o, CoordinateSequenceComparator comp) {
            return this.point.compareTo(o, comp);
        }

        @Override
        public int compareTo(Object o) {
            return this.point.compareTo(o);
        }

        @Override
        public boolean contains(Geometry g) {
            return this.point.contains(g);
        }

        @Override
        public Geometry convexHull() {
            return this.point.convexHull();
        }

        @Override
        public boolean coveredBy(Geometry g) {
            return this.point.coveredBy(g);
        }

        @Override
        public boolean covers(Geometry g) {
            return this.point.covers(g);
        }

        @Override
        public boolean crosses(Geometry g) {
            return this.point.crosses(g);
        }

        @Override
        public Geometry difference(Geometry other) {
            return this.point.difference(other);
        }

        @Override
        public boolean disjoint(Geometry g) {
            return this.point.disjoint(g);
        }

        @Override
        public double distance(Geometry g) {
            return this.point.distance(g);
        }

        @Override
        public boolean equals(Geometry g) {
            return this.point.equalsTopo(g);
        }

        @Override
        public boolean equals(Object obj) {
            return this.point.equals(obj);
        }

        @Override
        public boolean equalsExact(Geometry other, double tolerance) {
            return this.point.equalsExact(other, tolerance);
        }

        @Override
        public boolean equalsExact(Geometry other) {
            return this.point.equalsExact(other);
        }

        @Override
        public void geometryChanged() {
            this.point.geometryChanged();
        }

        @Override
        public double getArea() {
            return this.point.getArea();
        }

        @Override
        public Geometry getBoundary() {
            return this.point.getBoundary();
        }

        @Override
        public int getBoundaryDimension() {
            return this.point.getBoundaryDimension();
        }

        @Override
        public Point getCentroid() {
            return this.point.getCentroid();
        }

        @Override
        public Coordinate getCoordinate() {
            return this.point.getCoordinate();
        }

        @Override
        public Coordinate[] getCoordinates() {
            return this.point.getCoordinates();
        }

        public CoordinateSequence getCoordinateSequence() {
            return this.point.getCoordinateSequence();
        }

        @Override
        public int getDimension() {
            return this.point.getDimension();
        }

        @Override
        public Geometry getEnvelope() {
            return this.point.getEnvelope();
        }

        @Override
        public Envelope getEnvelopeInternal() {
            return this.point.getEnvelopeInternal();
        }

        @Override
        public GeometryFactory getFactory() {
            return this.point.getFactory();
        }

        @Override
        public Geometry getGeometryN(int n) {
            return this.point.getGeometryN(n);
        }

        @Override
        public String getGeometryType() {
            return this.point.getGeometryType();
        }

        @Override
        public Point getInteriorPoint() {
            return this.point.getInteriorPoint();
        }

        @Override
        public double getLength() {
            return this.point.getLength();
        }

        @Override
        public int getNumGeometries() {
            return this.point.getNumGeometries();
        }

        @Override
        public int getNumPoints() {
            return this.point.getNumPoints();
        }

        @Override
        public PrecisionModel getPrecisionModel() {
            return this.point.getPrecisionModel();
        }

        @Override
        public int getSRID() {
            return this.point.getSRID();
        }

        @Override
        public Object getUserData() {
            return this.point.getUserData();
        }

        public double getX() {
            return this.point.getX();
        }

        public double getY() {
            return this.point.getY();
        }

        @Override
        public int hashCode() {
            return this.point.hashCode();
        }

        @Override
        public Geometry intersection(Geometry other) {
            return this.point.intersection(other);
        }

        @Override
        public boolean intersects(Geometry g) {
            return this.point.intersects(g);
        }

        @Override
        public boolean isEmpty() {
            return this.point.isEmpty();
        }

        @Override
        public boolean isRectangle() {
            return this.point.isRectangle();
        }

        @Override
        public boolean isSimple() {
            return this.point.isSimple();
        }

        @Override
        public boolean isValid() {
            return this.point.isValid();
        }

        @Override
        public boolean isWithinDistance(Geometry geom, double distance) {
            return this.point.isWithinDistance(geom, distance);
        }

        @Override
        public void normalize() {
            this.point.normalize();
        }

        @Override
        public boolean overlaps(Geometry g) {
            return this.point.overlaps(g);
        }

        @Override
        public boolean relate(Geometry g, String intersectionPattern) {
            return this.point.relate(g, intersectionPattern);
        }

        @Override
        public IntersectionMatrix relate(Geometry g) {
            return this.point.relate(g);
        }

        @Override
        public Geometry reverse() {
            return this.point.reverse();
        }

        @Override
        public void setSRID(int SRID) {
            this.point.setSRID(SRID);
        }

        @Override
        public void setUserData(Object userData) {
            this.point.setUserData(userData);
        }

        @Override
        public Geometry symDifference(Geometry other) {
            return this.point.symDifference(other);
        }

        @Override
        public String toString() {
            return this.point.toString();
        }

        @Override
        public String toText() {
            return this.point.toText();
        }

        @Override
        public boolean touches(Geometry g) {
            return this.point.touches(g);
        }

        @Override
        public Geometry union() {
            return this.point.union();
        }

        @Override
        public Geometry union(Geometry other) {
            return this.point.union(other);
        }

        @Override
        public boolean within(Geometry g) {
            return this.point.within(g);
        }
    }

    static class SinglePolygonCollection
    extends MultiPolygon {
        Polygon polygon;

        public SinglePolygonCollection(Polygon[] polygons, GeometryFactory factory) {
            super(polygons, factory);
            this.polygon = polygons[0];
        }

        @Override
        public void apply(CoordinateFilter filter) {
            this.polygon.apply(filter);
        }

        @Override
        public void apply(CoordinateSequenceFilter filter) {
            this.polygon.apply(filter);
        }

        @Override
        public void apply(GeometryComponentFilter filter) {
            this.polygon.apply(filter);
        }

        @Override
        public void apply(GeometryFilter filter) {
            this.polygon.apply(filter);
        }

        @Override
        public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
            return this.polygon.buffer(distance, quadrantSegments, endCapStyle);
        }

        @Override
        public Geometry buffer(double distance, int quadrantSegments) {
            return this.polygon.buffer(distance, quadrantSegments);
        }

        @Override
        public Geometry buffer(double distance) {
            return this.polygon.buffer(distance);
        }

        @Override
        public int compareTo(Object o, CoordinateSequenceComparator comp) {
            return this.polygon.compareTo(o, comp);
        }

        @Override
        public int compareTo(Object o) {
            return this.polygon.compareTo(o);
        }

        @Override
        public boolean contains(Geometry g) {
            return this.polygon.contains(g);
        }

        @Override
        public Geometry convexHull() {
            return this.polygon.convexHull();
        }

        @Override
        public boolean coveredBy(Geometry g) {
            return this.polygon.coveredBy(g);
        }

        @Override
        public boolean covers(Geometry g) {
            return this.polygon.covers(g);
        }

        @Override
        public boolean crosses(Geometry g) {
            return this.polygon.crosses(g);
        }

        @Override
        public Geometry difference(Geometry other) {
            return this.polygon.difference(other);
        }

        @Override
        public boolean disjoint(Geometry g) {
            return this.polygon.disjoint(g);
        }

        @Override
        public double distance(Geometry g) {
            return this.polygon.distance(g);
        }

        @Override
        public boolean equals(Geometry g) {
            return this.polygon.equalsTopo(g);
        }

        @Override
        public boolean equals(Object obj) {
            return this.polygon.equals(obj);
        }

        @Override
        public boolean equalsExact(Geometry other, double tolerance) {
            return this.polygon.equalsExact(other, tolerance);
        }

        @Override
        public boolean equalsExact(Geometry other) {
            return this.polygon.equalsExact(other);
        }

        @Override
        public void geometryChanged() {
            this.polygon.geometryChanged();
        }

        @Override
        public double getArea() {
            return this.polygon.getArea();
        }

        @Override
        public Geometry getBoundary() {
            return this.polygon.getBoundary();
        }

        @Override
        public int getBoundaryDimension() {
            return this.polygon.getBoundaryDimension();
        }

        @Override
        public Point getCentroid() {
            return this.polygon.getCentroid();
        }

        @Override
        public Coordinate getCoordinate() {
            return this.polygon.getCoordinate();
        }

        @Override
        public Coordinate[] getCoordinates() {
            return this.polygon.getCoordinates();
        }

        @Override
        public int getDimension() {
            return this.polygon.getDimension();
        }

        @Override
        public Geometry getEnvelope() {
            return this.polygon.getEnvelope();
        }

        @Override
        public Envelope getEnvelopeInternal() {
            return this.polygon.getEnvelopeInternal();
        }

        public LineString getExteriorRing() {
            return this.polygon.getExteriorRing();
        }

        @Override
        public GeometryFactory getFactory() {
            return this.polygon.getFactory();
        }

        @Override
        public Geometry getGeometryN(int n) {
            return this.polygon.getGeometryN(n);
        }

        @Override
        public String getGeometryType() {
            return this.polygon.getGeometryType();
        }

        @Override
        public Point getInteriorPoint() {
            return this.polygon.getInteriorPoint();
        }

        public LineString getInteriorRingN(int n) {
            return this.polygon.getInteriorRingN(n);
        }

        @Override
        public double getLength() {
            return this.polygon.getLength();
        }

        @Override
        public int getNumGeometries() {
            return this.polygon.getNumGeometries();
        }

        public int getNumInteriorRing() {
            return this.polygon.getNumInteriorRing();
        }

        @Override
        public int getNumPoints() {
            return this.polygon.getNumPoints();
        }

        @Override
        public PrecisionModel getPrecisionModel() {
            return this.polygon.getPrecisionModel();
        }

        @Override
        public int getSRID() {
            return this.polygon.getSRID();
        }

        @Override
        public Object getUserData() {
            return this.polygon.getUserData();
        }

        @Override
        public int hashCode() {
            return this.polygon.hashCode();
        }

        @Override
        public Geometry intersection(Geometry other) {
            return this.polygon.intersection(other);
        }

        @Override
        public boolean intersects(Geometry g) {
            return this.polygon.intersects(g);
        }

        @Override
        public boolean isEmpty() {
            return this.polygon.isEmpty();
        }

        @Override
        public boolean isRectangle() {
            return this.polygon.isRectangle();
        }

        @Override
        public boolean isSimple() {
            return this.polygon.isSimple();
        }

        @Override
        public boolean isValid() {
            return this.polygon.isValid();
        }

        @Override
        public boolean isWithinDistance(Geometry geom, double distance) {
            return this.polygon.isWithinDistance(geom, distance);
        }

        @Override
        public void normalize() {
            this.polygon.normalize();
        }

        @Override
        public boolean overlaps(Geometry g) {
            return this.polygon.overlaps(g);
        }

        @Override
        public boolean relate(Geometry g, String intersectionPattern) {
            return this.polygon.relate(g, intersectionPattern);
        }

        @Override
        public IntersectionMatrix relate(Geometry g) {
            return this.polygon.relate(g);
        }

        @Override
        public Geometry reverse() {
            return this.polygon.reverse();
        }

        @Override
        public void setSRID(int SRID) {
            this.polygon.setSRID(SRID);
        }

        @Override
        public void setUserData(Object userData) {
            this.polygon.setUserData(userData);
        }

        @Override
        public Geometry symDifference(Geometry other) {
            return this.polygon.symDifference(other);
        }

        @Override
        public String toString() {
            return this.polygon.toString();
        }

        @Override
        public String toText() {
            return this.polygon.toText();
        }

        @Override
        public boolean touches(Geometry g) {
            return this.polygon.touches(g);
        }

        @Override
        public Geometry union() {
            return this.polygon.union();
        }

        @Override
        public Geometry union(Geometry other) {
            return this.polygon.union(other);
        }

        @Override
        public boolean within(Geometry g) {
            return this.polygon.within(g);
        }
    }

    static class SingleLineCollection
    extends MultiLineString {
        LineString lineString;

        public SingleLineCollection(LineString[] lineStrings, GeometryFactory factory) {
            super(lineStrings, factory);
            this.lineString = lineStrings[0];
        }

        @Override
        public void apply(CoordinateFilter filter) {
            this.lineString.apply(filter);
        }

        @Override
        public void apply(CoordinateSequenceFilter filter) {
            this.lineString.apply(filter);
        }

        @Override
        public void apply(GeometryComponentFilter filter) {
            this.lineString.apply(filter);
        }

        @Override
        public void apply(GeometryFilter filter) {
            this.lineString.apply(filter);
        }

        @Override
        public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
            return this.lineString.buffer(distance, quadrantSegments, endCapStyle);
        }

        @Override
        public Geometry buffer(double distance, int quadrantSegments) {
            return this.lineString.buffer(distance, quadrantSegments);
        }

        @Override
        public Geometry buffer(double distance) {
            return this.lineString.buffer(distance);
        }

        @Override
        public int compareTo(Object o, CoordinateSequenceComparator comp) {
            return this.lineString.compareTo(o, comp);
        }

        @Override
        public int compareTo(Object o) {
            return this.lineString.compareTo(o);
        }

        @Override
        public boolean contains(Geometry g) {
            return this.lineString.contains(g);
        }

        @Override
        public Geometry convexHull() {
            return this.lineString.convexHull();
        }

        @Override
        public boolean coveredBy(Geometry g) {
            return this.lineString.coveredBy(g);
        }

        @Override
        public boolean covers(Geometry g) {
            return this.lineString.covers(g);
        }

        @Override
        public boolean crosses(Geometry g) {
            return this.lineString.crosses(g);
        }

        @Override
        public Geometry difference(Geometry other) {
            return this.lineString.difference(other);
        }

        @Override
        public boolean disjoint(Geometry g) {
            return this.lineString.disjoint(g);
        }

        @Override
        public double distance(Geometry g) {
            return this.lineString.distance(g);
        }

        @Override
        public boolean equals(Geometry g) {
            return this.lineString.equalsTopo(g);
        }

        @Override
        public boolean equals(Object obj) {
            return this.lineString.equals(obj);
        }

        @Override
        public boolean equalsExact(Geometry other, double tolerance) {
            return this.lineString.equalsExact(other, tolerance);
        }

        @Override
        public boolean equalsExact(Geometry other) {
            return this.lineString.equalsExact(other);
        }

        @Override
        public void geometryChanged() {
            this.lineString.geometryChanged();
        }

        @Override
        public double getArea() {
            return this.lineString.getArea();
        }

        @Override
        public Geometry getBoundary() {
            return this.lineString.getBoundary();
        }

        @Override
        public int getBoundaryDimension() {
            return this.lineString.getBoundaryDimension();
        }

        @Override
        public Point getCentroid() {
            return this.lineString.getCentroid();
        }

        @Override
        public Coordinate getCoordinate() {
            return this.lineString.getCoordinate();
        }

        public Coordinate getCoordinateN(int n) {
            return this.lineString.getCoordinateN(n);
        }

        @Override
        public Coordinate[] getCoordinates() {
            return this.lineString.getCoordinates();
        }

        public CoordinateSequence getCoordinateSequence() {
            return this.lineString.getCoordinateSequence();
        }

        @Override
        public int getDimension() {
            return this.lineString.getDimension();
        }

        public Point getEndPoint() {
            return this.lineString.getEndPoint();
        }

        @Override
        public Geometry getEnvelope() {
            return this.lineString.getEnvelope();
        }

        @Override
        public Envelope getEnvelopeInternal() {
            return this.lineString.getEnvelopeInternal();
        }

        @Override
        public GeometryFactory getFactory() {
            return this.lineString.getFactory();
        }

        @Override
        public Geometry getGeometryN(int n) {
            return this.lineString.getGeometryN(n);
        }

        @Override
        public String getGeometryType() {
            return this.lineString.getGeometryType();
        }

        @Override
        public Point getInteriorPoint() {
            return this.lineString.getInteriorPoint();
        }

        @Override
        public double getLength() {
            return this.lineString.getLength();
        }

        @Override
        public int getNumGeometries() {
            return this.lineString.getNumGeometries();
        }

        @Override
        public int getNumPoints() {
            return this.lineString.getNumPoints();
        }

        public Point getPointN(int n) {
            return this.lineString.getPointN(n);
        }

        @Override
        public PrecisionModel getPrecisionModel() {
            return this.lineString.getPrecisionModel();
        }

        @Override
        public int getSRID() {
            return this.lineString.getSRID();
        }

        public Point getStartPoint() {
            return this.lineString.getStartPoint();
        }

        @Override
        public Object getUserData() {
            return this.lineString.getUserData();
        }

        @Override
        public int hashCode() {
            return this.lineString.hashCode();
        }

        @Override
        public Geometry intersection(Geometry other) {
            return this.lineString.intersection(other);
        }

        @Override
        public boolean intersects(Geometry g) {
            return this.lineString.intersects(g);
        }

        @Override
        public boolean isClosed() {
            return this.lineString.isClosed();
        }

        public boolean isCoordinate(Coordinate pt) {
            return this.lineString.isCoordinate(pt);
        }

        @Override
        public boolean isEmpty() {
            return this.lineString.isEmpty();
        }

        @Override
        public boolean isRectangle() {
            return this.lineString.isRectangle();
        }

        public boolean isRing() {
            return this.lineString.isRing();
        }

        @Override
        public boolean isSimple() {
            return this.lineString.isSimple();
        }

        @Override
        public boolean isValid() {
            return this.lineString.isValid();
        }

        @Override
        public boolean isWithinDistance(Geometry geom, double distance) {
            return this.lineString.isWithinDistance(geom, distance);
        }

        @Override
        public void normalize() {
            this.lineString.normalize();
        }

        @Override
        public boolean overlaps(Geometry g) {
            return this.lineString.overlaps(g);
        }

        @Override
        public boolean relate(Geometry g, String intersectionPattern) {
            return this.lineString.relate(g, intersectionPattern);
        }

        @Override
        public IntersectionMatrix relate(Geometry g) {
            return this.lineString.relate(g);
        }

        @Override
        public Geometry reverse() {
            return this.lineString.reverse();
        }

        @Override
        public void setSRID(int SRID) {
            this.lineString.setSRID(SRID);
        }

        @Override
        public void setUserData(Object userData) {
            this.lineString.setUserData(userData);
        }

        @Override
        public Geometry symDifference(Geometry other) {
            return this.lineString.symDifference(other);
        }

        @Override
        public String toString() {
            return this.lineString.toString();
        }

        @Override
        public String toText() {
            return this.lineString.toText();
        }

        @Override
        public boolean touches(Geometry g) {
            return this.lineString.touches(g);
        }

        @Override
        public Geometry union() {
            return this.lineString.union();
        }

        @Override
        public Geometry union(Geometry other) {
            return this.lineString.union(other);
        }

        @Override
        public boolean within(Geometry g) {
            return this.lineString.within(g);
        }
    }

    static class CollectionOfOne
    extends GeometryCollection {
        Geometry geometry;

        public CollectionOfOne(Geometry[] geometries, GeometryFactory factory) {
            super(geometries, factory);
            this.geometry = geometries[0];
        }

        @Override
        public void apply(CoordinateFilter filter) {
            this.geometry.apply(filter);
        }

        @Override
        public void apply(CoordinateSequenceFilter filter) {
            this.geometry.apply(filter);
        }

        @Override
        public void apply(GeometryComponentFilter filter) {
            this.geometry.apply(filter);
        }

        @Override
        public void apply(GeometryFilter filter) {
            this.geometry.apply(filter);
        }

        @Override
        public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
            return this.geometry.buffer(distance, quadrantSegments, endCapStyle);
        }

        @Override
        public Geometry buffer(double distance, int quadrantSegments) {
            return this.geometry.buffer(distance, quadrantSegments);
        }

        @Override
        public Geometry buffer(double distance) {
            return this.geometry.buffer(distance);
        }

        @Override
        public int compareTo(Object o, CoordinateSequenceComparator comp) {
            return this.geometry.compareTo(o, comp);
        }

        @Override
        public int compareTo(Object o) {
            return this.geometry.compareTo(o);
        }

        @Override
        public boolean contains(Geometry g) {
            return this.geometry.contains(g);
        }

        @Override
        public Geometry convexHull() {
            return this.geometry.convexHull();
        }

        @Override
        public boolean coveredBy(Geometry g) {
            return this.geometry.coveredBy(g);
        }

        @Override
        public boolean covers(Geometry g) {
            return this.geometry.covers(g);
        }

        @Override
        public boolean crosses(Geometry g) {
            return this.geometry.crosses(g);
        }

        @Override
        public Geometry difference(Geometry other) {
            return this.geometry.difference(other);
        }

        @Override
        public boolean disjoint(Geometry g) {
            return this.geometry.disjoint(g);
        }

        @Override
        public double distance(Geometry g) {
            return this.geometry.distance(g);
        }

        @Override
        public boolean equals(Geometry g) {
            return this.geometry.equalsTopo(g);
        }

        @Override
        public boolean equals(Object obj) {
            return this.geometry.equals(obj);
        }

        @Override
        public boolean equalsExact(Geometry other, double tolerance) {
            return this.geometry.equalsExact(other, tolerance);
        }

        @Override
        public boolean equalsExact(Geometry other) {
            return this.geometry.equalsExact(other);
        }

        @Override
        public void geometryChanged() {
            this.geometry.geometryChanged();
        }

        @Override
        public double getArea() {
            return this.geometry.getArea();
        }

        @Override
        public Geometry getBoundary() {
            return this.geometry.getBoundary();
        }

        @Override
        public int getBoundaryDimension() {
            return this.geometry.getBoundaryDimension();
        }

        @Override
        public Point getCentroid() {
            return this.geometry.getCentroid();
        }

        @Override
        public Coordinate getCoordinate() {
            return this.geometry.getCoordinate();
        }

        @Override
        public Coordinate[] getCoordinates() {
            return this.geometry.getCoordinates();
        }

        @Override
        public int getDimension() {
            return this.geometry.getDimension();
        }

        @Override
        public Geometry getEnvelope() {
            return this.geometry.getEnvelope();
        }

        @Override
        public Envelope getEnvelopeInternal() {
            return this.geometry.getEnvelopeInternal();
        }

        @Override
        public GeometryFactory getFactory() {
            return this.geometry.getFactory();
        }

        @Override
        public Geometry getGeometryN(int n) {
            return this.geometry.getGeometryN(n);
        }

        @Override
        public String getGeometryType() {
            return this.geometry.getGeometryType();
        }

        @Override
        public Point getInteriorPoint() {
            return this.geometry.getInteriorPoint();
        }

        @Override
        public double getLength() {
            return this.geometry.getLength();
        }

        @Override
        public int getNumGeometries() {
            return this.geometry.getNumGeometries();
        }

        @Override
        public int getNumPoints() {
            return this.geometry.getNumPoints();
        }

        @Override
        public PrecisionModel getPrecisionModel() {
            return this.geometry.getPrecisionModel();
        }

        @Override
        public int getSRID() {
            return this.geometry.getSRID();
        }

        @Override
        public Object getUserData() {
            return this.geometry.getUserData();
        }

        @Override
        public int hashCode() {
            return this.geometry.hashCode();
        }

        @Override
        public Geometry intersection(Geometry other) {
            return this.geometry.intersection(other);
        }

        @Override
        public boolean intersects(Geometry g) {
            return this.geometry.intersects(g);
        }

        @Override
        public boolean isEmpty() {
            return this.geometry.isEmpty();
        }

        @Override
        public boolean isRectangle() {
            return this.geometry.isRectangle();
        }

        @Override
        public boolean isSimple() {
            return this.geometry.isSimple();
        }

        @Override
        public boolean isValid() {
            return this.geometry.isValid();
        }

        @Override
        public boolean isWithinDistance(Geometry geom, double distance) {
            return this.geometry.isWithinDistance(geom, distance);
        }

        @Override
        public void normalize() {
            this.geometry.normalize();
        }

        @Override
        public boolean overlaps(Geometry g) {
            return this.geometry.overlaps(g);
        }

        @Override
        public boolean relate(Geometry g, String intersectionPattern) {
            return this.geometry.relate(g, intersectionPattern);
        }

        @Override
        public IntersectionMatrix relate(Geometry g) {
            return this.geometry.relate(g);
        }

        @Override
        public Geometry reverse() {
            return this.geometry.reverse();
        }

        @Override
        public void setSRID(int SRID) {
            this.geometry.setSRID(SRID);
        }

        @Override
        public void setUserData(Object userData) {
            this.geometry.setUserData(userData);
        }

        @Override
        public Geometry symDifference(Geometry other) {
            return this.geometry.symDifference(other);
        }

        @Override
        public String toString() {
            return this.geometry.toString();
        }

        @Override
        public String toText() {
            return this.geometry.toText();
        }

        @Override
        public boolean touches(Geometry g) {
            return this.geometry.touches(g);
        }

        @Override
        public Geometry union() {
            return this.geometry.union();
        }

        @Override
        public Geometry union(Geometry other) {
            return this.geometry.union(other);
        }

        @Override
        public boolean within(Geometry g) {
            return this.geometry.within(g);
        }
    }
}

