/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.data.FeatureSource;
import org.geotools.data.sort.SortedFeatureReader;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.renderer.lite.LiteFeatureTypeStyle;
import org.geotools.renderer.lite.MarkFeatureIterator;
import org.geotools.renderer.lite.SortKey;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.lite.ZGroupLayerPainter;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Style;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.util.DefaultProgressListener;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.ProgressListener;

class ZGroupLayer
extends Layer {
    private String groupId;
    private List<Layer> layers = new ArrayList<Layer>();
    private boolean compositingBase = false;
    private Composite composite;

    public ZGroupLayer(String groupId, FeatureLayer layer) {
        this.groupId = groupId;
        this.addLayer(layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawFeatures(Graphics2D graphics, final StreamingRenderer renderer, String layerId) throws IOException, FactoryException, NoninvertibleTransformException, SchemaException, TransformException {
        block14: {
            List<ZGroupLayerPainter> painters;
            block12: {
                block13: {
                    DefaultProgressListener cancellationListener = new DefaultProgressListener(){

                        @Override
                        public boolean isCanceled() {
                            return renderer.renderingStopRequested;
                        }
                    };
                    painters = null;
                    painters = this.buildLayerPainters(graphics, renderer, layerId, cancellationListener);
                    if (!painters.isEmpty()) break block12;
                    if (painters == null) break block13;
                    for (ZGroupLayerPainter painter : painters) {
                        painter.close();
                    }
                }
                return;
            }
            try {
                SortKey.Comparator comparator = SortKey.buildComparator(painters.get((int)0).sortBy);
                SortKey previousKey = null;
                while (!painters.isEmpty()) {
                    SortKey smallestKey = this.getSmallestKey(painters, comparator);
                    if (previousKey == null) {
                        previousKey = smallestKey;
                    } else {
                        if (comparator.compare(previousKey, smallestKey) >= 0) {
                            throw new IllegalStateException("The sorted rendering moved from a set of sort attributes, to one that's equal or greater, this is unexpected, bailing out to avoid an infinite loop");
                        }
                        previousKey = smallestKey;
                    }
                    Iterator<ZGroupLayerPainter> it = painters.iterator();
                    while (it.hasNext()) {
                        ZGroupLayerPainter painter = it.next();
                        painter.paintKey(smallestKey);
                        if (!painter.complete()) continue;
                        painter.close();
                        it.remove();
                    }
                }
                if (painters == null) break block14;
            }
            catch (Throwable throwable) {
                if (painters != null) {
                    for (ZGroupLayerPainter painter : painters) {
                        painter.close();
                    }
                }
                throw throwable;
            }
            for (ZGroupLayerPainter painter : painters) {
                painter.close();
            }
        }
    }

    private SortKey getSmallestKey(List<ZGroupLayerPainter> painters, Comparator<SortKey> comparator) {
        SortKey smallest = null;
        for (ZGroupLayerPainter painter : painters) {
            SortKey key = painter.getCurrentKey();
            if (smallest == null) {
                smallest = key;
                continue;
            }
            if (comparator.compare(key, smallest) >= 0) continue;
            smallest = key;
        }
        return new SortKey(smallest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ZGroupLayerPainter> buildLayerPainters(Graphics2D graphics, StreamingRenderer renderer, String layerId, ProgressListener cancellationListener) throws IOException, FactoryException, NoninvertibleTransformException, SchemaException, TransformException {
        ArrayList<ZGroupLayerPainter> painters = new ArrayList<ZGroupLayerPainter>();
        boolean closePainters = true;
        try {
            for (Layer layer : this.layers) {
                int maxFeatures;
                FeatureCollection features;
                MarkFeatureIterator fi;
                FeatureSource<?, ?> featureSource = layer.getFeatureSource();
                if (featureSource == null) {
                    throw new IllegalArgumentException("The layer does not contain a feature source");
                }
                Object schema = featureSource.getSchema();
                ArrayList<LiteFeatureTypeStyle> lfts = renderer.createLiteFeatureTypeStyles(layer, graphics, false);
                if (lfts.isEmpty()) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Processing " + lfts.size() + " stylers for " + schema.getName());
                }
                if ((fi = MarkFeatureIterator.create(features = renderer.getFeatures(layer, (FeatureType)schema, (List<LiteFeatureTypeStyle>)lfts), maxFeatures = SortedFeatureReader.getMaxFeaturesInMemory(layer.getQuery()), cancellationListener)).hasNext()) {
                    ZGroupLayerPainter painter = new ZGroupLayerPainter(fi, lfts, renderer, layerId);
                    painters.add(painter);
                    continue;
                }
                fi.close();
            }
            this.validateSortBy(painters);
            closePainters = false;
        }
        finally {
            if (closePainters) {
                for (ZGroupLayerPainter painter : painters) {
                    try {
                        painter.close();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Failed to close cleanly layer painter " + painter, e);
                    }
                }
            }
        }
        return painters;
    }

    private void validateSortBy(List<ZGroupLayerPainter> painters) {
        Class[] referenceClasses = null;
        SortOrder[] referenceOrders = null;
        LiteFeatureTypeStyle reference = null;
        for (ZGroupLayerPainter painter : painters) {
            for (LiteFeatureTypeStyle style : painter.lfts) {
                int i;
                Class[] styleClasses = this.getSortByAttributeClasses(style);
                SortOrder[] styleOrders = this.getSortOrders(style);
                if (referenceClasses == null) {
                    referenceClasses = styleClasses;
                    referenceOrders = styleOrders;
                    reference = style;
                    for (i = 0; i < referenceClasses.length; ++i) {
                        if (Comparable.class.isAssignableFrom(referenceClasses[i])) continue;
                        throw new IllegalArgumentException("Found non comparable attribute in z group " + this.groupId + ": " + this.sortByToString(style, this.getSortByAttributeClasses(style)) + " at position " + (i + 1));
                    }
                    continue;
                }
                if (styleClasses.length != referenceClasses.length) {
                    throw new IllegalArgumentException("Found two sortBy clauses with different number of attributes in group " + this.groupId + ": " + this.sortByToString(reference, referenceClasses) + " vs " + this.sortByToString(style, styleClasses));
                }
                for (i = 0; i < styleClasses.length; ++i) {
                    Class currClass = styleClasses[i];
                    Class referenceClass = referenceClasses[i];
                    if (!(currClass.equals(referenceClass) || currClass.isAssignableFrom(referenceClass) || referenceClass.isAssignableFrom(currClass))) {
                        throw new IllegalArgumentException("Found two incompatible classes at position " + (i + 1) + " of the sortBy clauses in group " + this.groupId + ": " + this.sortByToString(reference, referenceClasses) + " vs " + this.sortByToString(style, styleClasses));
                    }
                    SortOrder currOrder = styleOrders[i];
                    SortOrder referenceOrder = referenceOrders[i];
                    if (currOrder.equals((Object)referenceOrder)) continue;
                    throw new IllegalArgumentException("Found two different sort orders at position " + (i + 1) + " of the sortBy clauses in group " + this.groupId + ": " + this.sortByToString(reference, referenceClasses) + " vs " + this.sortByToString(style, styleClasses));
                }
            }
        }
    }

    private Class[] getSortByAttributeClasses(LiteFeatureTypeStyle style) {
        SortBy[] sb = style.sortBy;
        Object schema = style.layer.getFeatureSource().getSchema();
        Class[] classes = new Class[sb.length];
        for (int i = 0; i < classes.length; ++i) {
            PropertyName property = sb[i].getPropertyName();
            if (property == null) {
                classes[i] = String.class;
                continue;
            }
            PropertyDescriptor pd = (PropertyDescriptor)property.evaluate(schema, null);
            if (pd == null) {
                throw new IllegalArgumentException("Property " + property + " could not be found in feature type " + schema.getName() + " in layer " + style.layer.getTitle());
            }
            classes[i] = pd.getType().getBinding();
        }
        return classes;
    }

    private SortOrder[] getSortOrders(LiteFeatureTypeStyle style) {
        SortBy[] sb = style.sortBy;
        SortOrder[] orders = new SortOrder[sb.length];
        for (int i = 0; i < orders.length; ++i) {
            orders[i] = sb[i].getSortOrder();
        }
        return orders;
    }

    private String sortByToString(LiteFeatureTypeStyle style, Class[] classes) {
        StringBuilder sb = new StringBuilder("Layer ").append(style.layer.getTitle()).append("[");
        SortBy[] sortBy = style.sortBy;
        for (int i = 0; i < sortBy.length; ++i) {
            SortBy curr = sortBy[i];
            if (curr == SortBy.NATURAL_ORDER) {
                sb.append("NaturalOrder");
            } else if (curr == SortBy.REVERSE_ORDER) {
                sb.append("ReverseNaturalOrder");
            } else {
                sb.append(curr.getPropertyName().getPropertyName());
                sb.append("(").append(classes[i].getSimpleName()).append(")");
                if (curr.getSortOrder() == SortOrder.DESCENDING) {
                    sb.append(" D");
                }
            }
            if (i >= sortBy.length) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return null;
    }

    public boolean isCompositingBase() {
        return this.compositingBase;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void addLayer(FeatureLayer layer) {
        List<FeatureTypeStyle> featureTypeStyles = layer.getStyle().featureTypeStyles();
        boolean cleanupStyle = false;
        for (FeatureTypeStyle fts : featureTypeStyles) {
            Composite composite;
            Map<String, String> options = fts.getOptions();
            String compositingBaseDefinition = options.get("composite-base");
            if ("true".equalsIgnoreCase(compositingBaseDefinition)) {
                this.compositingBase = true;
            }
            if ((composite = SLDStyleFactory.getComposite(options)) == null) continue;
            this.composite = composite;
            cleanupStyle = true;
        }
        if (cleanupStyle) {
            DuplicatingStyleVisitor cleaner = new DuplicatingStyleVisitor(){

                @Override
                public void visit(FeatureTypeStyle fts) {
                    super.visit(fts);
                    FeatureTypeStyle copy = (FeatureTypeStyle)this.pages.peek();
                    copy.getOptions().remove("composite");
                    copy.getOptions().remove("composite-base");
                }
            };
            layer.getStyle().accept(cleaner);
            Style cleaned = (Style)cleaner.getCopy();
            layer.setStyle(cleaned);
        }
        this.layers.add(layer);
    }
}

