/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.composite.BlendComposite;
import org.opengis.coverage.grid.GridCoverage;

class Compositing {
    private static final Composite DEFAULT_COMPOSITE = BlendComposite.getInstance(BlendComposite.BlendingMode.MULTIPLY, 1.0f);
    private static final AffineTransform IDENTITY = AffineTransform2D.getTranslateInstance((double)0.0, (double)0.0);
    private RenderedImage compositingImage;
    private Composite composite;

    public Compositing(RenderedImage compositingImage) {
        this.compositingImage = compositingImage;
        this.composite = DEFAULT_COMPOSITE;
    }

    public GridCoverage2D composeGridCoverage(GridCoverage2D source, GridCoverageFactory factory) {
        if (this.compositingImage != null) {
            RenderedImage applyImage = Compositing.forceToRGB(this.compositingImage, true);
            RenderedImage sourceImage = Compositing.forceToRGB(source.getRenderedImage(), true);
            BufferedImage composedImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceImage).getAsBufferedImage();
            Graphics2D graphics = composedImage.createGraphics();
            graphics.setComposite(this.composite);
            int minX = sourceImage.getMinX();
            int minY = sourceImage.getMinY();
            AffineTransform transform = IDENTITY;
            boolean translate = false;
            if (minX != 0 || minY != 0) {
                transform = AffineTransform2D.getTranslateInstance((double)(-minX), (double)(-minY));
                translate = true;
            }
            graphics.drawRenderedImage(applyImage, transform);
            int numBands = composedImage.getSampleModel().getNumBands();
            GridSampleDimension[] sd = new GridSampleDimension[numBands];
            for (int i = 0; i < numBands; ++i) {
                sd[i] = new GridSampleDimension((CharSequence)TypeMap.getColorInterpretation((ColorModel)composedImage.getColorModel(), (int)i).name());
            }
            RenderedImage gridCoverageImage = composedImage;
            if (translate) {
                AffineTransform tx = AffineTransform2D.getTranslateInstance((double)minX, (double)minY);
                ImageWorker worker = new ImageWorker((RenderedImage)composedImage).affine(tx, Interpolation.getInstance((int)0), null);
                gridCoverageImage = worker.getRenderedImage();
                gridCoverageImage.getMinX();
            }
            return factory.create((CharSequence)source.getName().toString(), gridCoverageImage, source.getGridGeometry(), sd, new GridCoverage[]{source}, source.getProperties());
        }
        return source;
    }

    public static RenderedImage forceToRGB(RenderedImage finalImage, boolean asByte) {
        if (finalImage != null) {
            SampleModel sm = finalImage.getSampleModel();
            int sampleSize = sm.getSampleSize(0);
            ImageWorker iw = new ImageWorker(finalImage);
            if (sampleSize > 8 && asByte) {
                iw = iw.rescaleToBytes();
                finalImage = iw.getRenderedImage();
            }
            ColorModel cm = finalImage.getColorModel();
            int numComponents = cm.getNumComponents();
            if (!(cm instanceof ComponentColorModel) || numComponents < 3) {
                iw = cm instanceof IndexColorModel ? iw.forceComponentColorModel() : iw.bandMerge(3);
                iw = iw.forceColorSpaceRGB();
                finalImage = iw.getRenderedImage();
            }
        }
        return finalImage;
    }
}

