/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.lookup.LookupTableFactory;
import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.PiecewiseTransform1D;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.factory.Hints;
import org.geotools.image.ImageWorker;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.ContrastEnhancementType;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.StyleVisitorCoverageProcessingNodeAdapter;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.styling.AbstractContrastMethodStrategy;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.ExponentialContrastMethodStrategy;
import org.geotools.styling.HistogramContrastMethodStrategy;
import org.geotools.styling.LogarithmicContrastMethodStrategy;
import org.geotools.styling.NormalizeContrastMethodStrategy;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ContrastMethod;
import org.opengis.util.InternationalString;

class ContrastEnhancementNode
extends StyleVisitorCoverageProcessingNodeAdapter
implements StyleVisitor,
CoverageProcessingNode {
    private static final Set<String> SUPPORTED_HE_ALGORITHMS;
    AbstractContrastMethodStrategy contrastEnhancementMethod = null;
    private String type = null;
    private double gammaValue = Double.NaN;

    @Override
    public InternationalString getName() {
        return Vocabulary.formatInternational(6);
    }

    @Override
    public void visit(ContrastEnhancement ce) {
        Number number;
        Expression gamma;
        String type;
        if (ce == null) {
            return;
        }
        ContrastMethod contrastMethod = ce.getMethod();
        if (contrastMethod != null && (type = contrastMethod.name()) != null && !type.equalsIgnoreCase("None")) {
            this.type = type.toUpperCase();
            if (!SUPPORTED_HE_ALGORITHMS.contains(type.toUpperCase())) {
                throw new IllegalArgumentException(Errors.format(11, type.toUpperCase()));
            }
            this.contrastEnhancementMethod = this.parseContrastEnhancementMethod(contrastMethod, ce.getOptions());
        }
        if ((gamma = ce.getGammaValue()) != null && (number = (Number)gamma.evaluate(null, Double.class)) != null) {
            this.gammaValue = number.doubleValue();
            if (this.gammaValue < 0.0) {
                throw new IllegalArgumentException(Errors.format(10, "Gamma", number));
            }
            if (Double.isNaN(this.gammaValue) || Double.isInfinite(this.gammaValue)) {
                throw new IllegalArgumentException(Errors.format(10, "Gamma", number));
            }
        }
    }

    private AbstractContrastMethodStrategy parseContrastEnhancementMethod(ContrastMethod method, Map<String, Expression> options) {
        String name = method.name().toUpperCase();
        AbstractContrastMethodStrategy ceMethod = null;
        if ("NORMALIZE".equals(name)) {
            Expression algorithm = options.get("algorithm");
            ceMethod = new NormalizeContrastMethodStrategy();
            if (algorithm != null) {
                ceMethod.setAlgorithm(algorithm);
            }
        } else if ("LOGARITHMIC".equalsIgnoreCase(name)) {
            ceMethod = new LogarithmicContrastMethodStrategy();
        } else if ("EXPONENTIAL".equalsIgnoreCase(name)) {
            ceMethod = new ExponentialContrastMethodStrategy();
        } else if ("HISTOGRAM".equalsIgnoreCase(name)) {
            ceMethod = new HistogramContrastMethodStrategy();
        } else {
            throw new IllegalArgumentException(Errors.format(17, method));
        }
        ceMethod.setOptions(options);
        return ceMethod;
    }

    public ContrastEnhancementNode() {
        this((Hints)null);
    }

    public ContrastEnhancementNode(Hints hints) {
        super(1, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)"ContrastEnhancementNode"), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Node which applies ContrastEnhancement following SLD 1.0 spec."));
    }

    protected GridCoverage2D execute() {
        Hints hints = this.getHints();
        List<CoverageProcessingNode> sources = this.getSources();
        if (sources != null && !sources.isEmpty()) {
            GridCoverage2D output;
            GridCoverage2D source = (GridCoverage2D)this.getSource(0).getOutput();
            GridCoverageRendererUtilities.ensureSourceNotNull(source, this.getName().toString());
            if (!Double.isNaN(this.gammaValue) && !Double.isInfinite(this.gammaValue) && !(Math.abs(this.gammaValue - 1.0) < 1.0E-6) || this.type != null && this.type.length() > 0) {
                boolean intensity;
                ImageWorker intensityWorker;
                RenderedImage sourceImage = source.getRenderedImage();
                ROI roi = CoverageUtilities.getROIProperty((GridCoverage2D)source);
                NoDataContainer noDataContainer = CoverageUtilities.getNoDataProperty((GridCoverage2D)source);
                Range nodata = noDataContainer != null ? noDataContainer.getAsRange() : null;
                ImageWorker worker = this.type != null && this.type.equalsIgnoreCase("HISTOGRAM") ? new ImageWorker(sourceImage).setROI(roi).setNoData(nodata).setRenderingHints((RenderingHints)hints).forceComponentColorModel().rescaleToBytes() : new ImageWorker(sourceImage).setROI(roi).setNoData(nodata).setRenderingHints((RenderingHints)hints).forceComponentColorModel();
                int numbands = worker.getNumBands();
                RenderedImage alphaBand = null;
                if (numbands % 2 == 0) {
                    alphaBand = new ImageWorker(worker.getRenderedImage()).setRenderingHints((RenderingHints)hints).retainLastBand().getRenderedImage();
                    worker.setRenderingHints((RenderingHints)hints).retainBands(numbands - 1);
                }
                RenderedImage hChannel = null;
                RenderedImage sChannel = null;
                RenderedImage IHS = null;
                if (numbands > 1) {
                    IHS = worker.setRenderingHints((RenderingHints)hints).forceColorSpaceIHS().getRenderedImage();
                    intensityWorker = worker.setRenderingHints((RenderingHints)hints).retainFirstBand();
                    sChannel = new ImageWorker(IHS).setRenderingHints((RenderingHints)hints).retainLastBand().getRenderedImage();
                    hChannel = new ImageWorker(IHS).setRenderingHints((RenderingHints)hints).retainBands(new int[]{1}).getRenderedImage();
                    intensity = true;
                } else {
                    intensityWorker = worker;
                    intensity = false;
                }
                this.performContrastEnhancement(intensityWorker, hints);
                this.performGammaCorrection(intensityWorker, hints);
                if (intensity) {
                    ImageLayout imageLayout = new ImageLayout();
                    imageLayout.setColorModel(IHS.getColorModel());
                    imageLayout.setSampleModel(IHS.getSampleModel());
                    RenderingHints rendHints = new RenderingHints(Collections.EMPTY_MAP);
                    rendHints.add((RenderingHints)hints);
                    rendHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
                    intensityWorker.setRenderingHints(rendHints).addBands(new RenderedImage[]{hChannel, sChannel}, false, null);
                    intensityWorker.setRenderingHints((RenderingHints)hints).forceColorSpaceRGB();
                }
                if (alphaBand != null) {
                    int[] nArray;
                    ColorSpace colorSpace = numbands >= 3 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003);
                    if (numbands >= 3) {
                        int[] nArray2 = new int[4];
                        nArray2[0] = 8;
                        nArray2[1] = 8;
                        nArray2[2] = 8;
                        nArray = nArray2;
                        nArray2[3] = 8;
                    } else {
                        int[] nArray3 = new int[2];
                        nArray3[0] = 8;
                        nArray = nArray3;
                        nArray3[1] = 8;
                    }
                    ComponentColorModel cm = new ComponentColorModel(colorSpace, nArray, true, false, 3, 0);
                    ImageLayout imageLayout = new ImageLayout();
                    imageLayout.setColorModel((ColorModel)cm);
                    imageLayout.setSampleModel(((ColorModel)cm).createCompatibleSampleModel(intensityWorker.getRenderedImage().getWidth(), intensityWorker.getRenderedImage().getHeight()));
                    intensityWorker.setRenderingHints((RenderingHints)hints).setRenderingHint(JAI.KEY_IMAGE_LAYOUT, (Object)imageLayout).addBand(alphaBand, false, true, null);
                }
                int numSourceBands = source.getNumSampleDimensions();
                RenderedImage finalImage = intensityWorker.getRenderedImage();
                int numActualBands = finalImage.getSampleModel().getNumBands();
                GridCoverageFactory factory = this.getCoverageFactory();
                HashMap<String, Object> props = new HashMap<String, Object>();
                if (source.getProperties() != null) {
                    props.putAll(source.getProperties());
                }
                if (intensityWorker.getNoData() != null) {
                    props.put("GC_NODATA", new NoDataContainer(intensityWorker.getNoData()));
                }
                if (intensityWorker.getROI() != null) {
                    props.put("GC_ROI", intensityWorker.getROI());
                }
                if (numActualBands == numSourceBands) {
                    String name = "ce_coverage" + source.getName();
                    output = factory.create((CharSequence)name, finalImage, source.getGridGeometry(), source.getSampleDimensions(), new GridCoverage[]{source}, props);
                } else {
                    GridSampleDimension[] sd = new GridSampleDimension[numActualBands];
                    for (int i = 0; i < numActualBands; ++i) {
                        sd[i] = source.getSampleDimension(0);
                    }
                    output = factory.create((CharSequence)("ce_coverage" + source.getName().toString()), finalImage, source.getGridGeometry(), sd, new GridCoverage[]{source}, props);
                }
            } else {
                output = source;
            }
            return output;
        }
        throw new IllegalStateException(Errors.format(3, this.getName().toString()));
    }

    private RenderedImage performContrastEnhancement(ImageWorker inputWorker, Hints hints) {
        inputWorker.setRenderingHints((RenderingHints)hints);
        if (this.contrastEnhancementMethod != null) {
            RenderedImage inputImage = inputWorker.getRenderedImage();
            assert (inputImage.getSampleModel().getNumBands() == 1) : inputImage;
            ContrastEnhancementType ceType = ContrastEnhancementType.getType(this.contrastEnhancementMethod);
            return ceType.process(inputWorker, hints, this.contrastEnhancementMethod.getParameters());
        }
        return inputWorker.getRenderedImage();
    }

    private RenderedImage performGammaCorrection(ImageWorker worker, Hints hints) {
        worker.setRenderingHints((RenderingHints)hints);
        RenderedOp inputImage = worker.getRenderedOperation();
        assert (inputImage.getSampleModel().getNumBands() == 1) : inputImage;
        int dataType = inputImage.getSampleModel().getDataType();
        Object result = inputImage;
        if (!Double.isNaN(this.gammaValue) && Math.abs(this.gammaValue - 1.0) > 1.0E-6) {
            if (dataType == 0) {
                byte[] lut = new byte[256];
                for (int i = 1; i < lut.length; ++i) {
                    lut[i] = (byte)(255.0 * Math.pow((double)i / 255.0, this.gammaValue) + 0.5);
                }
                LookupTable table = LookupTableFactory.create((byte[])lut, (int)dataType);
                worker.lookup(table);
            } else {
                double[] minimum = worker.getMinimums();
                double[] maximum = worker.getMaximums();
                PiecewiseTransform1D<DefaultPiecewiseTransform1DElement> transform = ContrastEnhancementType.generateGammaCorrectedPiecewise(minimum[0], maximum[0], this.gammaValue);
                worker.piecewise(transform, Integer.valueOf(0));
            }
        }
        result = worker.getRenderedImage();
        assert (result.getSampleModel().getNumBands() == 1) : result;
        return result;
    }

    public String getType() {
        return this.type;
    }

    static {
        HashSet<String> heAlg = new HashSet<String>(2, 1.0f);
        heAlg.add("NORMALIZE");
        heAlg.add("HISTOGRAM");
        heAlg.add("LOGARITHMIC");
        heAlg.add("EXPONENTIAL");
        SUPPORTED_HE_ALGORITHMS = Collections.unmodifiableSet(heAlg);
    }
}

