/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Composite;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.geotools.geometry.jts.TransformedShape;
import org.geotools.renderer.style.PointStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.resources.Classes;

public class MarkStyle2D
extends PolygonStyle2D
implements PointStyle2D {
    static boolean maxMarkSizeEnabled = Boolean.getBoolean("org.geotools.maxMarkSizeEnabled");
    Shape shape;
    double size;
    float rotation;
    float displacementX;
    float displacementY;
    float anchorPointX = 0.5f;
    float anchorPointY = 0.5f;
    Composite composite;

    @Override
    public float getRotation() {
        return this.rotation;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Shape getTransformedShape(float x, float y) {
        return this.getTransformedShape(x, y, 0.0f, this.rotation);
    }

    public Shape getTransformedShape(float x, float y, float baseRotation, float rotation) {
        if (this.shape != null) {
            Rectangle2D bounds = this.shape.getBounds2D();
            double shapeSize = maxMarkSizeEnabled ? Math.max(bounds.getWidth(), bounds.getHeight()) : bounds.getHeight();
            double scale = this.size / shapeSize;
            TransformedShape ts = new TransformedShape();
            ts.shape = this.shape;
            float dx = this.displacementX;
            float dy = this.displacementY;
            if (baseRotation != 0.0f) {
                ts.translate(x, y);
                ts.rotate(baseRotation);
                ts.translate(dx, dy);
            } else {
                ts.translate(x + dx, y + dy);
            }
            ts.rotate(rotation);
            dx = (float)(bounds.getWidth() * scale * (0.5 - (double)this.anchorPointX));
            dy = (float)(bounds.getHeight() * scale * ((double)this.anchorPointY - 0.5));
            ts.translate(dx, dy);
            ts.scale(scale, -scale);
            return ts;
        }
        return null;
    }

    public double getSize() {
        return this.size;
    }

    @Override
    public void setRotation(float f) {
        this.rotation = f;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void setSize(double i) {
        this.size = i;
    }

    @Override
    public String toString() {
        return Classes.getShortClassName((Object)this) + '[' + this.shape + ']';
    }

    public static boolean isMaxMarkSizeEnabled() {
        return maxMarkSizeEnabled;
    }

    public static void setMaxMarkSizeEnabled(boolean useMaxMarkSize) {
        maxMarkSizeEnabled = useMaxMarkSize;
    }

    @Override
    public float getDisplacementX() {
        return this.displacementX;
    }

    @Override
    public void setDisplacementX(float displacementX) {
        this.displacementX = displacementX;
    }

    @Override
    public float getDisplacementY() {
        return this.displacementY;
    }

    @Override
    public void setDisplacementY(float displacementY) {
        this.displacementY = displacementY;
    }

    @Override
    public float getAnchorPointX() {
        return this.anchorPointX;
    }

    @Override
    public void setAnchorPointX(float anchorPointX) {
        this.anchorPointX = anchorPointX;
    }

    @Override
    public float getAnchorPointY() {
        return this.anchorPointY;
    }

    @Override
    public void setAnchorPointY(float anchorPointY) {
        this.anchorPointY = anchorPointY;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setComposite(Composite composite) {
        this.composite = composite;
    }
}

