/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Set;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UserLayer;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class StyleAttributeExtractor
extends FilterAttributeExtractor
implements StyleVisitor {
    boolean defaultGeometryUsed = false;
    boolean symbolizerGeometriesVisitEnabled = true;

    public Set<PropertyName> getAttributes() {
        return Collections.unmodifiableSet(this.propertyNames);
    }

    public boolean isSymbolizerGeometriesVisitEnabled() {
        return this.symbolizerGeometriesVisitEnabled;
    }

    public void setSymbolizerGeometriesVisitEnabled(boolean symbolizerGeometriesVisitEnabled) {
        this.symbolizerGeometriesVisitEnabled = symbolizerGeometriesVisitEnabled;
    }

    public boolean getDefaultGeometryUsed() {
        return this.defaultGeometryUsed;
    }

    @Override
    public void visit(Style style) {
        FeatureTypeStyle[] ftStyles = style.getFeatureTypeStyles();
        for (int i = 0; i < ftStyles.length; ++i) {
            ftStyles[i].accept(this);
        }
    }

    @Override
    public void visit(Rule rule) {
        Graphic[] legendGraphics;
        Symbolizer[] symbolizers;
        Filter filter = rule.getFilter();
        if (filter != null) {
            filter.accept((FilterVisitor)this, null);
        }
        if ((symbolizers = rule.getSymbolizers()) != null) {
            for (int i = 0; i < symbolizers.length; ++i) {
                Symbolizer symbolizer = symbolizers[i];
                symbolizer.accept(this);
            }
        }
        if ((legendGraphics = rule.getLegendGraphic()) != null) {
            // empty if block
        }
    }

    @Override
    public void visit(FeatureTypeStyle fts) {
        Rule[] rules = fts.getRules();
        for (int i = 0; i < rules.length; ++i) {
            Rule rule = rules[i];
            rule.accept(this);
        }
    }

    @Override
    public void visit(Fill fill) {
        if (fill.getBackgroundColor() != null) {
            fill.getBackgroundColor().accept((ExpressionVisitor)this, null);
        }
        if (fill.getColor() != null) {
            fill.getColor().accept((ExpressionVisitor)this, null);
        }
        if (fill.getGraphicFill() != null) {
            fill.getGraphicFill().accept(this);
        }
        if (fill.getOpacity() != null) {
            fill.getOpacity().accept((ExpressionVisitor)this, null);
        }
    }

    @Override
    public void visit(Stroke stroke) {
        if (stroke.getColor() != null) {
            stroke.getColor().accept((ExpressionVisitor)this, null);
        }
        if (stroke.getDashOffset() != null) {
            stroke.getDashOffset().accept((ExpressionVisitor)this, null);
        }
        if (stroke.getGraphicFill() != null) {
            stroke.getGraphicFill().accept(this);
        }
        if (stroke.getGraphicStroke() != null) {
            stroke.getGraphicStroke().accept(this);
        }
        if (stroke.getLineCap() != null) {
            stroke.getLineCap().accept((ExpressionVisitor)this, null);
        }
        if (stroke.getLineJoin() != null) {
            stroke.getLineJoin().accept((ExpressionVisitor)this, null);
        }
        if (stroke.getOpacity() != null) {
            stroke.getOpacity().accept((ExpressionVisitor)this, null);
        }
        if (stroke.getWidth() != null) {
            stroke.getWidth().accept((ExpressionVisitor)this, null);
        }
        if (stroke.dashArray() != null) {
            for (Expression expression : stroke.dashArray()) {
                expression.accept((ExpressionVisitor)this, null);
            }
        }
    }

    @Override
    public void visit(Symbolizer sym) {
        if (sym instanceof PointSymbolizer) {
            this.visit((PointSymbolizer)sym);
        }
        if (sym instanceof LineSymbolizer) {
            this.visit((LineSymbolizer)sym);
        }
        if (sym instanceof PolygonSymbolizer) {
            this.visit((PolygonSymbolizer)sym);
        }
        if (sym instanceof TextSymbolizer) {
            this.visit((TextSymbolizer)sym);
        }
        if (sym instanceof RasterSymbolizer) {
            this.visit((RasterSymbolizer)sym);
        }
    }

    @Override
    public void visit(RasterSymbolizer rs) {
        if (this.symbolizerGeometriesVisitEnabled && rs.getGeometry() != null) {
            rs.getGeometry().accept((ExpressionVisitor)this, null);
        }
        if (rs.getImageOutline() != null) {
            rs.getImageOutline().accept(this);
        }
        if (rs.getOpacity() != null) {
            rs.getOpacity().accept((ExpressionVisitor)this, null);
        }
    }

    @Override
    public void visit(PointSymbolizer ps) {
        if (this.symbolizerGeometriesVisitEnabled) {
            if (ps.getGeometry() != null) {
                ps.getGeometry().accept((ExpressionVisitor)this, null);
            } else {
                this.defaultGeometryUsed = true;
            }
        }
        if (ps.getGraphic() != null) {
            ps.getGraphic().accept(this);
        }
    }

    @Override
    public void visit(LineSymbolizer line) {
        if (this.symbolizerGeometriesVisitEnabled) {
            if (line.getGeometry() != null) {
                line.getGeometry().accept((ExpressionVisitor)this, null);
            } else {
                this.defaultGeometryUsed = true;
            }
        }
        if (line.getPerpendicularOffset() != null) {
            line.getPerpendicularOffset().accept((ExpressionVisitor)this, null);
        }
        if (line.getStroke() != null) {
            line.getStroke().accept(this);
        }
    }

    @Override
    public void visit(PolygonSymbolizer poly) {
        if (this.symbolizerGeometriesVisitEnabled) {
            if (poly.getGeometry() != null) {
                poly.getGeometry().accept((ExpressionVisitor)this, null);
            } else {
                this.defaultGeometryUsed = true;
            }
        }
        if (poly.getStroke() != null) {
            poly.getStroke().accept(this);
        }
        if (poly.getFill() != null) {
            poly.getFill().accept(this);
        }
    }

    @Override
    public void visit(TextSymbolizer text) {
        if (this.symbolizerGeometriesVisitEnabled) {
            if (text.getGeometry() != null) {
                text.getGeometry().accept((ExpressionVisitor)this, null);
            } else {
                this.defaultGeometryUsed = true;
            }
        }
        if (text instanceof TextSymbolizer2 && ((TextSymbolizer2)text).getGraphic() != null) {
            ((TextSymbolizer2)text).getGraphic().accept(this);
        }
        if (text.getFill() != null) {
            text.getFill().accept(this);
        }
        if (text.getHalo() != null) {
            text.getHalo().accept(this);
        }
        if (text.fonts() != null) {
            for (Font font : text.fonts()) {
                if (font.getFamily() != null) {
                    for (Expression list : font.getFamily()) {
                        list.accept((ExpressionVisitor)this, null);
                    }
                }
                if (font.getSize() != null) {
                    font.getSize().accept((ExpressionVisitor)this, null);
                }
                if (font.getStyle() != null) {
                    font.getStyle().accept((ExpressionVisitor)this, null);
                }
                if (font.getWeight() == null) continue;
                font.getWeight().accept((ExpressionVisitor)this, null);
            }
        }
        if (text.getHalo() != null) {
            text.getHalo().accept(this);
        }
        if (text.getLabel() != null) {
            text.getLabel().accept((ExpressionVisitor)this, null);
        }
        if (text.getLabelPlacement() != null) {
            text.getLabelPlacement().accept(this);
        }
        if (text.getPriority() != null) {
            text.getPriority().accept((ExpressionVisitor)this, null);
        }
    }

    @Override
    public void visit(Graphic gr) {
        if (gr.getSymbols() != null) {
            Symbol[] symbols = gr.getSymbols();
            for (int i = 0; i < symbols.length; ++i) {
                Symbol symbol = symbols[i];
                symbol.accept(this);
            }
        }
        if (gr.getOpacity() != null) {
            gr.getOpacity().accept((ExpressionVisitor)this, null);
        }
        if (gr.getRotation() != null) {
            gr.getRotation().accept((ExpressionVisitor)this, null);
        }
        if (gr.getSize() != null) {
            gr.getSize().accept((ExpressionVisitor)this, null);
        }
        if (gr.getDisplacement() != null) {
            gr.getDisplacement().accept(this);
        }
        if (gr.getAnchorPoint() != null) {
            gr.getAnchorPoint().accept(this);
        }
    }

    @Override
    public void visit(Mark mark) {
        if (mark.getFill() != null) {
            mark.getFill().accept(this);
        }
        if (mark.getStroke() != null) {
            mark.getStroke().accept(this);
        }
        if (mark.getWellKnownName() != null) {
            if (mark.getWellKnownName() instanceof Literal) {
                this.visitCqlExpression((String)mark.getWellKnownName().evaluate(null, String.class));
            } else {
                mark.getWellKnownName().accept((ExpressionVisitor)this, null);
            }
        }
    }

    private void visitCqlExpression(String expression) {
        Expression parsed = ExpressionExtractor.extractCqlExpressions(expression);
        if (parsed != null) {
            parsed.accept((ExpressionVisitor)this, null);
        }
    }

    @Override
    public void visit(ExternalGraphic exgr) {
        this.visitCqlExpression(exgr.getFormat());
        try {
            if (exgr.getLocation() != null) {
                this.visitCqlExpression(exgr.getLocation().toString());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Errors while inspecting the location of an external graphic", e);
        }
    }

    @Override
    public void visit(PointPlacement pp) {
        if (pp.getAnchorPoint() != null) {
            pp.getAnchorPoint().accept(this);
        }
        if (pp.getDisplacement() != null) {
            pp.getDisplacement().accept(this);
        }
        if (pp.getRotation() != null) {
            pp.getRotation().accept((ExpressionVisitor)this, null);
        }
    }

    @Override
    public void visit(AnchorPoint ap) {
        if (ap.getAnchorPointX() != null) {
            ap.getAnchorPointX().accept((ExpressionVisitor)this, null);
        }
        if (ap.getAnchorPointY() != null) {
            ap.getAnchorPointY().accept((ExpressionVisitor)this, null);
        }
    }

    @Override
    public void visit(Displacement dis) {
        if (dis.getDisplacementX() != null) {
            dis.getDisplacementX().accept((ExpressionVisitor)this, null);
        }
        if (dis.getDisplacementY() != null) {
            dis.getDisplacementY().accept((ExpressionVisitor)this, null);
        }
    }

    @Override
    public void visit(LinePlacement lp) {
        if (lp.getPerpendicularOffset() != null) {
            lp.getPerpendicularOffset().accept((ExpressionVisitor)this, null);
        }
    }

    @Override
    public void visit(Halo halo) {
        if (halo.getFill() != null) {
            halo.getFill().accept(this);
        }
        if (halo.getRadius() != null) {
            halo.getRadius().accept((ExpressionVisitor)this, null);
        }
    }

    @Override
    public void visit(StyledLayerDescriptor sld) {
        StyledLayer[] layers = sld.getStyledLayers();
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i] instanceof NamedLayer) {
                ((NamedLayer)layers[i]).accept(this);
                continue;
            }
            if (!(layers[i] instanceof UserLayer)) continue;
            ((UserLayer)layers[i]).accept(this);
        }
    }

    @Override
    public void visit(NamedLayer layer) {
        Style[] styles = layer.getStyles();
        for (int i = 0; i < styles.length; ++i) {
            styles[i].accept(this);
        }
    }

    @Override
    public void visit(UserLayer layer) {
        Style[] styles = layer.getUserStyles();
        for (int i = 0; i < styles.length; ++i) {
            styles[i].accept(this);
        }
    }

    @Override
    public void visit(FeatureTypeConstraint ftc) {
        ftc.accept(this);
    }

    @Override
    public void visit(ColorMap map) {
        ColorMapEntry[] entries = map.getColorMapEntries();
        for (int i = 0; i < entries.length; ++i) {
            entries[i].accept(this);
        }
    }

    @Override
    public void visit(ColorMapEntry entry) {
        entry.accept(this);
    }

    @Override
    public void visit(ContrastEnhancement contrastEnhancement) {
        contrastEnhancement.accept(this);
    }

    @Override
    public void visit(ImageOutline outline) {
        outline.getSymbolizer().accept(this);
    }

    @Override
    public void visit(ChannelSelection cs) {
        cs.accept(this);
    }

    @Override
    public void visit(OverlapBehavior ob) {
        ob.accept(this);
    }

    @Override
    public void visit(SelectedChannelType sct) {
        sct.accept(this);
    }

    @Override
    public void visit(ShadedRelief sr) {
        sr.accept(this);
    }
}

