/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.List;
import org.geotools.styling.Font;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.VolatileFunction;

public class StyleAttributeExtractorTruncated
extends StyleAttributeExtractor
implements StyleVisitor {
    boolean usingVolatileFunctions = false;

    public StyleAttributeExtractorTruncated() {
        this.setSymbolizerGeometriesVisitEnabled(false);
    }

    @Override
    public void clear() {
        super.clear();
        this.usingVolatileFunctions = false;
    }

    public boolean isUsingVolatileFunctions() {
        return this.usingVolatileFunctions;
    }

    @Override
    public Object visit(Function expression, Object data) {
        this.usingVolatileFunctions |= expression instanceof VolatileFunction;
        return super.visit(expression, data);
    }

    @Override
    public void visit(TextSymbolizer text) {
        if (text instanceof TextSymbolizer2 && ((TextSymbolizer2)text).getGraphic() != null) {
            ((TextSymbolizer2)text).getGraphic().accept(this);
        }
        if (text.getFill() != null) {
            text.getFill().accept(this);
        }
        if (text.getHalo() != null) {
            text.getHalo().accept(this);
        }
        if (text.fonts() != null) {
            List<Font> fonts = text.fonts();
            for (Font font : fonts) {
                if (font.getFamily() != null) {
                    for (Expression family : font.getFamily()) {
                        family.accept((ExpressionVisitor)this, null);
                    }
                }
                if (font.getSize() != null) {
                    font.getSize().accept((ExpressionVisitor)this, null);
                }
                if (font.getStyle() != null) {
                    font.getStyle().accept((ExpressionVisitor)this, null);
                }
                if (font.getWeight() == null) continue;
                font.getWeight().accept((ExpressionVisitor)this, null);
            }
        }
        if (text.getHalo() != null) {
            text.getHalo().accept(this);
        }
        if (text.getLabelPlacement() != null) {
            text.getLabelPlacement().accept(this);
        }
    }
}

