/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.swing;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;

public class NavControl2
extends JComponent {
    private static final int W = 100;
    private static final int H = 120;
    private static final Dimension SIZE = new Dimension(100, 120);
    private final double pannerHandleW = 10.0;
    private final double pannerHandleH = 10.0;
    private final double scaleHandleW = 5.0;
    private final double scaleHandleH = 16.0;
    private final double gap = 4.0;
    private static final int TIMER_DELAY = 50;
    private double rotationAngle;
    private double pannerHandleOffsetX;
    private double pannerHandleOffsetY;
    private double scaleHandleOffsetX;
    private double scaleHandleOffsetY;
    private Ellipse2D outerWheelCircle;
    private Ellipse2D innerWheelCircle;
    private Ellipse2D outerMoveCircle;
    private Shape pannerHandle;
    private Shape[] moveArrowShapes;
    private Area[] rotationUnitShapes;
    private RectangularShape scaleHandle;
    private RectangularShape scaleBar;
    private BufferedImage backgroundImage;
    private BufferedImage rotationWheelImage;
    private BufferedImage pannerHandleImage;
    private BufferedImage scaleHandleImage;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_ROT = 1;
    private static final int ACTION_SCALE = 2;
    private static final int ACTION_PAN = 3;
    private static final int ACTION_MOVE_N = 4;
    private static final int ACTION_MOVE_S = 5;
    private static final int ACTION_MOVE_W = 6;
    private static final int ACTION_MOVE_E = 7;
    private static final int[] ACTION_MOVE_DIRS = new int[]{4, 5, 6, 7};
    private static final double[] X_DIRS = new double[]{0.0, -1.0, 0.0, 1.0};
    private static final double[] Y_DIRS = new double[]{1.0, 0.0, -1.0, 0.0};

    public NavControl2() {
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.setBounds(0, 0, 100, 120);
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double rotationAngle) {
        double oldRotationAngle = this.rotationAngle;
        if (oldRotationAngle != rotationAngle) {
            this.rotationAngle = rotationAngle;
            this.firePropertyChange("rotationAngle", oldRotationAngle, rotationAngle);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return SIZE;
    }

    @Override
    public Dimension getMinimumSize() {
        return SIZE;
    }

    @Override
    public Dimension getMaximumSize() {
        return SIZE;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D graphics2D = (Graphics2D)g;
        AffineTransform oldTransform = graphics2D.getTransform();
        graphics2D.setStroke(new BasicStroke(0.5f));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.rotate(-1.5707963267948966 - Math.toRadians(this.getRotationAngle()), this.outerWheelCircle.getCenterX(), this.outerWheelCircle.getCenterY());
        for (int i = 0; i < this.rotationUnitShapes.length; ++i) {
            graphics2D.setColor(i == 0 ? Color.ORANGE : Color.WHITE);
            graphics2D.fill(this.rotationUnitShapes[i]);
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(this.rotationUnitShapes[i]);
        }
        graphics2D.setTransform(oldTransform);
        for (Shape arrow : this.moveArrowShapes) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(arrow);
            graphics2D.setColor(Color.BLACK);
            graphics2D.draw(arrow);
        }
        graphics2D.translate(this.pannerHandleOffsetX, this.pannerHandleOffsetY);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(this.pannerHandle);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.pannerHandle);
        graphics2D.setTransform(oldTransform);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(this.scaleBar);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.scaleBar);
        graphics2D.translate(this.scaleHandleOffsetX, this.scaleHandleOffsetY);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(this.scaleHandle);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(this.scaleHandle);
        graphics2D.setTransform(oldTransform);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getAction(x, y) != 0;
    }

    private void initGeom() {
        Insets insets = this.getInsets();
        double x = 1.0;
        double y = 1.0;
        double outerRotationDiameter = 98.0;
        double innerRotationDiameter = 78.4;
        double outerMoveDiameter = 39.2;
        this.outerWheelCircle = new Ellipse2D.Double(x, y, 98.0, 98.0);
        this.innerWheelCircle = new Ellipse2D.Double(this.outerWheelCircle.getCenterX() - 39.2, this.outerWheelCircle.getCenterY() - 39.2, 78.4, 78.4);
        this.outerMoveCircle = new Ellipse2D.Double(this.innerWheelCircle.getCenterX() - 19.6, this.innerWheelCircle.getCenterY() - 19.6, 39.2, 39.2);
        this.rotationUnitShapes = this.createRotationUnitShapes();
        this.moveArrowShapes = this.createMoveArrows();
        this.pannerHandle = this.createPanHandle();
        double scaleBarW = 98.0;
        double scaleBarH = 5.0;
        double scaleBarX = x;
        double scaleHandleY = y + 98.0 + 4.0;
        this.scaleBar = new Rectangle2D.Double(scaleBarX, scaleHandleY + 5.5, 98.0, 5.0);
        this.scaleHandle = new Rectangle2D.Double(scaleBarX + 46.5, scaleHandleY, 5.0, 16.0);
        this.scaleHandleImage = new BufferedImage(16, 16, 2);
        this.backgroundImage = new BufferedImage(100, 120, 2);
        Graphics2D g1 = this.backgroundImage.createGraphics();
        g1.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g1.setStroke(new BasicStroke(1.0f));
        for (Shape arrow : this.moveArrowShapes) {
            g1.setColor(Color.WHITE);
            g1.fill(arrow);
            g1.setColor(Color.BLACK);
            g1.draw(arrow);
        }
        g1.setColor(Color.WHITE);
        g1.fill(this.scaleBar);
        g1.setColor(Color.BLACK);
        g1.draw(this.scaleBar);
        g1.dispose();
        this.rotationWheelImage = new BufferedImage(100, 100, 2);
        Graphics2D g2 = this.backgroundImage.createGraphics();
        AffineTransform oldTransform = g2.getTransform();
        g2.setStroke(new BasicStroke(1.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.rotate(-1.5707963267948966 - Math.toRadians(this.getRotationAngle()), this.outerWheelCircle.getCenterX(), this.outerWheelCircle.getCenterY());
        for (int i = 0; i < this.rotationUnitShapes.length; ++i) {
            g2.setColor(i == 0 ? Color.ORANGE : Color.WHITE);
            g2.fill(this.rotationUnitShapes[i]);
            g2.setColor(Color.BLACK);
            g2.draw(this.rotationUnitShapes[i]);
        }
        g2.setTransform(oldTransform);
        g2.dispose();
        this.pannerHandleImage = new BufferedImage(100, 100, 2);
        Graphics2D g3 = this.backgroundImage.createGraphics();
        g3.setColor(Color.WHITE);
        g3.fill(this.pannerHandle);
        g3.setColor(Color.BLACK);
        g3.draw(this.pannerHandle);
        g3.dispose();
        g2.setColor(Color.WHITE);
        g2.fill(this.scaleBar);
        g2.setColor(Color.BLACK);
        g2.draw(this.scaleBar);
        g2.translate(this.scaleHandleOffsetX, this.scaleHandleOffsetY);
        g2.setColor(Color.WHITE);
        g2.fill(this.scaleHandle);
        g2.setColor(Color.BLACK);
        g2.draw(this.scaleHandle);
        g2.setTransform(oldTransform);
    }

    private Shape createPanHandle() {
        Rectangle2D.Double r1 = new Rectangle2D.Double(-5.0, -5.0, 10.0, 10.0);
        Shape r2 = AffineTransform.getRotateInstance(0.7853981633974483).createTransformedShape(r1);
        Area area = new Area(r1);
        area.add(new Area(r2));
        return AffineTransform.getTranslateInstance(this.innerWheelCircle.getCenterX(), this.innerWheelCircle.getCenterY()).createTransformedShape(area);
    }

    private Shape[] createMoveArrows() {
        double innerRadius = 0.5 * this.innerWheelCircle.getWidth();
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(2.0f, 1.0f);
        path.lineTo(1.0f, 1.0f);
        path.lineTo(1.0f, 2.0f);
        path.lineTo(-1.0f, 2.0f);
        path.lineTo(-1.0f, 1.0f);
        path.lineTo(-2.0f, 1.0f);
        path.closePath();
        Shape[] arrows = new Shape[4];
        for (int i = 0; i < 4; ++i) {
            AffineTransform at = new AffineTransform();
            at.rotate((double)i * 0.5 * Math.PI, this.innerWheelCircle.getCenterX(), this.innerWheelCircle.getCenterY());
            at.translate(this.innerWheelCircle.getCenterX(), this.innerWheelCircle.getCenterY() - 0.95 * innerRadius);
            at.scale(0.2 * innerRadius, 0.3 * innerRadius);
            Area area = new Area(at.createTransformedShape(path));
            area.subtract(new Area(this.outerMoveCircle));
            arrows[i] = area;
        }
        return arrows;
    }

    private Area[] createRotationUnitShapes() {
        Area[] areas = new Area[36];
        Area rhs = new Area(this.innerWheelCircle);
        for (int i = 0; i < 36; ++i) {
            Arc2D.Double arc = new Arc2D.Double(this.outerWheelCircle.getX(), this.outerWheelCircle.getY(), this.outerWheelCircle.getWidth(), this.outerWheelCircle.getHeight(), (double)(i * 10) - 3.5, 7.0, 2);
            Area area = new Area(arc);
            area.subtract(rhs);
            areas[i] = area;
        }
        return areas;
    }

    public void addSelectionListener(SelectionListener l) {
        this.listenerList.add(SelectionListener.class, l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.listenerList.remove(SelectionListener.class, l);
    }

    public SelectionListener[] getSelectionListeners() {
        return (SelectionListener[])this.listenerList.getListeners(SelectionListener.class);
    }

    protected void fireRotate(double rotationAngle) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SelectionListener.class) continue;
            ((SelectionListener)listeners[i + 1]).handleRotate(rotationAngle);
        }
    }

    protected void fireMove(double moveDirX, double moveDirY) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SelectionListener.class) continue;
            ((SelectionListener)listeners[i + 1]).handleMove(moveDirX, moveDirY);
        }
    }

    protected void fireScale(double scaleDir) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SelectionListener.class) continue;
            ((SelectionListener)listeners[i + 1]).handleScale(scaleDir);
        }
    }

    private double getAngle(Point point) {
        double a = Math.atan2(-((double)point.y - this.innerWheelCircle.getCenterY()), (double)point.x - this.innerWheelCircle.getCenterX());
        return NavControl2.normaliseAngle(a - 1.5707963267948966);
    }

    private static double normaliseAngle(double a) {
        while (a < 0.0) {
            a += Math.PI * 2;
        }
        if ((a %= Math.PI * 2) > Math.PI) {
            a += Math.PI * -2;
        }
        return a;
    }

    int getAction(int x, int y) {
        if (super.contains(x, y)) {
            if (this.outerWheelCircle.contains(x, y) && !this.innerWheelCircle.contains(x, y)) {
                return 1;
            }
            if (this.pannerHandle.contains(x, y)) {
                return 3;
            }
            if (this.scaleHandle.contains(x, y) || this.scaleBar.contains(x, y)) {
                return 2;
            }
            for (int i = 0; i < this.moveArrowShapes.length; ++i) {
                Shape moveArrowShape = this.moveArrowShapes[i];
                if (!moveArrowShape.contains(x, y)) continue;
                return ACTION_MOVE_DIRS[i];
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("NavControl");
        JPanel panel = new JPanel(new BorderLayout(3, 3));
        panel.setBackground(Color.GRAY);
        final JLabel label = new JLabel("Angle: ");
        NavControl2 navControl = new NavControl2();
        navControl.addSelectionListener(new SelectionListener(){

            @Override
            public void handleRotate(double rotationAngle) {
                label.setText("Angle: " + rotationAngle);
                System.out.println("NavControl: rotationAngle = " + rotationAngle);
            }

            @Override
            public void handleMove(double moveDirX, double moveDirY) {
                System.out.println("NavControl: moveDirX = " + moveDirX + ", moveDirY = " + moveDirY);
            }

            @Override
            public void handleScale(double scaleDir) {
                System.out.println("NavControl: scaleDir = " + scaleDir);
            }
        });
        navControl.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add((Component)label, "South");
        panel.add((Component)navControl, "Center");
        frame.add(panel);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private class I {
        int x0;
        int y0;
        BufferedImage image;
        Shape shape;
        Shape testShape;

        private I(int x0, int y0, BufferedImage image, Shape shape) {
            this.x0 = x0;
            this.y0 = y0;
            this.image = image;
            this.shape = shape;
        }

        private void draw(Graphics2D g) {
            g.drawImage(this.image, null, this.x0, this.y0);
        }

        private boolean contains(int x, int y) {
            return this.testShape.contains((double)(x - this.x0) - 0.5 * (double)this.image.getWidth(), (double)(y - this.y0) - 0.5 * (double)this.image.getHeight());
        }
    }

    private class MouseHandler
    extends MouseInputAdapter
    implements ActionListener {
        private Point point0;
        private double rotationAngle0;
        private double moveDirX;
        private double moveDirY;
        private double moveAcc;
        private double scaleDir;
        private double scaleAcc;
        private Cursor cursor0;
        private final Timer actionTrigger = new Timer(50, this);
        private int action = 0;

        private MouseHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.action == 3 || this.action == 4 || this.action == 5 || this.action == 6 || this.action == 7) {
                this.fireAcceleratedMove();
            } else if (this.action == 2) {
                this.fireAcceleratedScale();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.cursor0 = NavControl2.this.getCursor();
            this.point0 = e.getPoint();
            this.moveAcc = 1.0;
            this.scaleAcc = 1.0;
            this.action = NavControl2.this.getAction(e.getX(), e.getY());
            if (this.action == 1) {
                this.rotationAngle0 = NavControl2.this.getRotationAngle();
            } else if (this.action == 2) {
                this.doScale(e);
            } else if (this.action == 4) {
                this.startMove(0);
            } else if (this.action == 5) {
                this.startMove(1);
            } else if (this.action == 6) {
                this.startMove(2);
            } else if (this.action == 7) {
                this.startMove(3);
            }
            if (this.action != 0) {
                NavControl2.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.action == 1) {
                this.doRotate(e);
            } else if (this.action == 3) {
                this.doPan(e);
            } else if (this.action == 2) {
                this.doScale(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.stopAction();
        }

        private void doScale(MouseEvent e) {
            double a;
            Point point = e.getPoint();
            double dx = (double)point.x - NavControl2.this.scaleBar.getCenterX();
            if (dx < -(a = 0.5 * (NavControl2.this.scaleBar.getWidth() - NavControl2.this.scaleHandle.getWidth()))) {
                dx = -a;
            }
            if (dx > a) {
                dx = a;
            }
            NavControl2.this.scaleHandleOffsetX = dx;
            NavControl2.this.scaleHandleOffsetY = 0.0;
            this.scaleDir = dx / a;
            this.scaleAcc = 1.0;
            this.fireAcceleratedScale();
            this.startTriggeringActions();
        }

        private void startTriggeringActions() {
            System.out.println("NavControl.startTriggeringActions() >>>");
            this.actionTrigger.restart();
        }

        private void stopTriggeringActions() {
            System.out.println("NavControl.stopTriggeringActions() <<<");
            this.actionTrigger.stop();
        }

        private void doPan(MouseEvent e) {
            double dy;
            Point point = e.getPoint();
            double outerMoveRadius = 0.5 * NavControl2.this.outerMoveCircle.getWidth();
            double dx = (double)point.x - NavControl2.this.outerMoveCircle.getCenterX();
            double r = Math.sqrt(dx * dx + (dy = (double)point.y - NavControl2.this.outerMoveCircle.getCenterY()) * dy);
            if (r > outerMoveRadius) {
                dx = outerMoveRadius * dx / r;
                dy = outerMoveRadius * dy / r;
            }
            NavControl2.this.pannerHandleOffsetX = dx;
            NavControl2.this.pannerHandleOffsetY = dy;
            this.moveDirX = -dx / outerMoveRadius;
            this.moveDirY = -dy / outerMoveRadius;
            this.moveAcc = 1.0;
            this.fireAcceleratedMove();
            this.startTriggeringActions();
        }

        void startMove(int dir) {
            this.moveDirX = X_DIRS[dir];
            this.moveDirY = Y_DIRS[dir];
            this.doMove();
        }

        private void doMove() {
            this.moveAcc = 1.0;
            this.startTriggeringActions();
        }

        private void doRotate(MouseEvent e) {
            double a1 = NavControl2.this.getAngle(this.point0);
            double a2 = NavControl2.this.getAngle(e.getPoint());
            double a = Math.toDegrees(NavControl2.normaliseAngle(Math.toRadians(this.rotationAngle0) + (a2 - a1)));
            if (e.isControlDown()) {
                double t = 22.5;
                a = t * Math.floor(a / t);
            }
            NavControl2.this.setRotationAngle(a);
            NavControl2.this.repaint();
            NavControl2.this.fireRotate(a);
        }

        private void fireAcceleratedScale() {
            NavControl2.this.fireScale(this.scaleAcc * this.scaleDir / 4.0);
            this.scaleAcc *= 1.1;
            if (this.scaleAcc > 4.0) {
                this.scaleAcc = 4.0;
            }
        }

        private void fireAcceleratedMove() {
            NavControl2.this.fireMove(this.moveAcc * this.moveDirX, this.moveAcc * this.moveDirY);
            this.moveAcc *= 1.05;
            if (this.moveAcc > 4.0) {
                this.moveAcc = 4.0;
            }
        }

        private void stopAction() {
            NavControl2.this.setCursor(this.cursor0);
            this.stopTriggeringActions();
            this.cursor0 = null;
            this.point0 = null;
            this.action = 0;
            this.moveDirX = 0.0;
            this.moveDirY = 0.0;
            this.moveAcc = 1.0;
            NavControl2.this.pannerHandleOffsetX = 0.0;
            NavControl2.this.pannerHandleOffsetY = 0.0;
            this.scaleDir = 0.0;
            this.scaleAcc = 1.0;
            NavControl2.this.scaleHandleOffsetX = 0.0;
            NavControl2.this.scaleHandleOffsetY = 0.0;
            NavControl2.this.repaint();
        }
    }

    public static interface SelectionListener
    extends EventListener {
        public void handleRotate(double var1);

        public void handleMove(double var1, double var3);

        public void handleScale(double var1);
    }
}

