/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.Timer;

public class WakefulComponent
extends JComponent {
    private static final int PPS = 20;
    private float currentAlpha;
    private float minAlpha = 0.2f;
    private float maxAlpha = 0.8f;
    private int activationTime = 400;
    private int deactivationTime = 200;
    private int waitingTime = 700;
    private VisualState visualState;
    private long lastHitTimestamp;
    private final Timer timer;
    private final ChildResizeHandler childResizeHandler;
    private BufferedImage image;
    private Graphics2D imageGraphics;
    private HitHandler hitHandler;

    public WakefulComponent() {
        this(null);
    }

    public WakefulComponent(JComponent component) {
        this.setOpaque(false);
        this.childResizeHandler = new ChildResizeHandler();
        this.visualState = VisualState.INACTIVE;
        this.timer = new Timer(0, new TimerListener());
        this.timer.setInitialDelay(0);
        this.timer.setRepeats(true);
        this.hitHandler = new HitHandler();
        this.currentAlpha = this.minAlpha;
        if (component != null) {
            this.add(component);
            Dimension preferredSize = component.getPreferredSize();
            this.setPreferredSize(preferredSize);
            this.installHitHandler(component);
        } else {
            this.installHitHandler(this);
        }
    }

    public int getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(int activationTime) {
        this.activationTime = activationTime;
    }

    public int getDeactivationTime() {
        return this.deactivationTime;
    }

    public void setDeactivationTime(int deactivationTime) {
        this.deactivationTime = deactivationTime;
    }

    public int getWaitingTime() {
        return this.waitingTime;
    }

    public void setWaitingTime(int waitingTime) {
        this.waitingTime = waitingTime;
    }

    public float getCurrentAlpha() {
        return this.currentAlpha;
    }

    protected void setCurrentAlpha(float currentAlpha) {
        this.currentAlpha = currentAlpha;
        this.repaint();
    }

    public float getMinAlpha() {
        return this.minAlpha;
    }

    public void setMinAlpha(float minAlpha) {
        this.minAlpha = minAlpha;
    }

    public float getMaxAlpha() {
        return this.maxAlpha;
    }

    public void setMaxAlpha(float maxAlpha) {
        this.maxAlpha = maxAlpha;
    }

    public VisualState getVisualState() {
        return this.visualState;
    }

    protected void setVisualState(VisualState visualState) {
        VisualState oldState = this.getVisualState();
        if (oldState != visualState) {
            this.visualState = visualState;
            this.firePropertyChange("visualState", (Object)oldState, (Object)visualState);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.imageGraphics != null) {
            this.imageGraphics.dispose();
        }
        this.image = new BufferedImage(this.getWidth(), this.getHeight(), 6);
        this.imageGraphics = this.image.createGraphics();
        this.imageGraphics.setBackground(new Color(0, 0, 0, 0));
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component component : this.getComponents()) {
            component.setEnabled(enabled);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        comp.addComponentListener(this.childResizeHandler);
        this.adaptSize(comp);
        this.installHitHandler(comp);
    }

    @Override
    public void remove(int index) {
        Component comp = this.getComponent(index);
        comp.removeComponentListener(this.childResizeHandler);
        this.deinstallHitHandler(comp);
        super.remove(index);
    }

    @Override
    public final LayoutManager getLayout() {
        return super.getLayout();
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
        if (mgr == null) {
            throw new IllegalArgumentException("mgr");
        }
        super.setLayout(mgr);
    }

    @Override
    public final void doLayout() {
        super.doLayout();
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isEnabled()) {
            return;
        }
        this.imageGraphics.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
        Object oldAntialias = this.imageGraphics.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        this.imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(this.imageGraphics);
        if (oldAntialias != null) {
            this.imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialias);
        }
        Graphics2D g2d = (Graphics2D)g;
        Composite oldComposite = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, Math.min(1.0f, this.currentAlpha)));
        g2d.drawRenderedImage(this.image, null);
        if (oldComposite != null) {
            g2d.setComposite(oldComposite);
        }
    }

    private void installHitHandler(Component comp) {
        comp.addMouseListener(this.hitHandler);
        comp.addMouseMotionListener(this.hitHandler);
    }

    private void deinstallHitHandler(Component comp) {
        comp.removeMouseListener(this.hitHandler);
        comp.removeMouseMotionListener(this.hitHandler);
    }

    private void adaptSize(Component comp) {
        Rectangle r = new Rectangle();
        r.add(this.getBounds());
        r.add(comp.getBounds());
        this.setSize(r.width, r.height);
    }

    private class ChildResizeHandler
    extends ComponentAdapter {
        private ChildResizeHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            WakefulComponent.this.adaptSize(e.getComponent());
        }
    }

    private class TimerListener
    implements ActionListener {
        private int counter;

        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WakefulComponent.this.getVisualState() == VisualState.ACTIVE) {
                long timestamp = System.currentTimeMillis();
                if (WakefulComponent.this.lastHitTimestamp > 0L && timestamp - WakefulComponent.this.lastHitTimestamp > (long)WakefulComponent.this.waitingTime) {
                    WakefulComponent.this.setVisualState(VisualState.DEACTIVATING);
                    WakefulComponent.this.timer.setDelay(WakefulComponent.this.deactivationTime / 20);
                    WakefulComponent.this.timer.restart();
                }
            } else if (WakefulComponent.this.getVisualState() != VisualState.INACTIVE) {
                float weight = (float)this.counter / 20.0f;
                if (WakefulComponent.this.getVisualState() == VisualState.ACTIVATING) {
                    if (this.counter < 20) {
                        WakefulComponent.this.setCurrentAlpha(WakefulComponent.this.minAlpha + (WakefulComponent.this.maxAlpha - WakefulComponent.this.minAlpha) * weight);
                        ++this.counter;
                    } else {
                        WakefulComponent.this.setCurrentAlpha(WakefulComponent.this.maxAlpha);
                        WakefulComponent.this.setVisualState(VisualState.ACTIVE);
                        this.counter = 0;
                    }
                } else if (WakefulComponent.this.getVisualState() == VisualState.DEACTIVATING) {
                    if (this.counter < 20) {
                        WakefulComponent.this.setCurrentAlpha(WakefulComponent.this.minAlpha + (WakefulComponent.this.maxAlpha - WakefulComponent.this.minAlpha) * (1.0f - weight));
                        ++this.counter;
                    } else {
                        WakefulComponent.this.setCurrentAlpha(WakefulComponent.this.minAlpha);
                        WakefulComponent.this.setVisualState(VisualState.INACTIVE);
                        WakefulComponent.this.timer.stop();
                        this.counter = 0;
                    }
                }
            }
        }
    }

    private class HitHandler
    extends MouseAdapter {
        private HitHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (WakefulComponent.this.getVisualState() == VisualState.INACTIVE) {
                WakefulComponent.this.setVisualState(VisualState.ACTIVATING);
                WakefulComponent.this.timer.setDelay(WakefulComponent.this.activationTime / 20);
                WakefulComponent.this.timer.restart();
            }
            WakefulComponent.this.lastHitTimestamp = -1L;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            WakefulComponent.this.lastHitTimestamp = System.currentTimeMillis();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            WakefulComponent.this.lastHitTimestamp = -1L;
        }
    }

    public static enum VisualState {
        INACTIVE,
        ACTIVATING,
        ACTIVE,
        DEACTIVATING;

    }
}

