/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.tools;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.glevel.support.FileMultiLevelSource;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.media.jai.ImageLayout;
import javax.media.jai.ImageMIPMap;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.AffineDescriptor;
import javax.media.jai.operator.FileLoadDescriptor;
import javax.media.jai.operator.FileStoreDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import javax.media.jai.operator.ScaleDescriptor;
import javax.media.jai.util.ImagingListener;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class Tools {
    public static void configureJAI() {
        JAI.getDefaultInstance().setImagingListener(new ImagingListener(){

            public boolean errorOccurred(String message, Throwable thrown, Object where, boolean isRetryable) throws RuntimeException {
                System.out.println("JAI error occurred: " + message);
                return false;
            }
        });
        long memoryCapacity = 0x10000000L;
        JAI.getDefaultInstance().getTileCache().setMemoryCapacity(0x10000000L);
        JAI.getDefaultInstance().getTileCache().setMemoryThreshold(0.75f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AffineTransform loadWorldFile(String filename) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filename));){
            double[] flatMatrix = new double[6];
            new AffineTransform().getMatrix(flatMatrix);
            for (int i = 0; i < flatMatrix.length; ++i) {
                String parameter = reader.readLine();
                if (parameter == null) {
                    throw new IOException("Could not read world file: Missing a parameter.");
                }
                try {
                    flatMatrix[i] = Double.valueOf(parameter);
                    continue;
                }
                catch (NumberFormatException e) {
                    IOException ioException = new IOException("Could not read world file. " + e.getMessage());
                    ioException.initCause(e);
                    throw ioException;
                }
            }
            AffineTransform affineTransform = new AffineTransform(flatMatrix);
            return affineTransform;
        }
    }

    public static RenderedOp createMosaic(RenderedImage[] images) {
        return MosaicDescriptor.create((RenderedImage[])images, (MosaicType)MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])null, (double[])new double[]{0.0}, null);
    }

    public static void storeTiledTiff(RenderedImage image, String filePath) {
        TIFFEncodeParam encodeParam = new TIFFEncodeParam();
        encodeParam.setTileSize(image.getTileWidth(), image.getTileHeight());
        encodeParam.setWriteTiled(true);
        encodeParam.setCompression(32946);
        System.out.println("Storing tiled TIFF image to " + filePath + "...");
        FileStoreDescriptor.create((RenderedImage)image, (String)filePath, (String)"TIFF", (ImageEncodeParam)encodeParam, (Boolean)false, null);
    }

    public static RenderedOp scaleImage(RenderedImage image, float scale) {
        Interpolation interpol = Interpolation.getInstance((int)0);
        return ScaleDescriptor.create((RenderedImage)image, (Float)Float.valueOf(scale), (Float)Float.valueOf(scale), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)interpol, null);
    }

    public static RenderedOp transformImage(RenderedImage image, double x0, double y0, double theta, double scale) {
        AffineTransform transform = new AffineTransform();
        transform.rotate(theta, -0.5f * (float)image.getWidth(), -0.5f * (float)image.getHeight());
        transform.scale(scale, scale);
        transform.translate(x0, y0);
        return Tools.transformImage(image, transform);
    }

    public static RenderedOp transformImage(RenderedImage image, AffineTransform transform) {
        return AffineDescriptor.create((RenderedImage)image, (AffineTransform)transform, (Interpolation)Interpolation.getInstance((int)0), (double[])new double[]{0.0}, null);
    }

    public static RenderedOp createTiledImage(RenderedImage image, int tileWidth, int tileHeight) {
        int dataType = image.getSampleModel().getDataType();
        ImageLayout imageLayout = new ImageLayout();
        imageLayout.setTileWidth(tileWidth);
        imageLayout.setTileHeight(tileHeight);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        return FormatDescriptor.create((RenderedImage)image, (Integer)dataType, (RenderingHints)hints);
    }

    public static RenderedOp loadImage(String filePath) {
        System.out.println("Loading image from " + filePath);
        return FileLoadDescriptor.create((String)filePath, null, (Boolean)true, null);
    }

    public static void displayImage(File location, String extension, AffineTransform imageToModelTransform, int levelCount) {
        LayerCanvas layerCanvas = new LayerCanvas();
        Tools.installLayerCanvasNavigation(layerCanvas);
        Layer collectionLayer = layerCanvas.getLayer();
        FileMultiLevelSource source = FileMultiLevelSource.create(location, extension, imageToModelTransform, levelCount);
        ImageLayer layer = new ImageLayer(source);
        collectionLayer.getChildren().add(layer);
        Rectangle viewportBounds = new Rectangle(0, 0, 640, 480);
        layerCanvas.setPreferredSize(new Dimension(640, 480));
        layerCanvas.getViewport().setViewBounds(viewportBounds);
        layerCanvas.getViewport().zoom(layer.getModelBounds());
        Tools.openFrame(layerCanvas, location.getPath(), viewportBounds);
    }

    public static void displayImage(String title, RenderedImage image, AffineTransform imageToModelTransform, int levelCount) {
        Tools.displayImages(title, new RenderedImage[]{image}, new AffineTransform[]{imageToModelTransform}, levelCount);
    }

    public static void displayImages(String title, RenderedImage[] images, AffineTransform[] imageToModelTransforms, int levelCount) {
        LayerCanvas layerCanvas = new LayerCanvas();
        Tools.installLayerCanvasNavigation(layerCanvas);
        Layer collectionLayer = layerCanvas.getLayer();
        for (int i = 0; i < images.length; ++i) {
            ImageLayer layer = new ImageLayer(images[i], imageToModelTransforms[i], levelCount);
            collectionLayer.getChildren().add(layer);
        }
        Tools.openFrame(layerCanvas, title, new Rectangle(0, 0, 512, 512));
    }

    public static void dumpImageInfo(RenderedImage image) {
        SampleModel sampleModel = image.getSampleModel();
        ColorModel colorModel = image.getColorModel();
        System.out.println("image: " + image);
        System.out.println("  minX            = " + image.getMinX());
        System.out.println("  minY            = " + image.getMinY());
        System.out.println("  width           = " + image.getWidth());
        System.out.println("  height          = " + image.getHeight());
        System.out.println("  colorModel      = " + (colorModel != null ? colorModel.getClass() : "null"));
        System.out.println("  colorSpace      = " + (colorModel != null ? colorModel.getColorSpace() : "null"));
        System.out.println("  sampleModel     = " + sampleModel.getClass());
        System.out.println("  numBands        = " + sampleModel.getNumBands());
        System.out.println("  dataType        = " + sampleModel.getDataType());
        System.out.println("  transferType    = " + sampleModel.getTransferType());
        System.out.println("  tileGridXOffset = " + image.getTileGridXOffset());
        System.out.println("  tileGridYOffset = " + image.getTileGridYOffset());
        System.out.println("  minTileX        = " + image.getMinTileX());
        System.out.println("  minTileY        = " + image.getMinTileY());
        System.out.println("  tileWidth       = " + image.getTileWidth());
        System.out.println("  tileHeight      = " + image.getTileHeight());
    }

    public static void storeTiffPyramid(RenderedImage sourceImage, String targetBaseName, int maxLevel) {
        ImageMIPMap imageMIPMap = new ImageMIPMap(sourceImage, AffineTransform.getScaleInstance(0.5, 0.5), Interpolation.getInstance((int)0));
        for (int level = 0; level <= maxLevel; ++level) {
            RenderedImage scaledImage = imageMIPMap.getImage(level);
            Tools.storeTiledTiff(scaledImage, targetBaseName + "." + level + ".tif");
        }
    }

    private static void openFrame(LayerCanvas layerCanvas, String title, Rectangle bounds) {
        JFrame frame = new JFrame(title);
        frame.getContentPane().add((Component)layerCanvas, "Center");
        frame.setBounds(bounds);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public static void installLayerCanvasNavigation(LayerCanvas layerCanvas) {
        layerCanvas.setNavControlShown(true);
        MouseHandler mouseHandler = new MouseHandler(layerCanvas);
        layerCanvas.addMouseListener(mouseHandler);
        layerCanvas.addMouseMotionListener(mouseHandler);
        layerCanvas.addMouseWheelListener(mouseHandler);
    }

    public static class MouseHandler
    extends MouseInputAdapter {
        private LayerCanvas layerCanvas;
        private SliderPopUp sliderPopUp;
        private Point p0;

        private MouseHandler(LayerCanvas layerCanvas) {
            this.layerCanvas = layerCanvas;
            this.sliderPopUp = new SliderPopUp();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.p0 = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, this.layerCanvas);
                this.sliderPopUp.show(point);
            } else {
                this.sliderPopUp.hide();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point p = e.getPoint();
            double dx = p.x - this.p0.x;
            double dy = p.y - this.p0.y;
            this.layerCanvas.getViewport().moveViewDelta(dx, dy);
            this.p0 = p;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int wheelRotation = e.getWheelRotation();
            double newZoomFactor = this.layerCanvas.getViewport().getZoomFactor() * Math.pow(1.1, wheelRotation);
            this.layerCanvas.getViewport().setZoomFactor(newZoomFactor);
        }

        private class SliderPopUp {
            private JWindow window;
            private JSlider slider;

            private SliderPopUp() {
            }

            public void show(Point location) {
                if (this.window == null) {
                    this.initUI();
                }
                double oldZoomFactor = MouseHandler.this.layerCanvas.getViewport().getZoomFactor();
                this.slider.setValue((int)Math.round(10.0 * Math.log(oldZoomFactor) / Math.log(2.0)));
                this.window.setLocation(location);
                this.window.setVisible(true);
            }

            public void hide() {
                if (this.window != null) {
                    this.window.setVisible(false);
                }
            }

            private void initUI() {
                this.window = new JWindow();
                int min = -100;
                int max = 100;
                this.slider = new JSlider(-100, 100);
                this.slider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        double newZoomFactor = Math.pow(2.0, (double)SliderPopUp.this.slider.getValue() / 10.0);
                        MouseHandler.this.layerCanvas.getViewport().setZoomFactor(newZoomFactor);
                        if (!SliderPopUp.this.slider.getValueIsAdjusting()) {
                            SliderPopUp.this.hide();
                        }
                    }
                });
                this.window.requestFocus();
                this.window.setAlwaysOnTop(true);
                this.window.add(this.slider);
                this.window.pack();
                this.window.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        SliderPopUp.this.hide();
                    }
                });
            }
        }
    }
}

